/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.ColoredValueLabel;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.symbols.TextSource;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jfig.canvas.FigCanvasEvent;
import jfig.utils.ExceptionTracer;

public class Counter
extends SimObject
implements Simulatable,
Serializable {
    private PortStdLogic1164 port_D;
    private PortStdLogic1164 port_C;
    private int intValue = 0;
    private int oldValue = 0;
    public static final int _events = 0;
    public static final int _rising = 1;
    public static final int _falling = 2;
    public static final int _U = 3;
    public static final int _X = 4;
    public static final int _0 = 5;
    public static final int _1 = 6;
    public static final int _Z = 7;
    public static final int _L = 8;
    public static final int _H = 9;
    public static final int _W = 10;
    public static final int _D = 11;
    public static final int _0hazards = 12;
    public static final int _1hazards = 13;
    private int activeCounter = 0;
    protected String[] counterNames = new String[]{"events", "rising edges (0->1)", "falling edges (0->1)", "value U", "value X", "value 0", "value 1", "value Z", "value L", "value H", "value W", "value D", "0-hazards", "1-hazards"};
    protected long[] counters = new long[this.counterNames.length];
    protected Label symbolTypeLabel;
    protected ColoredValueLabel symbolValueLabel;
    JFrame topFrame;
    JPanel counterPanel;
    JPanel buttonPanel;
    JLabel valueField;
    JComboBox eventChoice;
    JButton clearAllButton;
    JButton clearSelectedButton;
    JButton closeButton;
    JButton changeNameButton;

    public Counter() {
        this.port_D = new PortStdLogic1164(this, "D", 0, null);
        this.port_C = new PortStdLogic1164(this, "C", 0, null);
        this.ports = new Port[2];
        this.ports[0] = this.port_D;
        this.ports[1] = this.port_C;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    private void initDisplay() {
        this.symbolValueLabel = new ColoredValueLabel();
        this.symbolTypeLabel = new Label();
        this.symbolTypeLabel.initialize("5800 600 3 " + this.counterNames[0]);
        this.symbolTypeLabel.setTextSource(new TypeFormatter());
        this.symbolValueLabel.initialize("5800 1400 3 000");
        this.symbolValueLabel.setColor(Color.black);
        this.symbolValueLabel.setTextSource(new DecimalValueFormatter());
        this.symbol.addMember(this.symbolValueLabel);
        this.symbol.addMember(this.symbolTypeLabel);
        this.updateSymbol();
    }

    public void buildGUI() {
        this.topFrame = new JFrame("Counter " + this.getName());
        this.topFrame.setDefaultCloseOperation(1);
        this.valueField = new JLabel(Counter.formatPaddedLong(this.counters[0], 9));
        this.clearAllButton = new JButton("clear all");
        this.clearSelectedButton = new JButton("clear");
        this.changeNameButton = new JButton("name");
        this.closeButton = new JButton("close");
        this.eventChoice = new JComboBox();
        int i = 0;
        while (i < this.counterNames.length) {
            this.eventChoice.addItem(this.counterNames[i]);
            ++i;
        }
        this.counterPanel = new JPanel(new FlowLayout(0));
        this.counterPanel.add(this.eventChoice);
        this.counterPanel.add(this.valueField);
        this.buttonPanel = new JPanel(new FlowLayout(0));
        this.buttonPanel.add(this.clearSelectedButton);
        this.buttonPanel.add(this.clearAllButton);
        this.buttonPanel.add(new JLabel(" "));
        this.buttonPanel.add(this.changeNameButton);
        this.buttonPanel.add(this.closeButton);
        this.topFrame.getContentPane().add("North", this.counterPanel);
        this.topFrame.getContentPane().add("South", this.buttonPanel);
        this.topFrame.pack();
    }

    public void buildGUICallbacks() {
        this.clearAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Counter.this.clearAllCounters();
            }
        });
        this.clearSelectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Counter.this.clearSelectedCounter();
            }
        });
        this.changeNameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Counter.this.changeName();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Counter.this.topFrame.setVisible(false);
            }
        });
        this.eventChoice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Counter.this.showSelectedCounter();
                Counter.this.updateSymbol();
            }
        });
    }

    public void clearAllCounters() {
        if (SimObject.debug) {
            this.message("-I- clearAllCounters");
        }
        int i = 0;
        while (i < this.counters.length) {
            this.counters[i] = 0L;
            ++i;
        }
        this.showSelectedCounter();
        this.updateSymbol();
    }

    public void clearSelectedCounter() {
        if (SimObject.debug) {
            this.message("-I- clearSelectedCounter");
        }
        if (this.eventChoice == null) {
            return;
        }
        this.counters[this.eventChoice.getSelectedIndex()] = 0L;
        this.showSelectedCounter();
        this.updateSymbol();
    }

    public void showSelectedCounter() {
        if (SimObject.debug) {
            this.message("-I- showSelectedCounter");
        }
        if (this.topFrame != null && this.topFrame.isVisible()) {
            this.activeCounter = this.eventChoice.getSelectedIndex();
            this.valueField.setText(Counter.formatPaddedLong(this.counters[this.activeCounter], 9));
        }
    }

    public long getCounterValue(int index) {
        return this.counters[index];
    }

    public void setCounterValue(int index, long value) {
        this.counters[index] = value;
    }

    public int getMaxCounterIndex() {
        return this.counters.length;
    }

    public void changeName() {
        this.message("-E- Counter.changeName(): NOT IMPLEMENTED YET!");
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.activeCounter);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.activeCounter = Integer.parseInt(st.nextToken());
            if (SimObject.debug) {
                this.message("Counter.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
            ExceptionTracer.message("-E- in Counter.initialize(): " + s);
        }
        return true;
    }

    public void configure() {
        if (this.topFrame == null) {
            this.buildGUI();
            this.buildGUICallbacks();
        }
        this.topFrame.setVisible(true);
        this.showSelectedCounter();
    }

    public Component getPropertySheet() {
        return this.topFrame;
    }

    public void mousePressed(MouseEvent evt) {
        if (!(evt instanceof FigCanvasEvent)) {
            this.message("-E- HADES internal error in Counter: got a MouseEvent that is not a FigCanvasEvent...");
            return;
        }
        Point pos = this.symbol.getPos();
        Point mousepos = ((FigCanvasEvent)evt).getWorldCoordinatePoint();
        int y_offset = mousepos.y - pos.y;
        int x_offset = mousepos.x - pos.x;
        if (y_offset > 1200 && x_offset < 1500) {
            this.clearAllCounters();
        } else if (y_offset < 1200 && x_offset < 1500) {
            this.activeCounter = (this.activeCounter + 1) % this.counters.length;
        } else {
            this.message("-W- Counter: mouse click ignored at that position!");
            return;
        }
        this.showSelectedCounter();
        this.updateSymbol();
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.clearAllCounters();
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        StdLogic1164 value_D = this.port_D.getValueOrU();
        StdLogic1164 value_C = this.port_C.getValueOrU();
        if (value_C.is_1()) {
            this.clearAllCounters();
            this.updateSymbol();
            this.showSelectedCounter();
            return;
        }
        this.oldValue = this.intValue;
        this.intValue = value_D.intValue();
        boolean needsRepaint = false;
        this.counters[0] = this.counters[0] + 1L;
        if (this.activeCounter == 0) {
            needsRepaint = true;
        }
        if (this.intValue == 2 && this.oldValue == 3) {
            this.counters[2] = this.counters[2] + 1L;
            if (this.activeCounter == 2) {
                needsRepaint = true;
            }
        } else if (this.intValue == 3 && this.oldValue == 2) {
            this.counters[1] = this.counters[1] + 1L;
            if (this.activeCounter == 1) {
                needsRepaint = true;
            }
        }
        if (this.intValue == 0) {
            this.counters[3] = this.counters[3] + 1L;
            if (this.activeCounter == 3) {
                needsRepaint = true;
            }
        } else if (this.intValue == 1) {
            this.counters[4] = this.counters[4] + 1L;
            if (this.activeCounter == 4) {
                needsRepaint = true;
            }
        } else if (this.intValue == 2) {
            this.counters[5] = this.counters[5] + 1L;
            if (this.activeCounter == 5) {
                needsRepaint = true;
            }
        } else if (this.intValue == 3) {
            this.counters[6] = this.counters[6] + 1L;
            if (this.activeCounter == 6) {
                needsRepaint = true;
            }
        } else if (this.intValue == 4) {
            this.counters[7] = this.counters[7] + 1L;
            if (this.activeCounter == 7) {
                needsRepaint = true;
            }
        } else if (this.intValue == 5) {
            this.counters[10] = this.counters[10] + 1L;
            if (this.activeCounter == 10) {
                needsRepaint = true;
            }
        } else if (this.intValue == 6) {
            this.counters[8] = this.counters[8] + 1L;
            if (this.activeCounter == 8) {
                needsRepaint = true;
            }
        } else if (this.intValue == 7) {
            this.counters[9] = this.counters[9] + 1L;
            if (this.activeCounter == 9) {
                needsRepaint = true;
            }
        } else if (this.intValue == 8) {
            this.counters[11] = this.counters[11] + 1L;
            if (this.activeCounter == 11) {
                needsRepaint = true;
            }
        } else if (this.intValue == 1) {
            this.counters[4] = this.counters[4] + 1L;
            if (this.activeCounter == 4) {
                needsRepaint = true;
            }
        }
        if (needsRepaint) {
            this.updateSymbol();
            this.showSelectedCounter();
        }
    }

    public static String formatPaddedLong(long value, int n_chars) {
        String raw = Long.toString(value);
        StringBuffer sb = new StringBuffer();
        int n_zeroes = n_chars - raw.length();
        int i = 0;
        while (i < n_zeroes) {
            sb.append('0');
            ++i;
        }
        sb.append(raw);
        return sb.toString();
    }

    private void updateSymbol() {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".updateSymbol: ");
        }
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        this.symbol.painter.paint(this.symbol, 200);
    }

    public SimObject copy() {
        Counter tmp = null;
        try {
            tmp = (Counter)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            return null;
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "events " + this.counters[0] + "\n" + "value _0 " + this.counters[5] + "\n" + "value _1 " + this.counters[6] + "\n" + "_U,_X,_Z " + (this.counters[3] + this.counters[4] + this.counters[7]);
    }

    public String toString() {
        return "Counter: " + this.getFullName();
    }

    public static void main(String[] argv) {
        Counter cc = new Counter();
        cc.buildGUI();
        cc.buildGUICallbacks();
        cc.topFrame.setVisible(true);
    }

    public class DecimalValueFormatter
    implements TextSource {
        public String getText() {
            return Counter.formatPaddedLong(Counter.this.counters[Counter.this.activeCounter], 9);
        }
    }

    public class TypeFormatter
    implements TextSource {
        public String getText() {
            return Counter.this.counterNames[Counter.this.activeCounter];
        }
    }
}

