/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.muxes;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.BboxRectangle;
import hades.symbols.BusPortSymbol;
import hades.symbols.ClassLabel;
import hades.symbols.InstanceLabel;
import hades.symbols.PortLabel;
import hades.symbols.PortSymbol;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;

public class BitDecoder
extends GenericRtlibObject {
    protected int n_outputs;
    protected PortStdLogicVector port_A;
    protected StdLogic1164 value_U = Const1164.__U;
    protected StdLogic1164 value_0 = Const1164.__0;
    protected StdLogic1164 value_1 = Const1164.__1;
    protected StdLogic1164[] values;

    public void constructPorts() {
        if (this.n_bits > 5) {
            this.n_bits = 5;
        }
        this.n_outputs = 1 << this.n_bits;
        this.values = new StdLogic1164[this.n_outputs];
        this.ports = new Port[1 + this.n_outputs];
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.n_bits);
        this.ports[0] = this.port_A;
        int i = 0;
        while (i < this.n_outputs) {
            this.ports[i + 1] = new PortStdLogic1164(this, "Y" + i, 1, null);
            ++i;
        }
    }

    public boolean needsDynamicSymbol() {
        return true;
    }

    public void constructDynamicSymbol() {
        if (SimObject.debug) {
            this.message("-#- BitDecoder.cDS...");
        }
        this.symbol = new Symbol();
        this.symbol.setParent(this);
        this.initDisplay();
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.initDisplay();
    }

    public void initDisplay() {
        PortLabel portLabel;
        int y;
        int x;
        PortSymbol portSymbol;
        if (SimObject.debug) {
            this.message("-#- Register.initDisplay...");
        }
        if (this.symbol != null) {
            this.symbol.deleteAllMembers();
        }
        Point pos = this.symbol.getPos();
        this.symbol.move(-pos.x, -pos.y);
        BboxRectangle bbr = new BboxRectangle();
        int w = 600;
        int xmax = (1 + this.n_outputs) * w;
        bbr.initialize(" 0 0 " + xmax + " 1200");
        Rectangle rr = new Rectangle();
        rr.initialize("  0 0 " + xmax + " 1200");
        InstanceLabel il = new InstanceLabel();
        il.initialize("" + (xmax + 100) + " 450 " + this.getName());
        ClassLabel cl = new ClassLabel();
        cl.initialize("" + (xmax + 100) + " 1150 " + " BitDecoder");
        this.symbol.fastAddMember(cl);
        this.symbol.fastAddMember(bbr);
        this.symbol.fastAddMember(rr);
        this.symbol.fastAddMember(il);
        int i = 0;
        while (i < this.n_outputs) {
            portSymbol = new PortSymbol();
            x = (this.n_outputs - i) * w;
            y = 1200;
            portSymbol.initialize("" + x + " " + y + " Y" + i);
            this.symbol.fastAddMember(portSymbol);
            portLabel = new PortLabel();
            portLabel.initialize("" + x + " " + (y - 150) + " 2 Y" + i);
            this.symbol.fastAddMember(portLabel);
            ++i;
        }
        portSymbol = new BusPortSymbol();
        x = 600;
        y = 0;
        portSymbol.initialize("" + x + " " + y + " A");
        this.symbol.fastAddMember(portSymbol);
        portLabel = new PortLabel();
        portLabel.initialize("" + x + " " + 450 + " 2 A");
        this.symbol.fastAddMember(portLabel);
        this.symbol.update_bbox();
        this.symbol.build_sc_bbox();
        this.symbol.setTrafo(this.symbol.getTrafo());
        this.symbol.setObjectPainter(this.symbol.painter);
        this.symbol.move(pos.x, pos.y);
    }

    public void setWidth(int _n) {
        if (_n == this.getWidth()) {
            return;
        }
        if (this.isConnected()) {
            this.message("-E- Cannot change the width of an connected RTLIB object!");
            return;
        }
        if (this.n_bits < 1 || this.n_bits > 5) {
            this.message("-E- Bus width out of range [1..5], using 5 instead!");
            this.n_bits = 5;
        } else {
            this.n_bits = _n;
        }
        this.constructStandardValues();
        this.constructPorts();
        this.initDisplay();
        this.updateSymbol();
    }

    public void evaluate(Object arg) {
        int i;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        if (vector_A.has_UXZ()) {
            i = 0;
            while (i < this.n_outputs) {
                this.values[i] = this.value_U;
                ++i;
            }
        } else {
            i = 0;
            while (i < this.n_outputs) {
                this.values[i] = this.value_0;
                ++i;
            }
            this.values[(int)vector_A.getValue()] = this.value_1;
        }
        i = 0;
        while (i < this.n_outputs) {
            Port port_i = this.ports[1 + i];
            Signal signal_i = port_i.getSignal();
            if (signal_i != null) {
                simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_i, time, this.values[i], (Object)port_i));
            }
            ++i;
        }
    }

    public void updateSymbol() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        this.symbol.painter.paint(this.symbol, 1);
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.delay);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 5]:", "width", "output delay           [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay,\noutput value\n");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "value<" + (this.n_bits - 1) + ":0>= " + this.vector.toHexString();
    }
}

