/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.ROM;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class ROMcs
extends ROM {
    protected PortStdLogic1164 port_nCS;

    public ROMcs() {
        this.constructPorts();
    }

    protected void constructPorts() {
        this.port_D = new PortStdLogicVector((SimObject)this, "D", 1, null, this.n_bits);
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.getAddressBusWidth());
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.ports = new Port[3];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_D;
        this.ports[2] = this.port_nCS;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null && this.port_D.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_D.getSignal(), 0.0, this.vector_UUU.copy(), this.port_D));
        }
    }

    public void evaluate(Object arg) {
        Signal signal_D;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if ((signal_D = this.port_D.getSignal()) == null) {
            return;
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_D = null;
        StdLogic1164 value_nCS = this.port_nCS.getValueOrU();
        if (value_nCS.is_1()) {
            vector_D = this.vector_ZZZ.copy();
        } else if (!value_nCS.is_0()) {
            vector_D = this.vector_UUU.copy();
        } else if (vector_A.has_UXZ()) {
            vector_D = this.vector_UUU.copy();
            int addr = -1;
            long data = -1L;
        } else {
            int addr = (int)vector_A.getValue();
            long data = this.getDataAt(addr);
            vector_D = new StdLogicVector(this.n_bits, data);
            this.notifyReadListeners(addr, data);
        }
        this.simulator.scheduleEvent(new SimEvent(signal_D, time, vector_D.copy(), this.port_D));
    }
}

