/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class PIO8255
extends GenericRtlibObject {
    public static final int MODE0_ALL_INPUTS = 155;
    protected int registerA;
    protected int registerB;
    protected int registerC;
    protected int controlRegister;
    protected PortStdLogic1164 nCS;
    protected PortStdLogic1164 nRD;
    protected PortStdLogic1164 nWR;
    protected PortStdLogic1164 A1;
    protected PortStdLogic1164 A0;
    protected PortStdLogic1164 RESET;
    protected PortStdLogicVector DATA;
    protected PortStdLogic1164 DDRIVE;
    protected PortStdLogic1164 PA7;
    protected PortStdLogic1164 PA6;
    protected PortStdLogic1164 PA5;
    protected PortStdLogic1164 PA4;
    protected PortStdLogic1164 PA3;
    protected PortStdLogic1164 PA2;
    protected PortStdLogic1164 PA1;
    protected PortStdLogic1164 PA0;
    protected PortStdLogic1164 PB7;
    protected PortStdLogic1164 PB6;
    protected PortStdLogic1164 PB5;
    protected PortStdLogic1164 PB4;
    protected PortStdLogic1164 PB3;
    protected PortStdLogic1164 PB2;
    protected PortStdLogic1164 PB1;
    protected PortStdLogic1164 PB0;
    protected PortStdLogic1164 PC7;
    protected PortStdLogic1164 PC6;
    protected PortStdLogic1164 PC5;
    protected PortStdLogic1164 PC4;
    protected PortStdLogic1164 PC3;
    protected PortStdLogic1164 PC2;
    protected PortStdLogic1164 PC1;
    protected PortStdLogic1164 PC0;
    protected PortStdLogic1164[] PORTA;
    protected PortStdLogic1164[] PORTB;
    protected PortStdLogic1164[] PORTC;
    protected PortStdLogic1164[] PORTC_upper;
    protected PortStdLogic1164[] PORTC_lower;
    protected StdLogic1164 value_U = Const1164.__U;
    protected StdLogic1164 value_X = Const1164.__X;
    protected StdLogic1164 value_Z = Const1164.__Z;
    protected StdLogic1164 value_0 = Const1164.__0;
    protected StdLogic1164 value_1 = Const1164.__1;
    protected StdLogicVector vector_ZZZ = null;
    protected StdLogicVector vector_XXX = null;
    protected double t_access = 5.0E-8;

    public PIO8255() {
        this.setWidth(8);
        this.constructPorts();
    }

    public void constructPorts() {
        this.PA0 = new PortStdLogic1164(this, "PA0", 2, null);
        this.PA1 = new PortStdLogic1164(this, "PA1", 2, null);
        this.PA2 = new PortStdLogic1164(this, "PA2", 2, null);
        this.PA3 = new PortStdLogic1164(this, "PA3", 2, null);
        this.PA4 = new PortStdLogic1164(this, "PA4", 2, null);
        this.PA5 = new PortStdLogic1164(this, "PA5", 2, null);
        this.PA6 = new PortStdLogic1164(this, "PA6", 2, null);
        this.PA7 = new PortStdLogic1164(this, "PA7", 2, null);
        this.PB0 = new PortStdLogic1164(this, "PB0", 2, null);
        this.PB1 = new PortStdLogic1164(this, "PB1", 2, null);
        this.PB2 = new PortStdLogic1164(this, "PB2", 2, null);
        this.PB3 = new PortStdLogic1164(this, "PB3", 2, null);
        this.PB4 = new PortStdLogic1164(this, "PB4", 2, null);
        this.PB5 = new PortStdLogic1164(this, "PB5", 2, null);
        this.PB6 = new PortStdLogic1164(this, "PB6", 2, null);
        this.PB7 = new PortStdLogic1164(this, "PB7", 2, null);
        this.PC0 = new PortStdLogic1164(this, "PC0", 2, null);
        this.PC1 = new PortStdLogic1164(this, "PC1", 2, null);
        this.PC2 = new PortStdLogic1164(this, "PC2", 2, null);
        this.PC3 = new PortStdLogic1164(this, "PC3", 2, null);
        this.PC4 = new PortStdLogic1164(this, "PC4", 2, null);
        this.PC5 = new PortStdLogic1164(this, "PC5", 2, null);
        this.PC6 = new PortStdLogic1164(this, "PC6", 2, null);
        this.PC7 = new PortStdLogic1164(this, "PC7", 2, null);
        this.nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.A0 = new PortStdLogic1164(this, "A0", 3, null);
        this.A1 = new PortStdLogic1164(this, "A1", 3, null);
        this.nRD = new PortStdLogic1164(this, "nRD", 0, null);
        this.nWR = new PortStdLogic1164(this, "nWR", 0, null);
        this.RESET = new PortStdLogic1164(this, "RESET", 0, null);
        this.DDRIVE = new PortStdLogic1164(this, "nDDRIVE", 1, null);
        this.DATA = new PortStdLogicVector((SimObject)this, "DATA", 2, null, this.n_bits);
        this.ports = new Port[]{this.PA0, this.PA1, this.PA2, this.PA3, this.PA4, this.PA5, this.PA6, this.PA7, this.PB0, this.PB1, this.PB2, this.PB3, this.PB4, this.PB5, this.PB6, this.PB7, this.PC0, this.PC1, this.PC2, this.PC3, this.PC4, this.PC5, this.PC6, this.PC7, this.nCS, this.A0, this.A1, this.nRD, this.nWR, this.RESET, this.DDRIVE, this.DATA};
        this.PORTA = new PortStdLogic1164[]{this.PA0, this.PA1, this.PA2, this.PA3, this.PA4, this.PA5, this.PA6, this.PA7};
        this.PORTB = new PortStdLogic1164[]{this.PB0, this.PB1, this.PB2, this.PB3, this.PB4, this.PB5, this.PB6, this.PB7};
        this.PORTC = new PortStdLogic1164[]{this.PC0, this.PC1, this.PC2, this.PC3, this.PC4, this.PC5, this.PC6, this.PC7};
        this.vector_ZZZ = new StdLogicVector(this.n_bits, Const1164.__Z);
        this.vector_XXX = new StdLogicVector(this.n_bits, Const1164.__X);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.invalidate();
    }

    public void evaluate(Object arg) {
        try {
            Port tp = ((SimEvent)arg).getTargetPort();
            if (tp != this.nCS && tp != this.nRD && tp != this.nWR && tp != this.RESET) {
                return;
            }
            StdLogic1164 reset = this.RESET.getValueOrU();
            if (reset.is_1H()) {
                this.reset();
                return;
            }
            if (!reset.is_0L()) {
                this.invalidate();
                return;
            }
            StdLogic1164 chipSelect = this.nCS.getValueOrU();
            if (chipSelect.is_1H()) {
                return;
            }
            if (!chipSelect.is_0L()) {
                this.invalidate();
                return;
            }
            StdLogic1164 value_nRD = this.nRD.getValueOrU();
            StdLogic1164 value_nWR = this.nWR.getValueOrU();
            SignalStdLogic1164 signal_nWR = (SignalStdLogic1164)this.nWR.getSignal();
            if (value_nRD.is_UXZ() || value_nWR.is_UXZ()) {
                this.invalidate();
                return;
            }
            if (value_nRD.is_0L() && value_nWR.is_0L()) {
                this.invalidate();
                return;
            }
            if (signal_nWR != null && signal_nWR.hasRisingEdge()) {
                this.handleWriteCommand();
            } else if (value_nRD.is_0L()) {
                this.handleReadCommand();
            } else if (value_nRD.is_1H()) {
                this.schedule(this.DATA, this.vector_ZZZ, this.simulator.getSimTime() + this.t_access);
                this.schedule(this.DDRIVE, this.value_1, this.simulator.getSimTime() + this.t_access);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void handleWriteCommand() {
        try {
            int addr = this.getAddr();
            int data = this.getData();
            if (addr < 0) {
                this.warning(".handleWriteCommand: address undefined. Ignored");
            }
            if (data < 0) {
                this.warning(".handleWriteCommand: data undefined. Ignored");
            }
            switch (addr) {
                case 0: {
                    this.registerA = data;
                    this.scheduleOutputsPortA();
                    break;
                }
                case 1: {
                    this.registerB = data;
                    this.scheduleOutputsPortB();
                    break;
                }
                case 2: {
                    this.registerC = data;
                    this.scheduleOutputsPortC();
                    break;
                }
                case 3: {
                    this.writeControlRegister(data);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void handleReadCommand() {
        try {
            int addr = this.getAddr();
            if (addr < 0) {
                this.warning(".handleWriteCommand: address undefined. Ignored");
            }
            int data = 0;
            switch (addr) {
                case 0: {
                    data = this.readRegisterA();
                    break;
                }
                case 1: {
                    data = this.readRegisterB();
                    break;
                }
                case 2: {
                    data = this.readRegisterC();
                    break;
                }
                case 3: {
                    data = this.controlRegister;
                }
            }
            double t = this.simulator.getSimTime() + this.t_access;
            this.schedule(this.DATA, new StdLogicVector(this.n_bits, data), t);
            this.schedule(this.DDRIVE, this.value_0, t);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public int readRegisterA() {
        if (this.isOutputPortA()) {
            return this.registerA;
        }
        int tmp = 0;
        int i = 0;
        while (i < 8) {
            StdLogic1164 v = this.PORTA[i].getValueOrU();
            if (v.is_1H()) {
                ++tmp;
            }
            tmp <<= 1;
            ++i;
        }
        return tmp;
    }

    public int readRegisterB() {
        if (this.isOutputPortB()) {
            return this.registerB;
        }
        int tmp = 0;
        int i = 0;
        while (i < 8) {
            StdLogic1164 v = this.PORTB[i].getValueOrU();
            if (v.is_1H()) {
                ++tmp;
            }
            tmp <<= 1;
            ++i;
        }
        return tmp;
    }

    public int readRegisterC() {
        StdLogic1164 v;
        int i;
        int tmp = 0;
        if (this.isOutputPortLowerC()) {
            tmp = this.registerC & 0xF;
        } else {
            i = 0;
            while (i < 4) {
                v = this.PORTC[i].getValueOrU();
                if (v.is_1H()) {
                    ++tmp;
                }
                tmp <<= 1;
                ++i;
            }
        }
        if (this.isOutputPortUpperC()) {
            tmp = this.registerC & 0xF0;
        } else {
            i = 4;
            while (i < 8) {
                v = this.PORTC[i].getValueOrU();
                if (v.is_1H()) {
                    ++tmp;
                }
                tmp <<= 1;
                ++i;
            }
        }
        return tmp;
    }

    public void reset() {
        double time = this.simulator.getSimTime();
        this.writeControlRegister(155);
        this.scheduleOutputsPortA();
        this.scheduleOutputsPortB();
        this.scheduleOutputsPortC();
        this.schedule(this.DATA, this.vector_ZZZ, time + this.t_access);
        this.schedule(this.DDRIVE, this.value_1, time + this.t_access);
    }

    public void scheduleOutputsPortA() {
        double time = this.simulator.getSimTime();
        if (this.isOutputPortA()) {
            int tmp = this.registerA;
            int i = 0;
            while (i < 8) {
                if ((tmp & 1) != 0) {
                    this.schedule(this.PORTA[i], this.value_1, time + this.t_access);
                } else {
                    this.schedule(this.PORTA[i], this.value_0, time + this.t_access);
                }
                tmp >>>= 1;
                ++i;
            }
        } else {
            int i = 0;
            while (i < 8) {
                this.schedule(this.PORTA[i], this.value_Z, time + this.t_access);
                ++i;
            }
        }
    }

    public void scheduleOutputsPortB() {
        double time = this.simulator.getSimTime();
        if (this.isOutputPortB()) {
            int tmp = this.registerB;
            int i = 0;
            while (i < 8) {
                if ((tmp & 1) != 0) {
                    this.schedule(this.PORTB[i], this.value_1, time + this.t_access);
                } else {
                    this.schedule(this.PORTB[i], this.value_0, time + this.t_access);
                }
                tmp >>>= 1;
                ++i;
            }
        } else {
            int i = 0;
            while (i < 8) {
                this.schedule(this.PORTB[i], this.value_Z, time + this.t_access);
                ++i;
            }
        }
    }

    public void scheduleOutputsPortC() {
        double time = this.simulator.getSimTime();
        int tmp = this.registerC;
        StdLogic1164 v = null;
        int i = 0;
        while (i < 4) {
            v = this.isOutputPortLowerC() ? ((tmp & 1) != 0 ? this.value_1 : this.value_0) : this.value_Z;
            tmp >>>= 1;
            this.schedule(this.PORTC[i], v, time + this.t_access);
            ++i;
        }
        int i2 = 4;
        while (i2 < 8) {
            v = this.isOutputPortLowerC() ? ((tmp & 1) != 0 ? this.value_1 : this.value_0) : this.value_Z;
            tmp >>>= 1;
            this.schedule(this.PORTC[i2], v, time + this.t_access);
            ++i2;
        }
    }

    public void invalidate() {
        double time = this.simulator.getSimTime();
        this.writeControlRegister(155);
        int i = 0;
        while (i < 8) {
            this.schedule(this.PORTA[i], this.value_X, time + this.t_access);
            this.schedule(this.PORTB[i], this.value_X, time + this.t_access);
            this.schedule(this.PORTC[i], this.value_X, time + this.t_access);
            ++i;
        }
        this.schedule(this.DATA, this.vector_XXX, time + this.t_access);
        this.schedule(this.DDRIVE, this.value_1, time + this.t_access);
    }

    public void writeControlRegister(int value) {
        if ((value & 0x80) != 0) {
            int mode = value & 0x64;
            if (mode != 0) {
                this.warning(".writeControlRegister: " + mode + " not yet supported! Ignored.");
                return;
            }
            this.controlRegister = value;
            this.scheduleOutputsPortA();
            this.scheduleOutputsPortB();
            this.scheduleOutputsPortC();
        } else {
            int bit = value & 1;
            int index = (value & 0xE) >>> 1;
            int mask = 1 << index;
            double time = this.simulator.getSimTime();
            if (bit == 1) {
                this.registerC |= mask;
                if (bit < 4 && !this.isOutputPortLowerC()) {
                    return;
                }
                if (bit >= 4 && !this.isOutputPortUpperC()) {
                    return;
                }
                this.schedule(this.PORTC[index], this.value_1, time + this.t_access);
            } else {
                this.registerC &= ~mask;
                if (bit < 4 && !this.isOutputPortLowerC()) {
                    return;
                }
                if (bit >= 4 && !this.isOutputPortUpperC()) {
                    return;
                }
                this.schedule(this.PORTC[index], this.value_0, time + this.t_access);
            }
        }
    }

    public StdLogic1164 getBit(int reg, int index) {
        if ((reg & 1 << index) != 0) {
            return this.value_1;
        }
        return this.value_0;
    }

    public void schedule(Port port, Object value, double time) {
        Signal s = port.getSignal();
        if (s == null) {
            return;
        }
        this.simulator.scheduleEvent(new SimEvent(s, time, value, port));
    }

    public boolean isOutputPortA() {
        return (this.controlRegister & 0x10) == 0;
    }

    public boolean isOutputPortUpperC() {
        return (this.controlRegister & 8) == 0;
    }

    public boolean isOutputPortB() {
        return (this.controlRegister & 2) == 0;
    }

    public boolean isOutputPortLowerC() {
        return (this.controlRegister & 1) == 0;
    }

    public boolean isMode0() {
        return (this.controlRegister & 0x64) == 0;
    }

    public int getAddr() {
        StdLogic1164 a1 = this.A1.getValueOrU();
        StdLogic1164 a0 = this.A0.getValueOrU();
        if (a1.is_UXZ()) {
            return -1;
        }
        if (a0.is_UXZ()) {
            return -1;
        }
        int addr = 0;
        if (a1.is_1H()) {
            addr += 2;
        }
        if (a0.is_1H()) {
            ++addr;
        }
        return addr;
    }

    public int getData() {
        StdLogicVector v = this.DATA.getVectorOrUUU();
        if (v.has_UXZ()) {
            return -1;
        }
        return (int)(v.getValue() & 0xFFL);
    }

    public int getRegisterA() {
        return this.registerA;
    }

    public int getRegisterB() {
        return this.registerB;
    }

    public int getRegisterC() {
        return this.registerC;
    }

    public int getControlRegister() {
        return this.controlRegister;
    }

    public void setRegisterA(int value) {
        this.registerA = value & 0xFF;
    }

    public void setRegisterB(int value) {
        this.registerB = value & 0xFF;
    }

    public void setRegisterC(int value) {
        this.registerC = value & 0xFF;
    }

    public void setControlRegister(int value) {
        this.controlRegister = value & 0xFF;
    }

    public void setRegisterA(String s) {
        this.setRegisterA(this._stoi(s));
    }

    public void setRegisterB(String s) {
        this.setRegisterB(this._stoi(s));
    }

    public void setRegisterC(String s) {
        this.setRegisterC(this._stoi(s));
    }

    public void setControlRegister(String s) {
        this.setControlRegister(this._stoi(s));
    }

    private int _stoi(String s) {
        try {
            StdLogicVector v = new StdLogicVector(this.n_bits, 0L);
            v.parse(s);
            int i = (int)v.getValue();
            return i;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return 0;
        }
    }

    public void configure() {
        String[] fields = new String[]{"instance name:", "name", "data bus width: [8 .. 32]:", "width", "register A value", "registerA", "register B value", "registerB", "register C value", "registerC", "control register value", "controlRegister"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, data bus width,\nand register values\n");
        this.propertySheet.setVisible(true);
    }
}

