/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.MR;
import hades.models.rtlib.memory.MREditorFrame;
import hades.models.string.StringSignal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class MRALU
extends MR {
    protected PortStdLogicVector port_ALU_OP;
    protected PortStdLogicVector port_SELX;
    protected PortStdLogicVector port_SELY;
    protected PortStdLogic1164 port_REGSNWE;
    private int[] defaultValues;
    private static String[] d_names = new String[0];
    static String[] labels = new String[]{"      u u                           ", "      P P                           ", "      C C                R          ", "      m m                E          ", "      u u  n  n    A     G          ", "      x x  e  e    L S S S          ", "      . .  x  x    U E E n          ", "      s s  t  t    O L L W          ", "addr  1 0  A  B    P Y X E      name"};

    public MRALU() {
        this.cache_read_addr = -1;
    }

    @Override
    public void setDSize() {
        this.D_SIZE = 0;
    }

    @Override
    public void createTypesAndFieldsAndMemory() {
        int i;
        this.n_words = 256;
        this.n_fields = 8 + this.D_SIZE;
        this.alabel = new String[this.n_words];
        this.flength = new int[this.n_fields];
        this.flabel = new String[this.n_fields];
        this.fseparator = new boolean[this.n_fields];
        int f = 0;
        this.createField(f++, 1, "umux.s1");
        this.createField(f++, 1, "umux.s0");
        this.createField(f++, 8, "nextA");
        this.createField(f++, 8, "nextB");
        this.createField(f++, 8, "ALU_OP");
        this.createField(f++, 4, "SEL_Y");
        this.createField(f++, 4, "SEl_X");
        this.createField(f++, 1, "REGSNWE");
        this.fdata = new int[this.n_words][this.n_fields];
        for (i = 0; i < this.n_words; ++i) {
            this.alabel[i] = "___" + i;
            this.fdata[i] = new int[this.n_fields];
        }
        this.defaultValues = new int[this.n_fields];
        for (i = 0; i < this.n_fields; ++i) {
            this.defaultValues[i] = 0;
        }
        this.defaultValues[7] = 1;
        this.createDefaultValues(this.defaultValues);
        this.initializeWithDefaultValues();
        this.fseparator[0] = true;
        this.fseparator[4] = true;
    }

    @Override
    public void createField(int index, int length, String name) {
        this.flength[index] = length;
        this.flabel[index] = name;
    }

    @Override
    public void setData(int addr, int field, int value) {
        this.fdata[addr][field] = value & lengthMask[this.flength[field]];
        this.cache_read_addr = -1;
    }

    @Override
    public void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, 8);
        this.port_S1 = new PortStdLogic1164(this, "S1", 1, null);
        this.port_S0 = new PortStdLogic1164(this, "S0", 1, null);
        this.port_X = new PortStdLogicVector((SimObject)this, "X", 1, null, 8);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, 8);
        this.port_ALU_OP = new PortStdLogicVector((SimObject)this, "ALU_OP", 1, null, 8);
        this.port_SELX = new PortStdLogicVector((SimObject)this, "SEL_X", 1, null, 4);
        this.port_SELY = new PortStdLogicVector((SimObject)this, "SEL_Y", 1, null, 4);
        this.port_REGSNWE = new PortStdLogic1164(this, "REGSNWE", 1, null);
        this.port_STATE = new Port(this, "STATE", 1, null, new StringSignal().getClass());
        this.ports = new Port[10];
        int i = 0;
        this.ports[i++] = this.port_S1;
        this.ports[i++] = this.port_S0;
        this.ports[i++] = this.port_X;
        this.ports[i++] = this.port_Y;
        this.ports[i++] = this.port_A;
        this.ports[i++] = this.port_STATE;
        this.ports[i++] = this.port_ALU_OP;
        this.ports[i++] = this.port_SELY;
        this.ports[i++] = this.port_SELX;
        this.ports[i++] = this.port_REGSNWE;
    }

    @Override
    public boolean save(PrintWriter PW) {
        PW.println("#MicroROM data");
        PW.println("" + this.n_words + " " + this.n_fields);
        for (int f = 0; f < this.n_fields; ++f) {
            PW.print(NameMangler.encodeWithUnicodeEscapes(this.getFieldName(f)));
            PW.print(' ');
        }
        PW.println();
        PW.println("#       u u                   \n#       P P                   \n#       C C                R  \n#       m m                E  \n#       u u  n  n   A      G  \n#       x x  e  e   L  S S S  \n#       . .  x  x   U  E E n  \n#       s s  t  t   O  L L W  \n#       1 0  A  B   P  Y X E  \n#                                ");
        for (int addr = 0; addr < this.n_words; ++addr) {
            PW.print(this.getHexString(addr, 4));
            PW.print(": ");
            for (int f = 0; f < this.n_fields; ++f) {
                if (this.isSeparator(f)) {
                    PW.print("  ");
                }
                PW.print(this.getHexString(this.getData(addr, f), this.getFieldChars(f)));
                PW.print(' ');
            }
            PW.print(NameMangler.encodeWithUnicodeEscapes(this.getStateLabel(addr)));
            PW.println();
        }
        PW.flush();
        return false;
    }

    @Override
    public boolean parse(BufferedReader reader) throws Exception {
        if (reader == null) {
            return false;
        }
        String line = null;
        int addr = 0;
        LineNumberReader br = null;
        try {
            br = new LineNumberReader(reader);
            line = br.readLine();
            if (!line.startsWith("#MicroROM data")) {
                this.message("-E- Not a microcode data file! ");
                this.message("...expected '#MicroROM data' on line 1,");
                this.message("...but got '" + line + "'");
                return true;
            }
            line = br.readLine();
            this.n_words = 256;
            this.n_fields = 8;
            line = br.readLine();
            StringTokenizer st = new StringTokenizer(line);
            while ((line = br.readLine()) != null && line != null) {
                if (line.startsWith("#") || line.startsWith(";")) continue;
                st = new StringTokenizer(line, " \t\r:");
                addr = Integer.parseInt(st.nextToken(), 16);
                for (int f = 0; f < this.n_fields; ++f) {
                    this.setData(addr, f, Integer.parseInt(st.nextToken(), 16));
                }
                StringBuffer buff = new StringBuffer(st.restOfLine());
                if (buff.length() > 0 && buff.charAt(0) == ' ') {
                    buff.deleteCharAt(0);
                }
                this.setStateLabel(addr, NameMangler.decodeUnicodeEscapes(buff.toString()));
            }
        }
        catch (Exception e) {
            this.message("-E- Not a valid microcode file: " + e);
            if (br != null) {
                this.message("on line " + br.getLineNumber() + " '" + line + "'");
            }
            this.message("error near input '" + line + "'");
        }
        this.cache_read_addr = -1;
        return true;
    }

    @Override
    public void setDataAt(int address, long value) {
        super.setDataAt(address, value);
        this.cache_read_addr = -1;
    }

    @Override
    public void elaborate(Object arg) {
        if (debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.cache_read_addr = -1;
    }

    @Override
    public void evaluate(Object arg) {
        int addr;
        if (debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        if (vector_A.has_UXZ()) {
            addr = -1;
            this.cache_read_addr = -12;
        } else {
            addr = (int)vector_A.getValue();
            this.notifyReadListeners(addr, 0L);
            if (this.checkChange(addr, 0)) {
                this.scheduleSingleOutput(this.port_S1, this.getData(addr, 0), time);
            }
            if (this.checkChange(addr, 1)) {
                this.scheduleSingleOutput(this.port_S0, this.getData(addr, 1), time);
            }
            if (this.checkChange(addr, 2)) {
                this.schedulePortOutput(this.port_X, this.getData(addr, 2), time);
            }
            if (this.checkChange(addr, 3)) {
                this.schedulePortOutput(this.port_Y, this.getData(addr, 3), time);
            }
            if (this.checkChange(addr, 4)) {
                this.schedulePortOutput(this.port_ALU_OP, this.getData(addr, 4), time);
            }
            if (this.checkChange(addr, 5)) {
                this.schedulePortOutput(this.port_SELY, this.getData(addr, 5), time);
            }
            if (this.checkChange(addr, 6)) {
                this.schedulePortOutput(this.port_SELX, this.getData(addr, 6), time);
            }
            if (this.checkChange(addr, 7)) {
                this.scheduleSingleOutput(this.port_REGSNWE, this.getData(addr, 7), time);
            }
            this.cache_read_addr = addr;
        }
        if (this.port_STATE.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_STATE.getSignal(), time, this.getStateLabel(addr), this.port_STATE));
        }
        if (this.enableAnimationFlag && this.symbol != null && this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    boolean checkChange(int addr, int field) {
        boolean b;
        if (this.cache_read_addr < 0) {
            b = true;
        } else {
            boolean bl = b = this.getData(addr, field) != this.getData(this.cache_read_addr, field);
        }
        if (debug) {
            System.out.println("-F- checkChange: " + addr + " " + this.cache_read_addr + " " + field + " " + b);
        }
        return b;
    }

    @Override
    public void configure() {
        if (this.MEF == null) {
            int n_lines = Math.min(this.n_words, 32);
            this.MEF = new MREditorFrame(this, n_lines, 1, "Edit " + this.getName() + " " + this.getClass().getName());
            this.addMemoryListener(this.MEF);
            this.MEF.setLabels(labels);
        }
        this.config_rest();
        if (!this.readfailed) {
            this.MEF.setSaveMIEnabled(true);
            this.MEF.setReloadEnabled(true);
            this.MEF.setnewTitle(this.resourcename);
        }
    }
}

