/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.StdLogicVector;
import hades.models.rtlib.memory.MR;
import hades.models.rtlib.memory.MREditorFrame;
import hades.simulator.SimEvent;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class MR24
extends MR {
    private int[] defaultValues;
    private static String[] d_names = new String[]{"unused", "unused", "unused", "unused", "SP", "SPBUF", "RX_BUF.enable", "AX=15", "IR.enable", "ADDR_BUF.enable", "C.enable", "ALU_BUF.enable", "RegBank.nWE", "PC_BUF.enable", "PC.enable", "PC_MUX.s1", "PC_MUX.s0", "MRR_BUF.enable", "MRR.enable", "MDR.enable", "MDF_BUF.enable", "MAR.enable", "nWE", "nOE"};
    static String[] labels = new String[]{"            u u                                                               ", "            P P                         A       R     P   P                   ", "            C C                         D   A   E     C   C M       M         ", "      n  n  m m               S R A     D   L   G P   m   m R       D         ", "      e  e  u u               P X X     R   U   S C   u   u R       R         ", "      x  x  x x               B B =     B   B   n B   x   x B M M   B M n n   ", "      t  t  s s             S U U 1   I U   U   w U P s   s U R D   U A W O   ", "addr  A  B  1 0             P F F 5   R F C F   e F C 1   0 F R R   F R E E   name"};

    public MR24() {
        this.cache_read_addr = -1;
    }

    @Override
    public void setDSize() {
        this.D_SIZE = 24;
    }

    @Override
    public void createTypesAndFieldsAndMemory() {
        int n;
        this.n_words = 256;
        this.n_fields = 4 + this.D_SIZE;
        this.alabel = new String[this.n_words];
        this.flength = new int[this.n_fields];
        this.flabel = new String[this.n_fields];
        this.fseparator = new boolean[this.n_fields];
        int n2 = 0;
        this.createField(n2++, 8, "nextA");
        this.createField(n2++, 8, "nextB");
        this.createField(n2++, 1, "umux.s1");
        this.createField(n2++, 1, "umux.s0");
        for (n = 0; n < this.D_SIZE; ++n) {
            this.createField(n2++, 1, d_names[n]);
        }
        this.fdata = new int[this.n_words][this.n_fields];
        for (n = 0; n < this.n_words; ++n) {
            this.alabel[n] = "___" + n;
            this.fdata[n] = new int[this.n_fields];
        }
        this.defaultValues = new int[this.n_fields];
        for (n = 0; n < this.n_fields; ++n) {
            this.defaultValues[n] = 0;
        }
        this.defaultValues[16] = 1;
        this.defaultValues[26] = 1;
        this.defaultValues[27] = 1;
        this.createDefaultValues(this.defaultValues);
        this.initializeWithDefaultValues();
        this.fseparator[0] = true;
        this.fseparator[4] = true;
        this.fseparator[8] = true;
        this.fseparator[12] = true;
        this.fseparator[16] = true;
        this.fseparator[20] = true;
        this.fseparator[24] = true;
    }

    @Override
    public void createField(int n, int n2, String string) {
        this.flength[n] = n2;
        this.flabel[n] = string;
    }

    @Override
    public void setData(int n, int n2, int n3) {
        this.fdata[n][n2] = n3 & lengthMask[this.flength[n2]];
        this.cache_read_addr = -1;
    }

    @Override
    public boolean save(PrintWriter printWriter) {
        int n;
        printWriter.println("#MicroROM data");
        printWriter.println("" + this.n_words + " " + this.n_fields);
        for (n = 0; n < this.n_fields; ++n) {
            printWriter.print(NameMangler.encodeWithUnicodeEscapes(this.getFieldName(n)));
            printWriter.print(' ');
        }
        printWriter.println();
        printWriter.println("#             u u                                                                \n#             P P                                       P   P                    \n#             C C                         A       R     C   C                    \n#       n  n  m m                         D   A   E     M   M M       M          \n#       e  e  u u               S R A     D   L   G P   U   U R       D          \n#       x  x  x x               P X X     R   U   . C   X   X R       R          \n#       t  t  . .               B B =     B   B   n B   .   . B M M   B M n n    \n#       .  .  s s             S U U 1   I U   U   W U P s   s U R D   U A W O    \n#       A  B  1 0             P F F 5   R F C F   E F C 1   0 F R R   F R E E    \n#                                                                                  ");
        for (n = 0; n < this.n_words; ++n) {
            printWriter.print(this.getHexString(n, 4));
            printWriter.print(": ");
            for (int i = 0; i < this.n_fields; ++i) {
                if (this.isSeparator(i)) {
                    printWriter.print("  ");
                }
                printWriter.print(this.getHexString(this.getData(n, i), this.getFieldChars(i)));
                printWriter.print(' ');
            }
            printWriter.print(NameMangler.encodeWithUnicodeEscapes(this.getStateLabel(n)));
            printWriter.println();
        }
        printWriter.flush();
        return false;
    }

    @Override
    public boolean parse(BufferedReader bufferedReader) throws Exception {
        if (bufferedReader == null) {
            return false;
        }
        String string = null;
        int n = 0;
        LineNumberReader lineNumberReader = null;
        try {
            lineNumberReader = new LineNumberReader(bufferedReader);
            string = lineNumberReader.readLine();
            if (!string.startsWith("#MicroROM data")) {
                this.message("-E- Not a microcode data file! ");
                this.message("...expected '#MicroROM data' on line 1,");
                this.message("...but got '" + string + "'");
                return true;
            }
            string = lineNumberReader.readLine();
            this.n_words = 256;
            this.n_fields = 28;
            string = lineNumberReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while ((string = lineNumberReader.readLine()) != null && string != null) {
                if (string.startsWith("#") || string.startsWith(";")) continue;
                stringTokenizer = new StringTokenizer(string, " \t\r:");
                n = Integer.parseInt(stringTokenizer.nextToken(), 16);
                for (int i = 0; i < this.n_fields; ++i) {
                    this.setData(n, i, Integer.parseInt(stringTokenizer.nextToken(), 16));
                }
                StringBuffer stringBuffer = new StringBuffer(stringTokenizer.restOfLine());
                if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == ' ') {
                    stringBuffer.deleteCharAt(0);
                }
                this.setStateLabel(n, NameMangler.decodeUnicodeEscapes(stringBuffer.toString()));
            }
        }
        catch (Exception exception) {
            this.message("-E- Not a valid microcode file: " + exception);
            if (lineNumberReader != null) {
                this.message("on line " + lineNumberReader.getLineNumber() + " '" + string + "'");
            }
            this.message("error near input '" + string + "'");
        }
        this.cache_read_addr = -1;
        return true;
    }

    @Override
    public void setDataAt(int n, long l) {
        super.setDataAt(n, l);
        this.cache_read_addr = -1;
    }

    @Override
    public void elaborate(Object object) {
        if (debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.cache_read_addr = -1;
    }

    @Override
    public void evaluate(Object object) {
        int n;
        if (debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double d = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector stdLogicVector = this.port_A.getVectorOrUUU();
        if (stdLogicVector.has_UXZ()) {
            n = -1;
            this.cache_read_addr = -12;
        } else {
            n = (int)stdLogicVector.getValue();
            this.notifyReadListeners(n, 0L);
            for (int i = 0; i < this.D_SIZE; ++i) {
                int n2 = 4 + this.D_SIZE - 1 - i;
                if (!this.checkChange(n, n2)) continue;
                this.scheduleSingleOutput(this.port_D[i], this.getData(n, n2), d);
            }
            if (this.checkChange(n, 2)) {
                this.scheduleSingleOutput(this.port_S1, this.getData(n, 2), d);
            }
            if (this.checkChange(n, 3)) {
                this.scheduleSingleOutput(this.port_S0, this.getData(n, 3), d);
            }
            if (this.checkChange(n, 0)) {
                this.schedulePortOutput(this.port_X, this.getData(n, 0), d);
            }
            if (this.checkChange(n, 1)) {
                this.schedulePortOutput(this.port_Y, this.getData(n, 1), d);
            }
            this.cache_read_addr = n;
        }
        if (this.port_STATE.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_STATE.getSignal(), d, this.getStateLabel(n), this.port_STATE));
        }
        if (this.enableAnimationFlag && this.symbol != null && this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    boolean checkChange(int n, int n2) {
        boolean bl;
        if (this.cache_read_addr < 0) {
            bl = true;
        } else {
            boolean bl2 = bl = this.getData(n, n2) != this.getData(this.cache_read_addr, n2);
        }
        if (debug) {
            System.out.println("-F- checkChange: " + n + " " + this.cache_read_addr + " " + n2 + " " + bl);
        }
        return bl;
    }

    @Override
    public void configure() {
        if (this.MEF == null) {
            int n = Math.min(this.n_words, 32);
            this.MEF = new MREditorFrame(this, n, 1, "Edit " + this.getName() + " " + this.getClass().getName());
            this.addMemoryListener(this.MEF);
            this.MEF.setLabels(labels);
            System.out.println("configure");
            this.MEF.setAskBool(true);
        }
        this.config_rest();
        if (!this.readfailed) {
            this.MEF.setSaveMIEnabled(true);
            this.MEF.setReloadEnabled(true);
            this.MEF.setnewTitle(this.resourcename);
        }
    }
}

