/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.manager.DesignManager;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.GenericMemory;
import hades.models.rtlib.memory.MREditorFrame;
import hades.models.string.StringSignal;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.FatLabel;
import hades.symbols.Symbol;
import hades.symbols.TextSource;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import javax.swing.JMenuItem;
import jfig.utils.ExceptionTracer;

public class MR
extends GenericMemory {
    protected int n_words;
    protected int n_fields;
    protected String[] alabel;
    protected String[] flabel;
    protected int[] flength;
    protected int[][] fdata;
    protected int[] fdefaultValues;
    protected boolean[] fseparator;
    protected MREditorFrame MEF = null;
    protected int D_SIZE;
    protected FatLabel stateLabel;
    protected int cache_read_addr = -13;
    protected boolean confbool = false;
    protected boolean readfailed = true;
    protected PortStdLogicVector port_A;
    protected PortStdLogic1164 port_S1;
    protected PortStdLogic1164 port_S0;
    protected PortStdLogicVector port_X;
    protected PortStdLogicVector port_Y;
    protected PortStdLogic1164[] port_D;
    protected Port port_STATE;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    public static final int[] lengthMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};

    public MR() {
        this.setDSize();
        this.constructPorts();
        this.createTypesAndFieldsAndMemory();
        this.initializeWithZeroes();
    }

    @Override
    public void parseRAM(String resourcename) {
        InputStream is = null;
        BufferedReader br = null;
        try {
            is = DesignManager.getDesignManager().getInputStream(this, resourcename);
            if (is == null) {
                this.message("-W- GenericMemory.parseRAM: file/resource not found: '" + resourcename + "'");
                System.out.println("-W- GenericMemory.parseRAM: file/resource not found: '" + resourcename + "'");
                return;
            }
            br = new BufferedReader(new InputStreamReader(is));
            this.parse(br);
            br.close();
            is.close();
            this.readfailed = false;
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".parseRAM(): Couldn't read from " + resourcename);
            ExceptionTracer.trace(e);
        }
    }

    public void setDSize() {
        this.D_SIZE = 16;
    }

    public void createTypesAndFieldsAndMemory() {
        this.n_words = 256;
        this.n_fields = 4 + this.D_SIZE;
        this.alabel = new String[this.n_words];
        this.flength = new int[this.n_fields];
        this.flabel = new String[this.n_fields];
        this.fseparator = new boolean[this.n_fields];
        int f = 0;
        this.createField(f++, 1, "umux.s1");
        this.createField(f++, 1, "umux.s0");
        this.createField(f++, 8, "nextA");
        this.createField(f++, 8, "nextB");
        for (int j = 0; j < 16; ++j) {
            this.createField(f++, 1, "d" + (15 - j));
        }
        this.fdata = new int[this.n_words][this.n_fields];
        this.fdefaultValues = new int[this.n_fields];
        for (int i = 0; i < this.n_words; ++i) {
            this.alabel[i] = "state_" + i;
            this.fdata[i] = new int[this.n_fields];
            for (int j = 0; j < this.n_fields; ++j) {
                this.fdata[i][j] = (int)(Math.random() * (double)(1 << this.flength[j]));
                this.fdefaultValues[j] = 0;
            }
        }
        this.fseparator[0] = true;
        this.fseparator[4] = true;
        this.fseparator[8] = true;
        this.fseparator[12] = true;
        this.fseparator[16] = true;
    }

    public void createField(int index, int length, String name) {
        this.flength[index] = length;
        this.flabel[index] = name;
    }

    @Override
    public int getSize() {
        return this.n_words;
    }

    public int getNumberOfFields() {
        return this.n_fields;
    }

    public int getFieldBits(int i) {
        return this.flength[i];
    }

    public String getStateLabel(int i) {
        if (i >= 0 && i < this.n_words) {
            return this.alabel[i];
        }
        return "UNDEFINED STATE";
    }

    public String getFieldName(int i) {
        return this.flabel[i];
    }

    public boolean isSeparator(int i) {
        return this.fseparator[i];
    }

    public int getFieldChars(int i) {
        return Math.max(1, this.getFieldBits(i) / 4);
    }

    public int getData(int addr, int field) {
        this.last_read_addr = addr;
        return this.fdata[addr][field];
    }

    public void setData(int addr, int field, int value) {
        this.fdata[addr][field] = value & lengthMask[this.flength[field]];
    }

    public void setStateLabel(int addr, String s) {
        this.alabel[addr] = s;
    }

    public void setFieldName(int f, String s) {
        this.flabel[f] = s;
    }

    public void createDefaultValues(int[] data) {
        this.fdefaultValues = new int[this.n_fields];
        for (int i = 0; i < this.n_fields; ++i) {
            this.fdefaultValues[i] = data[i];
        }
    }

    @Override
    public void initializeWithDefaultValues() {
        if (this.fdefaultValues == null) {
            this.initializeWithZeroes();
        } else {
            for (int addr = 0; addr < this.n_words; ++addr) {
                for (int i = 0; i < this.n_fields; ++i) {
                    this.fdata[addr][i] = this.fdefaultValues[i];
                }
            }
        }
    }

    public boolean isDefaultValue(int addr, int field) {
        if (this.fdefaultValues == null) {
            return false;
        }
        return this.fdefaultValues[field] == this.fdata[addr][field];
    }

    @Override
    public void constructPorts() {
        int i;
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, 8);
        this.port_S1 = new PortStdLogic1164(this, "S1", 1, null);
        this.port_S0 = new PortStdLogic1164(this, "S0", 1, null);
        this.port_X = new PortStdLogicVector((SimObject)this, "X", 1, null, 8);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, 8);
        this.port_D = new PortStdLogic1164[this.D_SIZE];
        for (i = 0; i < this.D_SIZE; ++i) {
            this.port_D[i] = new PortStdLogic1164(this, "D" + i, 1, null);
        }
        this.port_STATE = new Port(this, "STATE", 1, null, new StringSignal().getClass());
        this.ports = new Port[this.D_SIZE + 2 + 2 + 1 + 1];
        i = 0;
        for (i = 0; i < this.D_SIZE; ++i) {
            this.ports[i] = this.port_D[i];
        }
        this.ports[i++] = this.port_S1;
        this.ports[i++] = this.port_S0;
        this.ports[i++] = this.port_X;
        this.ports[i++] = this.port_Y;
        this.ports[i++] = this.port_A;
        this.ports[i++] = this.port_STATE;
    }

    @Override
    public boolean save(PrintWriter PW) {
        this.message("-I- MR.save... ");
        PW.println("#MicroROM data");
        PW.println("" + this.n_words + " " + this.n_fields);
        for (int f = 0; f < this.n_fields; ++f) {
            PW.print(NameMangler.encodeWithUnicodeEscapes(this.getFieldName(f)));
            PW.print(' ');
        }
        PW.println();
        for (int addr = 0; addr < this.n_words; ++addr) {
            PW.print(this.getHexString(addr, 4));
            PW.print(": ");
            for (int f = 0; f < this.n_fields; ++f) {
                if (this.isSeparator(f)) {
                    PW.print("  ");
                }
                PW.print(this.getHexString(this.getData(addr, f), this.getFieldChars(f)));
                PW.print(' ');
            }
            PW.print(NameMangler.encodeWithUnicodeEscapes(this.getStateLabel(addr)));
            PW.println();
        }
        PW.flush();
        return false;
    }

    @Override
    public boolean parse(BufferedReader reader) throws Exception {
        if (reader == null) {
            return false;
        }
        String line = null;
        StringBuffer buff = null;
        int addr = 0;
        LineNumberReader br = null;
        try {
            br = new LineNumberReader(reader);
            line = br.readLine();
            if (!line.startsWith("#MicroROM data")) {
                this.message("-E- Not a microcode data file! ");
                this.message("...expected '#MicroROM data' on line 1,");
                this.message("...but got '" + line + "'");
                return true;
            }
            StringTokenizer st = new StringTokenizer(br.readLine());
            this.n_words = Integer.parseInt(st.nextToken());
            this.n_fields = Integer.parseInt(st.nextToken());
            this.message("-I- microRom has " + this.n_words + " words and " + this.n_fields + " fields.");
            st = new StringTokenizer(br.readLine());
            for (int f = 0; f < this.n_fields; ++f) {
                this.setFieldName(f, NameMangler.decodeUnicodeEscapes(st.nextToken()));
            }
            for (addr = 0; addr < this.n_words; ++addr) {
                st = new StringTokenizer(br.readLine(), " \t\r:");
                int a = Integer.parseInt(st.nextToken(), 16);
                if (a != addr) {
                    this.message("-E- not a valid microcode file: ");
                    this.message("expected address " + addr + " but found: " + a);
                    if (br != null) {
                        this.message("on line " + br.getLineNumber() + " '" + line + "'");
                    }
                    return true;
                }
                for (int f = 0; f < this.n_fields; ++f) {
                    this.setData(addr, f, Integer.parseInt(st.nextToken(), 16));
                }
                buff = new StringBuffer(st.restOfLine());
                if (buff.length() > 0 && buff.charAt(0) == ' ') {
                    buff.deleteCharAt(0);
                }
                this.setStateLabel(addr, NameMangler.decodeUnicodeEscapes(buff.toString()));
            }
        }
        catch (Exception e) {
            this.message("-E- Not a valid microcode file: " + e);
            if (br != null) {
                this.message("on line " + br.getLineNumber() + " '" + line + "'");
            }
            this.message("error near input '" + line + "'");
        }
        return true;
    }

    @Override
    public void elaborate(Object arg) {
        if (debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
    }

    @Override
    public void evaluate(Object arg) {
        int addr;
        if (debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        if (vector_A.has_UXZ()) {
            addr = -1;
            this.cache_read_addr = -12;
        } else {
            this.cache_read_addr = addr = (int)vector_A.getValue();
            this.notifyReadListeners(addr, 0L);
            for (int i = 0; i < this.D_SIZE; ++i) {
                int fi = 4 + this.D_SIZE - 1 - i;
                this.scheduleSingleOutput(this.port_D[i], this.getData(addr, fi), time);
            }
            this.scheduleSingleOutput(this.port_S1, this.getData(addr, 0), time);
            this.scheduleSingleOutput(this.port_S0, this.getData(addr, 1), time);
            this.schedulePortOutput(this.port_X, this.getData(addr, 2), time);
            this.schedulePortOutput(this.port_Y, this.getData(addr, 3), time);
        }
        if (this.port_STATE.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_STATE.getSignal(), time, this.getStateLabel(addr), this.port_STATE));
        }
        if (this.enableAnimationFlag && this.symbol != null && this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    public void scheduleSingleOutput(Port port, int value, double time) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        Const1164 value1164 = value == 0 ? Const1164.__0 : (value == 1 ? Const1164.__1 : Const1164.__U);
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value1164, (Object)port));
    }

    public void schedulePortOutput(PortStdLogicVector port, int value, double time) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        StdLogicVector vector = new StdLogicVector(port.getWidth(), value);
        this.simulator.scheduleEvent(SimEvent.createNewSimEvent(signal, time, vector, port));
    }

    public void config_rest() {
        this.MEF.pack();
        this.MEF.setVisible(true);
        this.MEF.disableEditMenuItems();
        this.MEF.setDefaultExtension(".mic");
        if (!this.confbool) {
            this.confbool = true;
            JMenuItem defau = this.MEF.replaceInitItem();
            defau.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        MR.this.initializeWithDefaultValues();
                        MR.this.MEF.repaint();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
            JMenuItem inser = this.MEF.getInsertItem();
            inser.removeActionListener(this.MEF);
            inser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int addr = MR.this.MEF.getAddr();
                    try {
                        for (int i = MR.this.n_words - 1; i > addr; --i) {
                            for (int j = 0; j < MR.this.n_fields; ++j) {
                                MR.this.fdata[i][j] = MR.this.fdata[i - 1][j];
                            }
                        }
                        for (int j = 0; j < MR.this.n_fields; ++j) {
                            MR.this.fdata[addr][j] = MR.this.fdefaultValues[j];
                        }
                        MR.this.MEF.repaint();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
            JMenuItem remov = this.MEF.getRemoveItem();
            remov.removeActionListener(this.MEF);
            remov.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int addr = MR.this.MEF.getAddr();
                    try {
                        for (int i = addr; i < MR.this.n_words - 1; ++i) {
                            for (int j = 0; j < MR.this.n_fields; ++j) {
                                MR.this.fdata[i][j] = MR.this.fdata[i + 1][j];
                            }
                        }
                        for (int j = 0; j < MR.this.n_fields; ++j) {
                            MR.this.fdata[MR.this.n_words - 1][j] = MR.this.fdefaultValues[j];
                        }
                        MR.this.MEF.repaint();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        }
    }

    @Override
    public void configure() {
        if (this.MEF == null) {
            int n_lines = Math.min(this.n_words, 32);
            this.MEF = new MREditorFrame(this, n_lines, 1, "Edit " + this.getName() + " " + this.getClass().getName());
            this.addMemoryListener(this.MEF);
            this.MEF.setLabels(this);
        }
        this.config_rest();
        if (!this.readfailed) {
            this.MEF.setSaveMIEnabled(true);
            this.MEF.setReloadEnabled(true);
            this.MEF.setnewTitle(this.resourcename);
        }
    }

    @Override
    public Component getPropertySheet() {
        if (this.MEF != null) {
            return this.MEF;
        }
        return null;
    }

    @Override
    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.stateLabel = new FatLabel();
        s.addMember(this.stateLabel);
        this.stateLabel.initialize("6000 3300 Undefined");
        this.stateLabel.setTextSource(new TextSource(){

            @Override
            public String getText() {
                return MR.this.getStateLabel(MR.this.cache_read_addr);
            }
        });
    }

    @Override
    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n[" + this.n_words + "x" + this.n_fields + "]\n" + this.getResourcename() + "\nlast read at addr " + this.last_read_addr + " label= " + this.getStateLabel(this.last_read_addr);
    }
}

