/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.gui.MemoryEditorFrame;
import hades.gui.PropertySheet;
import hades.manager.DesignManager;
import hades.models.Const1164;
import hades.models.StdLogicVector;
import hades.models.memory.InstructionDecoder;
import hades.models.memory.Memory;
import hades.models.memory.MemoryListener;
import hades.simulator.SimObject;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class GenericMemory
extends SimObject
implements Memory {
    protected String resourcename = null;
    protected int n_words = 16;
    protected int n_bits = 16;
    protected long[] data;
    protected long bit_mask;
    protected long last_read_data;
    protected long last_write_data;
    protected int last_read_addr;
    protected int last_write_addr;
    protected StdLogicVector vector_UUU;
    protected StdLogicVector vector_XXX;
    protected StdLogicVector vector_ZZZ;
    protected StdLogicVector vector_000;
    protected StdLogicVector vector_111;
    protected boolean enableAnimationFlag = true;
    public static final int UNDEFINED = -1;
    public static final int TRISTATED = -2;
    private Hashtable _listenerTable;
    private MemoryListener[] _listenerArray;
    private int _listenerCount;
    private InstructionDecoder _decoder;
    protected MemoryEditorFrame MEF = null;

    public GenericMemory() {
        this.constructStandardValues();
        this.createMemory();
        this.initializeWithZeroes();
        this.enableAnimationFlag = SetupManager.getBoolean("Hades.LayerTable.RtlibAnimation", false);
    }

    @Override
    public boolean needsExternalResources() {
        return true;
    }

    @Override
    public String[] getExternalResources() {
        String[] stringArray = new String[]{this.resourcename};
        return stringArray;
    }

    protected void constructPorts() {
        this.message("-E- Internal: don't call constructPorts() on a GenericMemory!");
    }

    protected void constructStandardValues() {
        this.vector_UUU = new StdLogicVector(this.n_bits, Const1164.__U);
        this.vector_XXX = new StdLogicVector(this.n_bits, Const1164.__X);
        this.vector_ZZZ = new StdLogicVector(this.n_bits, Const1164.__Z);
        this.vector_000 = new StdLogicVector(this.n_bits, Const1164.__0);
        this.vector_111 = new StdLogicVector(this.n_bits, Const1164.__1);
        this.bit_mask = this.vector_111.getBitMask();
        this.last_read_addr = -1;
        this.last_read_data = -1L;
        this.last_write_addr = -1;
        this.last_write_data = -1L;
    }

    public boolean getEnableAnimationFlag() {
        return this.enableAnimationFlag;
    }

    public void setEnableAnimationFlag(boolean bl) {
        this.enableAnimationFlag = bl;
    }

    public void setEnableAnimationFlag(String string) {
        try {
            this.setEnableAnimationFlag(string.trim().toLowerCase().startsWith("t"));
        }
        catch (Exception exception) {
            this.message("-E- illegal value for setEnableAnimationFlag, using false");
            this.setEnableAnimationFlag(false);
        }
    }

    public void setInstructionDecoder(InstructionDecoder instructionDecoder) {
        this._decoder = instructionDecoder;
    }

    public InstructionDecoder getInstructionDecoder() {
        return this._decoder;
    }

    public boolean isConnected() {
        if (this.ports == null) {
            return false;
        }
        for (int i = 0; i < this.ports.length; ++i) {
            if (this.ports[i].getSignal() == null) continue;
            return true;
        }
        return false;
    }

    public void createMemory() {
        this.data = new long[this.n_words];
    }

    public boolean dataAtAddressIsUndefined(int n) {
        if (this.data == null) {
            this.createMemory();
        }
        if (n < 0 || n >= this.data.length) {
            return true;
        }
        return this.data[n] == -1L;
    }

    public void initializeWithZeroes() {
        if (this.data == null) {
            this.createMemory();
        }
        for (int i = 0; i < this.n_words; ++i) {
            this.data[i] = 0L;
        }
    }

    public void initializeWithDefaultValues() {
        this.initializeWithZeroes();
    }

    public void initializeWithX() {
        if (this.data == null) {
            this.createMemory();
        }
        for (int i = 0; i < this.n_words; ++i) {
            this.data[i] = -1L;
        }
    }

    public void initializeWithRandomValues() {
        if (this.data == null) {
            this.createMemory();
        }
        for (int i = 0; i < this.n_words; ++i) {
            this.data[i] = Double.doubleToLongBits(Math.random()) & this.bit_mask;
        }
        this.dbg("-I- initializeWithRandomValues ok.");
    }

    @Override
    public String getResourcename() {
        return this.resourcename;
    }

    @Override
    public void setResourcename(String string) {
        this.resourcename = string;
    }

    @Override
    public boolean initialize(String string) {
        this.resourcename = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            this.versionId = Integer.parseInt(stringTokenizer.nextToken());
            this.n_words = Integer.parseInt(stringTokenizer.nextToken());
            this.n_bits = Integer.parseInt(stringTokenizer.nextToken());
            this.createMemory();
            this.constructStandardValues();
            this.constructPorts();
            if (n > 3) {
                this.resourcename = NameMangler.decodeUnicodeEscapes(stringTokenizer.nextToken());
                this.parseRAM(this.resourcename);
            } else {
                this.initializeWithX();
            }
        }
        catch (Exception exception) {
            this.message("-E- " + this.toString() + ".initialize(): " + exception);
            this.message("-E- offending input is '" + string + "'");
            ExceptionTracer.trace(exception);
        }
        return true;
    }

    @Override
    public void write(PrintWriter printWriter) {
        String string = " " + this.versionId + " " + this.n_words + " " + this.n_bits;
        if (this.resourcename != null) {
            string = string + " " + NameMangler.encodeWithUnicodeEscapes(this.resourcename);
        }
        printWriter.print(string);
    }

    @Override
    public int getSize() {
        return this.data.length;
    }

    @Override
    public void setSize(int n) throws Exception {
        throw new Exception("Cannot change the GenericMemory size!");
    }

    @Override
    public boolean resize(int n, int n2) throws Exception {
        throw new Exception("Cannot change the GenericMemory size!");
    }

    public int getAddressBusWidth() {
        return (int)Math.ceil(Math.log(this.n_words) / Math.log(2.0));
    }

    @Override
    public void setDataAt(int n, long l) {
        if (n < 0 || n > this.data.length - 1) {
            this.message("-W- " + this.toString() + ".setDataAt: address out-of-range, ignored: " + n);
            return;
        }
        if (l != -1L) {
            l &= this.bit_mask;
        }
        this.last_write_addr = n;
        this.last_write_data = l;
        this.data[n] = l;
    }

    @Override
    public long getDataAt(int n) {
        this.last_read_addr = n;
        this.last_read_data = this.data[n];
        return this.last_read_data;
    }

    @Override
    public int getBitsPerWord() {
        return this.n_bits;
    }

    @Override
    public void setBitsPerWord(int n) throws Exception {
        if (n == this.n_bits) {
            return;
        }
        this.n_bits = n;
        this.createMemory();
    }

    public int getHexDigitsPerWord() {
        return (int)Math.ceil(0.25 * (double)this.n_bits);
    }

    @Override
    public boolean canChangeSize() {
        return false;
    }

    @Override
    public long[] getDataArray() {
        return this.data;
    }

    @Override
    public void setDataArray(long[] lArray) {
        this.data = lArray;
    }

    @Override
    public boolean merge(BufferedReader bufferedReader) {
        try {
            return this.parse(bufferedReader);
        }
        catch (Exception exception) {
            this.message("-W- " + this.toString() + ".merge: " + exception);
            this.message("    while reading from: " + bufferedReader);
            ExceptionTracer.trace(exception);
            return false;
        }
    }

    @Override
    public synchronized void addMemoryListener(MemoryListener memoryListener) {
        MemoryListener[] memoryListenerArray = new MemoryListener[this._listenerCount + 1];
        for (int i = 0; i < this._listenerCount; ++i) {
            memoryListenerArray[i] = this._listenerArray[i];
        }
        memoryListenerArray[this._listenerCount] = memoryListener;
        this._listenerArray = memoryListenerArray;
        this._listenerCount = memoryListenerArray.length;
    }

    @Override
    public synchronized void removeMemoryListener(MemoryListener memoryListener) {
        if (this._listenerCount == 0) {
            this.message("-W- No memory listeners registers. Cannot remove " + memoryListener);
            return;
        }
        boolean bl = false;
        for (int i = 0; i < this._listenerCount; ++i) {
            if (this._listenerArray[i] != memoryListener) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.message("-W- Cannot remove unregistered MemoryListener " + memoryListener);
            return;
        }
        if (this._listenerCount == 1) {
            this._listenerArray = null;
            this._listenerCount = 0;
            return;
        }
        MemoryListener[] memoryListenerArray = new MemoryListener[this._listenerCount - 1];
        int n = 0;
        for (int i = 0; i < this._listenerCount; ++i) {
            if (this._listenerArray[i] == memoryListener) continue;
            memoryListenerArray[n++] = this._listenerArray[i];
        }
        this._listenerArray = memoryListenerArray;
        this._listenerCount = memoryListenerArray.length;
    }

    public void addMemoryListenerOld(MemoryListener memoryListener) {
        try {
            if (this._listenerTable == null) {
                this._listenerTable = new Hashtable();
            }
            this._listenerTable.put(memoryListener, memoryListener);
        }
        catch (Exception exception) {
            this.message("-E- failed to add MemoryListener: " + exception);
        }
    }

    public void removeMemoryListenerOld(MemoryListener memoryListener) {
        try {
            this._listenerTable.remove(memoryListener);
        }
        catch (Exception exception) {
            this.message("-E- failed to remove MemoryListener: " + exception);
        }
    }

    protected void notifyWriteListenersOld(int n, long l, long l2) {
        if (this._listenerTable != null) {
            Enumeration enumeration = this._listenerTable.keys();
            while (enumeration.hasMoreElements()) {
                ((MemoryListener)enumeration.nextElement()).memoryWrite(n, l, l2);
            }
        }
    }

    protected void notifyReadListenersOld(int n, long l) {
        if (this._listenerTable != null) {
            Enumeration enumeration = this._listenerTable.keys();
            while (enumeration.hasMoreElements()) {
                ((MemoryListener)enumeration.nextElement()).memoryRead(n, l);
            }
        }
    }

    public void parseRAM(String string) {
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            inputStream = DesignManager.getDesignManager().getInputStream(this, string);
            if (inputStream == null) {
                this.message("-W- GenericMemory.parseRAM: file/resource not found: '" + string + "'");
                System.out.println("-W- GenericMemory.parseRAM: file/resource not found: '" + string + "'");
                return;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            this.parse(bufferedReader);
            bufferedReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            this.message("-E- " + this.toString() + ".parseRAM(): Couldn't read from " + string);
            ExceptionTracer.trace(exception);
        }
    }

    @Override
    public boolean parse(BufferedReader bufferedReader) throws Exception {
        if (bufferedReader == null) {
            return false;
        }
        LineNumberReader lineNumberReader = new LineNumberReader(bufferedReader);
        String string = null;
        StringTokenizer stringTokenizer = null;
        int n = 0;
        if (debug) {
            this.message("-I- " + this.toString() + ": parsing... ");
        }
        while ((string = lineNumberReader.readLine()) != null) {
            try {
                if (string.startsWith("#label")) {
                    this.parseLabelLine(string);
                } else if (string.startsWith("#") || string.startsWith(";")) continue;
                stringTokenizer = new StringTokenizer(string, " \t:");
                if (stringTokenizer.countTokens() < 2) continue;
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2, 16);
                if (string3.indexOf(88) >= 0) {
                    this.setDataAt(n, -1L);
                    continue;
                }
                this.setDataAt(n, Long.parseLong(string3, 16));
            }
            catch (Exception exception) {
                this.message("-E- " + this.toString() + ".parse: " + exception.getMessage());
                this.message("-E- on line " + lineNumberReader.getLineNumber() + ": " + string);
            }
        }
        lineNumberReader.close();
        return true;
    }

    protected void parseLabelLine(String string) throws Exception {
        if (this._decoder == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t:");
        String string2 = stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16);
        String string3 = stringTokenizer.nextToken();
        if (debug) {
            this.message("-#- GenericMemory.parseLabelLine: " + string2 + " " + n + " " + string3);
        }
        this._decoder.addLabel(n, string3);
    }

    protected String getHexString(long l, int n) {
        String string;
        int n2;
        StringBuffer stringBuffer;
        if (l < 0L) {
            stringBuffer = new StringBuffer();
            for (n2 = 0; n2 < n; ++n2) {
                stringBuffer.append('X');
            }
            string = stringBuffer.toString();
        } else {
            string = Long.toHexString(l);
        }
        stringBuffer = new StringBuffer();
        n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    @Override
    public boolean save(PrintWriter printWriter) {
        int n = this.getHexDigitsPerWord();
        for (int i = 0; i < this.data.length; ++i) {
            String string = this.getHexString(i, 4);
            String string2 = this.getHexString(this.data[i], n);
            printWriter.println(string + ":" + string2);
        }
        printWriter.flush();
        return false;
    }

    @Override
    public void configure() {
        if (this.MEF == null) {
            int n = (int)Math.ceil((double)this.getSize() / 8.0);
            if (n > 40) {
                n = 40;
            }
            this.MEF = new MemoryEditorFrame(this, n, 8, "Edit " + this.getName() + " " + this.getClass().getName());
            this.addMemoryListener(this.MEF);
        }
        this.MEF.pack();
        this.MEF.setVisible(true);
    }

    @Override
    public Component getPropertySheet() {
        if (this.MEF != null) {
            return this.MEF;
        }
        return null;
    }

    @Override
    public void elaborate(Object object) {
        this.message("-E- you shouldn't call elaborate on a GenericMemory!");
    }

    @Override
    public void evaluate(Object object) {
        this.message("-E- you shouldn't call evaluate on a GenericMemory!");
    }

    public void notifyWriteListeners(int n, long l, long l2) {
        if (this._listenerCount > 0) {
            for (int i = 0; i < this._listenerCount; ++i) {
                this._listenerArray[i].memoryWrite(n, l, l2);
            }
        }
    }

    public void notifyReadListeners(int n, long l) {
        if (this._listenerCount > 0) {
            for (int i = 0; i < this._listenerCount; ++i) {
                this._listenerArray[i].memoryRead(n, l);
            }
        }
    }

    public void dbg(String string) {
        System.out.println(string);
    }

    public void warning(String string) {
        this.message(string);
        this.message("    on component " + this.toString());
        this.message("    at simulation time " + this.simulator.getSimTime());
    }

    public void checkInvalidateMemory() {
        if (SetupManager.getBoolean("Hades.Models.Memory.InvalidateOnUndefinedInputs", false)) {
            this.message("-W- invalidating memory on " + this.getFullName());
            this.initializeWithX();
        }
    }

    @Override
    public String getToolTip(Point point, long l) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "[" + this.n_words + "x" + this.n_bits + "]\n" + "\n" + "last read at " + this.last_read_addr + " data= " + this.last_read_data + "\n" + "last write at " + this.last_write_addr + " data= " + this.last_write_data;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getFullName();
    }

    public static void main(String[] stringArray) {
        GenericMemory genericMemory = new GenericMemory();
        genericMemory.configure();
    }

    @Override
    public int getAddrOffset() {
        return 0;
    }

    @Override
    public PropertySheet getConfigDialog() {
        return this.propertySheet;
    }
}

