/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.logic.GenericOnebitLogicObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;

public class AddressDecoderLR
extends GenericOnebitLogicObject {
    protected PortStdLogicVector port_A;
    protected PortStdLogic1164 port_nCS;
    protected StdLogicVector value_A;
    protected int _0 = 2;
    protected int _1 = 3;
    protected int _X = 1;
    protected StdLogic1164 _nCS = new StdLogic1164();
    protected long base0;
    protected long limit0;

    public void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.n_bits);
        this.port_nCS = new PortStdLogic1164(this, "nCS", 1, null);
        this.ports = new Port[]{this.port_A, this.port_nCS};
    }

    public String getFormattedBase0() {
        return this.format(this.base0);
    }

    public String getFormattedLimit0() {
        return this.format(this.limit0);
    }

    public void setFormattedBase0(String s) {
        this.base0 = this.parse(s);
    }

    public void setFormattedLimit0(String s) {
        this.limit0 = this.parse(s);
    }

    public long parse(String s) {
        StdLogicVector tmp = new StdLogicVector(this.n_bits);
        tmp.parse(s);
        return tmp.getValue();
    }

    public String format(long addr) {
        StdLogicVector tmp = new StdLogicVector(this.n_bits, addr);
        return tmp.toHexString();
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.delay + " " + this.base0 + " " + this.limit0);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(st.nextToken());
            this.base0 = Long.parseLong(st.nextToken());
            this.limit0 = Long.parseLong(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        this.simulator = this.parent.getSimulator();
        StdLogicVector value_A = this.port_A.getVectorOrUUU();
        long addr = value_A.getValue();
        double time = this.simulator.getSimTime() + this.delay;
        if (value_A.has_UXZ()) {
            this._nCS.setIntValue(this._X);
        } else {
            this._nCS.setIntValue((addr &= 0xFFFFFFFFL) >= this.base0 && addr <= this.limit0 ? this._0 : this._1);
        }
        this.setOutput(this.port_nCS, this._nCS, time);
    }

    public void setOutput(Port port, StdLogic1164 value, double time) {
        Signal signal = null;
        signal = port.getSignal();
        if (signal != null) {
            this.simulator.scheduleEvent(new SimEvent(signal, time, value, port));
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "#bits [1 .. 32]:", "width", "output delay [sec]:", "delay", "base  0 ", "formattedBase0", "limit 0 ", "formattedLimit0"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay\nand four address ranges, where base in \nis inclusive and limit inclusive \n");
        this.propertySheet.enableUpdateButton(true);
        this.propertySheet.pack();
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "addr<" + (this.n_bits - 1) + ":0>= " + this.port_A.getVectorOrUUU().toHexString() + "\n" + "nCS [" + this.getFormattedBase0() + ":" + this.getFormattedLimit0() + "]\n";
    }
}

