/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.logic;

import hades.gui.PropertySheet;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.symbols.Color_DIN_IEC_62;
import hades.symbols.ColoredRectangle;
import hades.symbols.ColoredValueLabel;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.objects.FigObject;
import jfig.utils.ExceptionTracer;

public class GenericOnebitLogicObject
extends SimObject
implements Simulatable,
Wakeable,
Serializable {
    protected int n_bits = 16;
    protected StdLogicVector vector;
    protected StdLogicVector vector_UUU;
    protected StdLogicVector vector_XXX;
    protected StdLogicVector vector_ZZZ;
    protected StdLogicVector vector_000;
    protected StdLogicVector vector_111;
    protected StdLogic1164 value;
    protected StdLogic1164 value_U;
    protected StdLogic1164 value_X;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected StdLogic1164 value_Z;
    protected double delay = this.defaultdelay = 1.0E-8;
    protected double defaultdelay;
    protected ColoredValueLabel valueLabel;

    public GenericOnebitLogicObject() {
        this.constructStandardValues();
        this.constructPorts();
    }

    protected void constructPorts() {
        this.ports = null;
    }

    protected void constructStandardValues() {
        this.vector_UUU = new StdLogicVector(this.n_bits, new StdLogic1164(0));
        this.vector_XXX = new StdLogicVector(this.n_bits, new StdLogic1164(1));
        this.vector_ZZZ = new StdLogicVector(this.n_bits, new StdLogic1164(4));
        this.vector_000 = new StdLogicVector(this.n_bits, new StdLogic1164(2));
        this.vector_111 = new StdLogicVector(this.n_bits, new StdLogic1164(3));
        this.vector = this.vector_UUU.copy();
        this.value_U = new StdLogic1164(0);
        this.value_X = new StdLogic1164(1);
        this.value_0 = new StdLogic1164(2);
        this.value_1 = new StdLogic1164(3);
        this.value_Z = new StdLogic1164(4);
        this.value = this.value_U;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double _delay) {
        this.delay = _delay < 0.0 ? this.defaultdelay : _delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = new Double(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal number format in String '" + s + "'");
            this.message("-w- Using default value: " + this.defaultdelay);
            this.delay = this.defaultdelay;
        }
    }

    public int getWidth() {
        return this.n_bits;
    }

    public void setWidth(int _n) {
        if (_n == this.getWidth()) {
            return;
        }
        if (this.isConnected()) {
            this.message("-E- Cannot change the width of an connected RTLIB object!");
            return;
        }
        if (this.n_bits < 1 || this.n_bits > 32) {
            this.message("-E- Bus width out of range [1..32], using 16 instead!");
            this.n_bits = 16;
        } else {
            this.n_bits = _n;
        }
        this.constructStandardValues();
        this.constructPorts();
        this.updateSymbol();
    }

    public void setWidth(String s) {
        int n;
        try {
            n = Integer.parseInt(s);
        }
        catch (Exception e) {
            n = 16;
        }
        this.setWidth(n);
    }

    public long getValue() {
        return this.value.intValue();
    }

    public void setValue(long _value) {
        this.value.setIntValue((int)_value);
        this.updateSymbol();
    }

    public void setValue(String s) {
        try {
            this.value.setValue(s);
        }
        catch (Exception e) {
            this.setValue(0L);
        }
    }

    public boolean isConnected() {
        if (this.ports == null) {
            return false;
        }
        int i = 0;
        while (i < this.ports.length) {
            if (this.ports[i].getSignal() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number of input bits:  [1 .. 32]:", "width", "output delay           [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay\nand the output value. Recognized formats:\nbinary: 0100ZXH0_b,\nhex:    abcd_h\ndecimal: 4711\n");
        this.propertySheet.setVisible(true);
    }

    protected void initValueLabel() {
        try {
            if (this.symbol == null) {
                return;
            }
            FigObject tmp = null;
            Enumeration e = this.symbol.elements();
            while (e.hasMoreElements()) {
                tmp = (FigObject)e.nextElement();
                if (!(tmp instanceof ColoredValueLabel)) continue;
                this.valueLabel = (ColoredValueLabel)tmp;
            }
            this.updateSymbol();
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initValueLabel(): " + e);
            e.printStackTrace();
        }
    }

    public void updateSymbol() {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".updateSymbol: " + this.vector);
        }
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        int intValue = (int)this.vector.getValue();
        Color color = Color_DIN_IEC_62.getColor(intValue);
        String sValue = this.vector.toDecString();
        Enumeration E = this.symbol.getMembers().elements();
        while (E.hasMoreElements()) {
            Object tmp = E.nextElement();
            if (tmp instanceof ColoredRectangle) {
                ((ColoredRectangle)tmp).setColor(color);
                continue;
            }
            if (!(tmp instanceof ColoredValueLabel)) continue;
            ((ColoredValueLabel)tmp).setColor(color);
            ((ColoredValueLabel)tmp).setText(sValue);
        }
        this.symbol.painter.paint(this.symbol, 20);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.updateSymbol();
    }

    public void wakeup(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".wakeup()");
        }
        this.updateSymbol();
    }

    public boolean initialize(String s) {
        block7: {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            try {
                if (n_tokens == 0) {
                    this.versionId = 1001L;
                    this.n_bits = 16;
                    this.constructStandardValues();
                    this.constructPorts();
                    break block7;
                }
                if (n_tokens == 1) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.n_bits = 16;
                    this.constructStandardValues();
                    this.constructPorts();
                    break block7;
                }
                if (n_tokens == 2) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.n_bits = Integer.parseInt(st.nextToken());
                    this.constructStandardValues();
                    this.constructPorts();
                    break block7;
                }
                if (n_tokens == 3) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.n_bits = Integer.parseInt(st.nextToken());
                    this.constructStandardValues();
                    this.constructPorts();
                    String sv = st.nextToken();
                    this.setValue(sv);
                    break block7;
                }
                if (n_tokens == 4) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.n_bits = Integer.parseInt(st.nextToken());
                    this.constructStandardValues();
                    this.constructPorts();
                    this.setValue(st.nextToken());
                    this.setDelay(st.nextToken());
                    break block7;
                }
                throw new Exception("invalid number of arguments");
            }
            catch (Exception e) {
                this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
            }
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.value.getChar() + " " + this.delay);
    }

    public SimObject copy() {
        GenericOnebitLogicObject tmp = null;
        try {
            tmp = (GenericOnebitLogicObject)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.setWidth(this.getWidth());
            tmp.setValue(this.getValue());
            tmp.setDelay(this.getDelay());
            tmp.setVersionId(this.getVersionId());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in GenericOnebitLogicObject.copy(): " + e);
            e.printStackTrace();
            ExceptionTracer.trace(e);
            return null;
        }
    }

    public String toString() {
        return this.getClass().toString() + ": " + this.getFullName();
    }
}

