/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.gui.PropertySheet;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.io.PrintWriter;

public class Subset
extends GenericRtlibObject {
    protected Port port_A;
    protected Port port_Y;
    protected StdLogicVector value_A;
    protected Label subsetLabel;
    protected int n_subset;
    protected int upper = 3;
    protected int lower = 0;
    static /* synthetic */ Class class$hades$signals$SignalStdLogicVector;

    public void constructPorts() {
        this.setBounds();
        this.ports = new Port[2];
        this.ports[0] = new Port(this, "A", 0, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = Subset.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.n_bits));
        this.ports[1] = new Port(this, "Y", 1, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = Subset.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.n_subset));
        this.port_A = this.ports[0];
        this.port_Y = this.ports[1];
        this.vector = new StdLogicVector(this.n_subset);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.getName());
        this.subsetLabel = new Label();
        this.subsetLabel.initialize("0 450 2 <3:0>");
        this.symbol.addMember(this.subsetLabel);
        this.symbol.update_bbox();
    }

    public int getUpper() {
        return this.upper;
    }

    public int getLower() {
        return this.lower;
    }

    public void setUpper(String s) {
        try {
            this.upper = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.upper = this.n_bits - 1;
        }
        this.constructPorts();
        this.updateSymbol();
        this.evaluate(null);
    }

    public void setLower(String s) {
        try {
            this.lower = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.lower = this.n_bits - 1;
        }
        this.constructPorts();
        this.updateSymbol();
        this.evaluate(null);
    }

    private void setBounds() {
        if (this.lower < 0) {
            this.lower = 0;
        }
        if (this.lower >= this.n_bits) {
            this.lower = this.n_bits - 1;
        }
        if (this.upper < this.lower) {
            this.upper = this.lower;
        }
        if (this.upper >= this.n_bits) {
            this.upper = this.n_bits - 1;
        }
        this.n_subset = this.upper - this.lower + 1;
    }

    public void evaluate(Object arg) {
        Signal signal_A;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if ((signal_A = this.port_A.getSignal()) == null) {
            this.vector = new StdLogicVector(this.n_subset);
        } else {
            this.value_A = (StdLogicVector)signal_A.getValue();
            this.vector = this.value_A.subset(this.upper, this.lower);
        }
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        simulator.scheduleWakeup(this, time, this);
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y != null) {
            simulator.scheduleEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
        }
    }

    public void updateSymbol() {
        if (this.subsetLabel != null) {
            this.subsetLabel.setText("<" + this.upper + ":" + this.lower + ">");
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.upper + " " + this.lower + " " + this.vector.toBinString() + " " + this.delay);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.upper = Integer.parseInt(st.nextToken());
            this.lower = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setValue(st.nextToken());
            this.setDelay(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "output value    [00..0X10_b]:", "value", "output delay           [sec]:", "delay", "upper subset index [31..lower]:", "upper", "lower subset index  [upper..0]:", "lower"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay,\noutput value\nand the upper and lower subset indices");
        this.propertySheet.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

