/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.gui.PropertySheet;
import hades.models.OutputConnector;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.symbols.Color_DIN_IEC_62;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;

public class OpinVector
extends GenericRtlibObject
implements OutputConnector {
    public static final int DECIMAL = 0;
    public static final int HEX = 1;
    public static final int BINARY = 2;
    protected int numberFormat = 0;
    protected Port port_A;
    protected Port port_toplevel;
    protected double t_delay = 1.0E-9;
    protected GenericRtlibObject.FlexibleLabelFormatter labelFormatter;
    static /* synthetic */ Class class$hades$signals$SignalStdLogicVector;

    public OpinVector() {
        this.setDelay(this.t_delay);
    }

    public void constructPorts() {
        this.ports = new Port[2];
        this.ports[0] = new Port(this, "A", 0, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = OpinVector.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.n_bits));
        this.ports[1] = new Port(this, this.name, 1, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = OpinVector.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.n_bits));
        this.port_A = this.ports[0];
        this.port_toplevel = this.ports[1];
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initValueLabel();
        this.labelFormatter = new GenericRtlibObject.FlexibleLabelFormatter();
        this.labelFormatter.setNumberFormat(this.numberFormat);
        this.valueLabel.setTextSource(this.labelFormatter);
        this.updateSymbol();
    }

    public void setName(String name) {
        super.setName(name);
        this.ports[1].setName(name);
    }

    public int getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String s) {
        try {
            this.numberFormat = Integer.parseInt(s);
            if (this.numberFormat < 0 || this.numberFormat > 2) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.message("-W- Illegal numberformat, please use 0, 1, or 2!");
            this.numberFormat = 0;
        }
        this.labelFormatter.setNumberFormat(this.numberFormat);
        this.updateSymbol();
    }

    public void updateSymbol() {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".updateSymbol: " + this.vector);
        }
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        int intValue = (int)this.vector.getValue();
        Color color = Color_DIN_IEC_62.getColor(intValue);
        this.valueLabel.setColor(color);
        this.symbol.painter.paint(this.symbol, 50);
    }

    StdLogicVector getVector() {
        return this.vector;
    }

    public void mousePressed(MouseEvent me) {
        if (SimObject.debug) {
            this.message("OpinVector mousePressed!, value=" + this.vector);
        }
        this.numberFormat = (this.numberFormat + 1) % 3;
        this.labelFormatter.setNumberFormat(this.numberFormat);
        this.updateSymbol();
    }

    public void evaluate(Object arg) {
        Signal signal_toplevel;
        Signal signal_A;
        if (SimObject.debug) {
            this.message(this.toString() + ".evaluate()");
        }
        if ((signal_A = this.port_A.getSignal()) == null) {
            this.message("-E- OpinVector.evaluate(): signal at Port A is null!");
            return;
        }
        this.vector = ((StdLogicVector)signal_A.getValue()).copy();
        if (this.enableAnimationFlag) {
            this.updateSymbol();
        }
        if ((signal_toplevel = this.port_toplevel.getSignal()) == null) {
            if (SimObject.debug) {
                this.message(this.toString() + ".toplevel is null!");
            }
            return;
        }
        SimKernel simulator = this.parent.getSimulator();
        if (simulator != null) {
            simulator.scheduleEvent(new SimEvent(signal_toplevel, simulator.getSimTime(), this.vector, this.port_toplevel));
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.delay + " " + this.numberFormat);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(st.nextToken());
            this.numberFormat = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "format [dec=0/hex=1/bin=2]:", "numberFormat"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, \nand number format. \n");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "value<" + (this.n_bits - 1) + ":0>= " + this.vector.toHexString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

