/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.gui.PropertySheet;
import hades.models.InputConnector;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Assignable;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.WakeupEvent;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import jfig.canvas.FigCanvasEvent;

public class IpinVector
extends GenericRtlibObject
implements InputConnector,
Assignable {
    protected Port port_Y;
    protected Port port_toplevel;
    protected int numberFormat = 0;
    protected double t_delay = 1.0E-9;
    static /* synthetic */ Class class$hades$signals$SignalStdLogicVector;

    public IpinVector() {
        this.setDelay(this.t_delay);
    }

    public void constructPorts() {
        this.ports = new Port[2];
        this.ports[0] = new Port(this, "Y", 1, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = IpinVector.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.n_bits));
        this.ports[1] = new Port(this, this.name, 6, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = IpinVector.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.n_bits));
        this.port_Y = this.ports[0];
        this.port_toplevel = this.ports[1];
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initValueLabel();
        this.labelFormatter = new GenericRtlibObject.FlexibleLabelFormatter();
        this.labelFormatter.setNumberFormat(this.numberFormat);
        this.valueLabel.setTextSource(this.labelFormatter);
        this.updateSymbol();
    }

    public void setName(String name) {
        super.setName(name);
        this.ports[1].setName(name);
    }

    public void setValue(String s) {
        if (SimObject.debug) {
            this.message("-#- IpinVector.setValue: " + s);
        }
        this.vector = new StdLogicVector(this.n_bits);
        this.vector.parse(s);
        this.schedule();
    }

    public void mousePressed(MouseEvent me) {
        if (SimObject.debug) {
            this.message("IpinVector mousePressed!, value=" + this.vector);
        }
        long maxint = this.vector.getBitMask();
        long value = this.vector.getValue();
        value = this.isUXZClick(me) ? (me.isShiftDown() ? (value == -2L ? -1L : (value == -1L ? -3L : (value == -3L ? -2L : -2L))) : (value == -3L ? -1L : (value == -1L ? -2L : (value == -2L ? -3L : -3L)))) : (me.isShiftDown() ? (this.vector.has_UXZ() ? maxint : value - 1L & maxint) : (this.vector.has_UXZ() ? 0L : ++value));
        this.vector = new StdLogicVector(this.n_bits, value);
        this.schedule();
    }

    public void schedule() {
        if (this.parent == null) {
            return;
        }
        SimKernel simulator = this.parent.getSimulator();
        if (simulator == null) {
            return;
        }
        double time = simulator.getSimTime() + this.delay;
        simulator.scheduleInteractiveEvent(new WakeupEvent(this, time, (Object)this));
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        SimEvent se = new SimEvent(signal_Y, simulator.getSimTime() + this.delay, this.vector, this.port_Y);
        simulator.scheduleInteractiveEvent(se);
    }

    public boolean isUXZClickOLD(MouseEvent evt) {
        Point pos = this.symbol.getPos();
        Point mousepos = ((FigCanvasEvent)evt).getWorldCoordinatePoint();
        int x_offset = mousepos.x - pos.x;
        return x_offset < 0 && x_offset > -1200;
    }

    public boolean isUXZClick(MouseEvent evt) {
        return evt.isControlDown();
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.updateSymbol();
        Signal signal_Y = this.port_Y.getSignal();
        if (this.simulator != null && this.vector != null && signal_Y != null) {
            this.simulator.scheduleEvent(new SimEvent(signal_Y, 0.0, this.vector, this.port_Y));
        }
    }

    public void evaluate(Object arg) {
        Signal signal_Y;
        Signal signal_toplevel;
        if (SimObject.debug) {
            this.message(this.toString() + ".evaluate()");
        }
        if ((signal_toplevel = this.port_toplevel.getSignal()) == null) {
            this.message("-E- " + this.toString() + ".evaluate: toplevel Signal is null??");
            return;
        }
        this.vector = ((StdLogicVector)signal_toplevel.getValue()).copy();
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        if (this.enableAnimationFlag) {
            simulator.scheduleWakeup(this, time, this);
        }
        if ((signal_Y = this.port_Y.getSignal()) != null) {
            simulator.scheduleEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
        }
    }

    public void assign(String value, double simTime) {
        try {
            Signal signal_Y = null;
            StdLogicVector tmp = new StdLogicVector(this.n_bits);
            tmp.parse(value);
            signal_Y = this.port_Y.getSignal();
            if (signal_Y != null) {
                this.simulator.scheduleEvent(new SimEvent(signal_Y, simTime, tmp, this.port_Y));
            }
            if (this.visible) {
                this.simulator.scheduleWakeup(this, simTime, tmp);
            }
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".assign: " + value);
            e.printStackTrace();
        }
    }

    public void wakeup(Object arg) {
        try {
            WakeupEvent evt = (WakeupEvent)arg;
            Object tmp = evt.getArg();
            if (tmp instanceof StdLogicVector) {
                StdLogicVector slv = (StdLogicVector)tmp;
                this.vector = slv.copy();
            }
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + arg);
        }
        if (this.enableAnimationFlag) {
            this.updateSymbol();
        }
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setValue(st.nextToken());
            this.setDelay(st.nextToken());
            this.numberFormat = Integer.parseInt(st.nextToken());
            this.setNumberFormat(this.numberFormat);
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.vector.toBinString() + " " + this.delay + " " + this.numberFormat);
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "output value    [00..0X10_b]:", "formattedValue", "output delay           [sec]:", "delay", "format [dec=0/hex=1/bin=2]:", "numberFormat"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay\nand the output value. Recognized formats:\nbinary: 0100ZXH0_b,\nhex:    0x0123 or abcd_h\ndecimal: 4711\n");
        this.propertySheet.enableUpdateButton(true);
        this.propertySheet.setVisible(true);
    }

    public int getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(String s) {
        try {
            this.numberFormat = Integer.parseInt(s);
            if (this.numberFormat < 0 || this.numberFormat > 2) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            this.message("-W- Illegal numberformat, please use 0, 1, or 2!");
            this.numberFormat = 0;
        }
        this.labelFormatter.setNumberFormat(this.numberFormat);
        this.updateSymbol();
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "value<" + (this.n_bits - 1) + ":0>= " + this.vector.toHexString() + "\n" + "(mouse click: increment | <shift>+click: decrement)" + "\n" + "(<cntrl>+click: toggle UXZ values)";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

