/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;

public class ExpandBit
extends GenericRtlibObject {
    PortStdLogic1164 port_A;
    PortStdLogicVector port_Y;

    public void constructPorts() {
        this.port_A = new PortStdLogic1164(this, "A", 0, null);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, this.n_bits);
        this.ports = new Port[2];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_Y;
    }

    public void evaluate(Object arg) {
        Signal signal_Y;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if ((signal_Y = this.port_Y.getSignal()) == null) {
            return;
        }
        StdLogic1164 value_A = this.port_A.getValueOrU();
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        this.vector = new StdLogicVector(this.n_bits);
        int i = 0;
        while (i < this.n_bits) {
            this.vector.setBitAt(i, value_A.copy());
            ++i;
        }
        simulator.scheduleEvent(new SimEvent(signal_Y, time, this.vector, this.port_Y));
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.delay);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "output delay           [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay,\noutput value\n");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "value<" + (this.n_bits - 1) + ":0>= " + this.vector.toHexString();
    }
}

