/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.arith;

import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.utils.ExceptionTracer;

public class DcoreALU2
extends GenericRtlibObject {
    protected PortStdLogicVector port_OPC;
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_B;
    protected PortStdLogicVector port_IMM;
    protected PortStdLogicVector port_Y;
    protected PortStdLogic1164 port_Cin;
    protected PortStdLogic1164 port_Cout;
    protected StdLogicVector vector_Y;
    protected StdLogic1164 value_Cout;
    protected StdLogicVector zero12;
    public int n_operations;
    protected int[] opcodeArray;
    protected int currentOpcode = 0;
    public static final int MOV = 0;
    public static final int ADDU = 1;
    public static final int ADDC = 2;
    public static final int SUBU = 3;
    public static final int AND_AB = 4;
    public static final int OR_AB = 5;
    public static final int XOR_AB = 6;
    public static final int NOT_A = 7;
    public static final int LSL = 8;
    public static final int LSR = 9;
    public static final int ASR = 10;
    public static final int SUBC = 11;
    public static final int LSLC = 12;
    public static final int LSRC = 13;
    public static final int ASRC = 14;
    public static final int CMP_EQ = 16;
    public static final int CMP_NEQ = 17;
    public static final int CMP_AGTB = 18;
    public static final int CMP_ALTB = 19;
    public static final int MOVI = 20;
    public static final int ADDI = 21;
    public static final int SUBI = 22;
    public static final int ANDI = 23;
    public static final int LSLI = 24;
    public static final int LSRI = 25;
    public static final int BSETI = 26;
    public static final int BCLRI = 27;
    public static final int CMPI = 28;
    public static final int RLC = 30;
    public static final int RRC = 31;
    String[] operationLabels = new String[]{"pass B", "A + B", "A + B + Cin, set C", "A - B", "A AND B", "A OR B", "A XOR B", "NOT A", "A << B.3:0", "A >> B.3:0", "A >>> B.3:0", "undefined", "A << 1, C=A.15", "A >> 1, C=A.0", "A >>> 1, C=A.0", "undefined", "pass A, compare A==B", "pass A, compare A<>B", "pass A, compare A>B", "pass A, compare A<B", "IMM4", "A + IMM4", "A - IMM4", "A AND IMM4", "A <<  IMM4", "A >>  IMM4", "A | 1<<IMM4", "A & !1<<IMM4", "undefined", "undefined", "undefined", "undefined"};
    protected ConfigDialog configDialog = null;

    public DcoreALU2() {
        this.n_operations = this.operationLabels.length;
        this.opcodeArray = new int[this.n_operations];
        for (int i = 0; i < this.n_operations; ++i) {
            this.opcodeArray[i] = i;
        }
        this.zero12 = new StdLogicVector(12, 0L);
    }

    @Override
    public void constructPorts() {
        this.port_OPC = new PortStdLogicVector((SimObject)this, "OPC", 0, null, 5);
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.n_bits);
        this.port_B = new PortStdLogicVector((SimObject)this, "B", 0, null, this.n_bits);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, this.n_bits);
        this.port_Cin = new PortStdLogic1164(this, "CIN", 0, null);
        this.port_Cout = new PortStdLogic1164(this, "COUT", 1, null);
        this.port_IMM = new PortStdLogicVector((SimObject)this, "IMM", 0, null, 4);
        this.ports = new Port[7];
        this.ports[0] = this.port_OPC;
        this.ports[1] = this.port_A;
        this.ports[2] = this.port_B;
        this.ports[3] = this.port_Y;
        this.ports[4] = this.port_Cin;
        this.ports[5] = this.port_Cout;
        this.ports[6] = this.port_IMM;
        this.vector_Y = new StdLogicVector(this.n_bits);
        this.value_Cout = Const1164.__U;
        this.vectorOutputPort = this.port_Y;
    }

    @Override
    public void write(PrintWriter printWriter) {
        printWriter.print(" " + this.versionId + " " + this.n_bits + " " + this.delay + " " + this.opcodeArray.length);
        for (int i = 0; i < this.opcodeArray.length; ++i) {
            printWriter.print(" ");
            printWriter.print(this.opcodeArray[i]);
        }
    }

    @Override
    public boolean initialize(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            this.versionId = Integer.parseInt(stringTokenizer.nextToken());
            this.n_bits = Integer.parseInt(stringTokenizer.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            this.message("-E- Error initializing " + this.toString() + ", s=" + string);
            ExceptionTracer.trace(exception);
        }
        return true;
    }

    @Override
    public SimObject copy() {
        DcoreALU2 dcoreALU2 = null;
        try {
            dcoreALU2 = (DcoreALU2)this.getClass().newInstance();
            dcoreALU2.setEditor(this.getEditor());
            dcoreALU2.setVisible(this.isVisible());
            dcoreALU2.setName(this.getName());
            dcoreALU2.setClassLoader(this.getClassLoader());
            dcoreALU2.setWidth(this.getWidth());
            dcoreALU2.setValue(this.getValue());
            dcoreALU2.setDelay(this.getDelay());
            dcoreALU2.setVersionId(this.getVersionId());
            dcoreALU2.opcodeArray = new int[this.opcodeArray.length];
            for (int i = 0; i < this.opcodeArray.length; ++i) {
                dcoreALU2.opcodeArray[i] = this.opcodeArray[i];
            }
            return dcoreALU2;
        }
        catch (Exception exception) {
            this.message("-E- Internal error in GenericRtlibObject.copy(): " + exception);
            exception.printStackTrace();
            ExceptionTracer.trace(exception);
            return null;
        }
    }

    @Override
    public void configure() {
        if (this.configDialog == null) {
            this.configDialog = new ConfigDialog();
        }
        this.configDialog.getFrame().setVisible(true);
    }

    @Override
    public Component getPropertySheet() {
        if (this.configDialog != null) {
            return this.configDialog.getFrame();
        }
        return null;
    }

    @Override
    public void evaluate(Object object) {
        if (debug) {
            this.message("-I- " + this.toString() + ".evaluate: " + object);
        }
        StdLogicVector stdLogicVector = this.port_OPC.getVectorOrUUU();
        StdLogicVector stdLogicVector2 = this.port_IMM.getVectorOrUUU();
        StdLogicVector stdLogicVector3 = this.port_A.getVectorOrUUU();
        StdLogicVector stdLogicVector4 = this.port_B.getVectorOrUUU();
        StdLogic1164 stdLogic1164 = this.port_Cin.getValueOrU();
        try {
            this.currentOpcode = this.decodeOpcode(stdLogicVector);
            this.calculateOutput(stdLogicVector3, stdLogicVector4, stdLogic1164, stdLogicVector2, this.currentOpcode);
            this.scheduleOutputsAndFlags();
        }
        catch (Exception exception) {
            this.message("-E- " + this.toString() + ".evaluate: internal error " + exception);
            this.message(" A,B,Cin,IMM,Y: " + stdLogicVector3 + " " + stdLogicVector4 + " " + stdLogic1164 + " " + stdLogicVector2 + " " + this.vector_Y);
            ExceptionTracer.trace(exception);
        }
    }

    public int decodeOpcode(StdLogicVector stdLogicVector) {
        int n = (int)stdLogicVector.getValue();
        if (n < 0) {
            return n;
        }
        if (n >= this.opcodeArray.length) {
            return -1;
        }
        return this.opcodeArray[n];
    }

    protected void scheduleOutputsAndFlags() {
        SimKernel simKernel = this.parent.getSimulator();
        double d = simKernel.getSimTime() + this.delay;
        this.schedule(simKernel, d, (Port)this.port_Y, this.vector_Y);
        this.schedule(simKernel, d, (Port)this.port_Cout, this.value_Cout);
    }

    void schedule(SimKernel simKernel, double d, Port port, Object object) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        simKernel.scheduleEvent(new SimEvent(signal, d, object, port));
    }

    void schedule(SimKernel simKernel, double d, Port port, StdLogic1164 stdLogic1164) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        simKernel.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, d, stdLogic1164, (Object)port));
    }

    protected void calculateOutput(StdLogicVector stdLogicVector, StdLogicVector stdLogicVector2, StdLogic1164 stdLogic1164, StdLogicVector stdLogicVector3, int n) {
        int n2 = 0;
        this.vector_Y = null;
        this.value_Cout = null;
        try {
            switch (n) {
                case 0: {
                    this.vector_Y = stdLogicVector2.copy();
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 1: {
                    this.vector_Y = stdLogicVector.add(stdLogicVector2);
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 2: {
                    if (!stdLogic1164.is_01()) {
                        this.vector_Y = this.vector_XXX.copy();
                        this.value_Cout = Const1164.__X;
                        break;
                    }
                    if (stdLogic1164.is_1()) {
                        this.vector_Y = stdLogicVector.add(stdLogicVector2).incr();
                        this.setCarry(stdLogicVector.getValue() + stdLogicVector2.getValue() + 1L);
                        break;
                    }
                    this.vector_Y = stdLogicVector.add(stdLogicVector2);
                    this.setCarry(stdLogicVector.getValue() + stdLogicVector2.getValue());
                    break;
                }
                case 3: {
                    this.vector_Y = stdLogicVector.sub(stdLogicVector2);
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 4: {
                    this.vector_Y = stdLogicVector.and_bitwise(stdLogicVector2);
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 5: {
                    this.vector_Y = stdLogicVector.or_bitwise(stdLogicVector2);
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 6: {
                    this.vector_Y = stdLogicVector.xor_bitwise(stdLogicVector2);
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 7: {
                    this.vector_Y = stdLogicVector.invert_bitwise();
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 8: {
                    if (stdLogicVector.has_UXZ() || stdLogicVector2.has_UXZ()) {
                        this.vector_Y = this.vector_XXX.copy();
                    } else {
                        n2 = (int)stdLogicVector2.subset(3, 0).getValue();
                        this.vector_Y = stdLogicVector.shl(n2);
                    }
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 9: {
                    if (stdLogicVector.has_UXZ() || stdLogicVector2.has_UXZ()) {
                        this.vector_Y = this.vector_XXX.copy();
                    } else {
                        n2 = (int)stdLogicVector2.subset(3, 0).getValue();
                        this.vector_Y = stdLogicVector.shr_logical(n2);
                    }
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 10: {
                    if (stdLogicVector.has_UXZ() || stdLogicVector2.has_UXZ()) {
                        this.vector_Y = this.vector_XXX.copy();
                    } else {
                        n2 = (int)stdLogicVector2.subset(3, 0).getValue();
                        this.vector_Y = stdLogicVector.shr_arithmetical(n2);
                    }
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 11: {
                    if (!stdLogic1164.is_01()) {
                        this.vector_Y = this.vector_XXX.copy();
                        this.value_Cout = Const1164.__X;
                        break;
                    }
                    if (stdLogic1164.is_1()) {
                        this.vector_Y = stdLogicVector.sub(stdLogicVector2).decr();
                        this.setCarry(stdLogicVector.getValue() - stdLogicVector2.getValue() - 1L);
                        break;
                    }
                    this.vector_Y = stdLogicVector.sub(stdLogicVector2);
                    this.setCarry(stdLogicVector.getValue() - stdLogicVector2.getValue());
                    break;
                }
                case 12: {
                    this.value_Cout = stdLogicVector.getBitAt(15);
                    this.vector_Y = stdLogicVector.shl(1);
                    break;
                }
                case 13: {
                    this.value_Cout = stdLogicVector.getBitAt(0);
                    this.vector_Y = stdLogicVector.shr_logical(1);
                    break;
                }
                case 14: {
                    this.value_Cout = stdLogicVector.getBitAt(0);
                    this.vector_Y = stdLogicVector.shr_arithmetical(1);
                    break;
                }
                case 16: {
                    this.vector_Y = stdLogicVector.copy();
                    if (stdLogicVector.has_UXZ() || stdLogicVector2.has_UXZ()) {
                        this.value_Cout = Const1164.__X;
                        break;
                    }
                    if (stdLogicVector.equals(stdLogicVector2)) {
                        this.value_Cout = Const1164.__1;
                        break;
                    }
                    this.value_Cout = Const1164.__0;
                    break;
                }
                case 17: {
                    this.vector_Y = stdLogicVector.copy();
                    if (stdLogicVector.has_UXZ() || stdLogicVector2.has_UXZ()) {
                        this.value_Cout = Const1164.__X;
                        break;
                    }
                    if (!stdLogicVector.equals(stdLogicVector2)) {
                        this.value_Cout = Const1164.__1;
                        break;
                    }
                    this.value_Cout = Const1164.__0;
                    break;
                }
                case 18: {
                    this.vector_Y = stdLogicVector.copy();
                    if (stdLogicVector.has_UXZ() || stdLogicVector2.has_UXZ()) {
                        this.value_Cout = Const1164.__X;
                        break;
                    }
                    if (stdLogicVector.getSignedValue() > stdLogicVector2.getSignedValue()) {
                        this.value_Cout = Const1164.__1;
                        break;
                    }
                    this.value_Cout = Const1164.__0;
                    break;
                }
                case 19: {
                    this.vector_Y = stdLogicVector.copy();
                    if (stdLogicVector.has_UXZ() || stdLogicVector2.has_UXZ()) {
                        this.value_Cout = Const1164.__X;
                        break;
                    }
                    if (stdLogicVector.getSignedValue() < stdLogicVector2.getSignedValue()) {
                        this.value_Cout = Const1164.__1;
                        break;
                    }
                    this.value_Cout = Const1164.__0;
                    break;
                }
                case 20: {
                    this.vector_Y = this.zero12.append(stdLogicVector3);
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 23: {
                    this.vector_Y = stdLogicVector.and_bitwise(this.zero12.append(stdLogicVector3));
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 21: {
                    this.vector_Y = stdLogicVector.add(this.zero12.append(stdLogicVector3));
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 22: {
                    this.vector_Y = stdLogicVector.sub(this.zero12.append(stdLogicVector3));
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 24: {
                    this.vector_Y = stdLogicVector.shl((int)stdLogicVector3.getValue());
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 25: {
                    this.vector_Y = stdLogicVector.shr_logical((int)stdLogicVector3.getValue());
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 26: {
                    this.vector_Y = stdLogicVector.or_bitwise(new StdLogicVector(16, 1 << (int)stdLogicVector3.getValue()));
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 27: {
                    this.vector_Y = stdLogicVector.and_bitwise(new StdLogicVector(16, ~(1 << (int)stdLogicVector3.getValue()) & 0xFFFF));
                    this.value_Cout = stdLogic1164;
                    break;
                }
                case 28: {
                    this.vector_Y = stdLogicVector.copy();
                    if (stdLogicVector.has_UXZ()) {
                        this.value_Cout = Const1164.__X;
                        break;
                    }
                    if (stdLogicVector.equals(this.zero12.append(stdLogicVector3))) {
                        this.value_Cout = Const1164.__1;
                        break;
                    }
                    this.value_Cout = Const1164.__0;
                    break;
                }
                case 30: {
                    this.value_Cout = stdLogicVector.getBitAt(15);
                    this.vector_Y = stdLogicVector.shl(1);
                    this.vector_Y.setBitAt(0, stdLogic1164);
                    break;
                }
                case 31: {
                    this.value_Cout = stdLogicVector.getBitAt(0);
                    this.vector_Y = stdLogicVector.shr_logical(1);
                    this.vector_Y.setBitAt(15, stdLogic1164);
                    break;
                }
                default: {
                    this.message("-W- DcoreALU2: undefined (open?) ALU opcode: " + n + ", ignored!");
                    this.vector_Y = this.vector_XXX.copy();
                    this.value_Cout = Const1164.__X;
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.message("-E- " + this.toString() + " internal error: " + exception);
        }
        this.vector = this.vector_Y;
    }

    public void setCarry(long l) {
        this.value_Cout = l > this.vector.getBitMask() || l < 0L ? Const1164.__1 : Const1164.__0;
    }

    public String getCurrentOpcodeName() {
        if (this.currentOpcode < 0) {
            return "UNDEFINED";
        }
        return this.operationLabels[this.currentOpcode];
    }

    @Override
    public String getToolTip(Point point, long l) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "operation: " + this.getCurrentOpcodeName() + "\n" + "value A:   " + this.port_A.getVectorOrUUU().toHexString() + "\n" + "value B:   " + this.port_B.getVectorOrUUU().toHexString() + "\n" + "value Cin: " + this.port_Cin.getValueOrU() + "\n" + "value Cout:" + this.value_Cout.getChar() + "\n" + "value Y:   " + this.vector.toHexString();
    }

    public static void msg(String string) {
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        DcoreALU2.msg("-I- DcoreALU2 selftest...");
        DcoreALU2 dcoreALU2 = new DcoreALU2();
        dcoreALU2.configure();
    }

    protected class ConfigDialog
    implements ActionListener {
        protected JFrame configFrame;
        protected JPanel textFieldsPanel;
        protected JPanel choicePanel;
        protected JPanel buttonPanel;
        protected JTextField nameTF;
        protected JTextField widthTF;
        protected JTextField delayTF;
        protected JButton okButton;
        protected JButton applyButton;
        protected JButton cancelButton;
        protected JComboBox[] operationChoice;

        public ConfigDialog() {
            this.configFrame = new JFrame("Configure: DcoreALU2 " + DcoreALU2.this.getName());
            this.buildTextFieldsPanel();
            this.buildOpcodeChoicePanel();
            this.buildButtonPanel();
            this.configFrame.getContentPane().add("North", this.textFieldsPanel);
            this.configFrame.getContentPane().add("Center", this.choicePanel);
            this.configFrame.getContentPane().add("South", this.buttonPanel);
            this.configFrame.pack();
            this.configFrame.setVisible(true);
        }

        public Frame getFrame() {
            return this.configFrame;
        }

        protected void buildTextFieldsPanel() {
            this.nameTF = new JTextField(DcoreALU2.this.getName(), 20);
            this.widthTF = new JTextField("" + DcoreALU2.this.getWidth(), 10);
            this.delayTF = new JTextField("" + DcoreALU2.this.getDelay(), 20);
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            jPanel.add(new JLabel(""));
            jPanel.add(new JLabel("instance name: ", 4));
            jPanel.add(new JLabel("bus width [1..32]: ", 4));
            jPanel.add(new JLabel("delay [sec.]: ", 4));
            jPanel.add(new JLabel(""));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
            jPanel2.add(new JLabel(""));
            jPanel2.add(this.nameTF);
            jPanel2.add(this.widthTF);
            jPanel2.add(this.delayTF);
            jPanel2.add(new JLabel(""));
            this.textFieldsPanel = new JPanel();
            this.textFieldsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.textFieldsPanel.setLayout(new BorderLayout());
            this.textFieldsPanel.add("Center", jPanel);
            this.textFieldsPanel.add("East", jPanel2);
        }

        protected void buildOpcodeChoicePanel() {
            this.choicePanel = new JPanel();
            this.choicePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.choicePanel.setLayout(new GridLayout(DcoreALU2.this.n_operations / 2 + 2, 2));
            this.choicePanel.add(new JLabel("opcode index and operation: ", 4));
            this.choicePanel.add(new JLabel(""));
            this.operationChoice = new JComboBox[DcoreALU2.this.n_operations];
            for (int i = 0; i < DcoreALU2.this.n_operations; ++i) {
                String string = Integer.toHexString(i);
                if (i < 16) {
                    string = "0" + string;
                }
                JLabel jLabel = new JLabel("  0x" + string + ":", 4);
                JPanel jPanel = new JPanel(new FlowLayout(2, 10, 0));
                JComboBox<String> jComboBox = new JComboBox<String>();
                for (int j = 0; j < DcoreALU2.this.operationLabels.length; ++j) {
                    jComboBox.addItem(DcoreALU2.this.operationLabels[j]);
                }
                jComboBox.setSelectedIndex(DcoreALU2.this.opcodeArray[i]);
                this.operationChoice[i] = jComboBox;
                jPanel.add(jLabel);
                jPanel.add(jComboBox);
                this.choicePanel.add(jPanel);
            }
            this.choicePanel.add(new JLabel(""));
            this.choicePanel.add(new JLabel(""));
        }

        protected void buildButtonPanel() {
            this.cancelButton = new JButton("Cancel");
            this.applyButton = new JButton("Apply");
            this.okButton = new JButton("OK");
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.buttonPanel.setLayout(new FlowLayout(1));
            this.buttonPanel.add(new JLabel(" "));
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(new JLabel(" "));
            this.buttonPanel.add(this.applyButton);
            this.buttonPanel.add(this.okButton);
            this.buttonPanel.add(new JLabel(" "));
            this.cancelButton.addActionListener(this);
            this.applyButton.addActionListener(this);
            this.okButton.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.cancelButton) {
                this.configFrame.setVisible(false);
            } else if (object == this.applyButton) {
                this.applyValues();
            } else if (object == this.okButton) {
                this.applyValues();
                this.configFrame.setVisible(false);
            } else {
                DcoreALU2.msg("-E- unknown event source: " + actionEvent);
            }
        }

        public void applyValues() {
            try {
                DcoreALU2.this.setName(this.nameTF.getText());
                DcoreALU2.this.setWidth(this.widthTF.getText());
                DcoreALU2.this.setDelay(this.delayTF.getText());
                for (int i = 0; i < DcoreALU2.this.opcodeArray.length; ++i) {
                    DcoreALU2.this.opcodeArray[i] = this.operationChoice[i].getSelectedIndex();
                }
            }
            catch (Exception exception) {
                DcoreALU2.this.message("-E- in " + DcoreALU2.this.toString() + ".applyValues: " + exception);
                ExceptionTracer.trace(exception);
            }
            DcoreALU2.this.evaluate(null);
        }
    }
}

