/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.arith;

import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jfig.utils.ExceptionTracer;

public class DcoreALU
extends GenericRtlibObject {
    protected PortStdLogicVector port_OPC;
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_B;
    protected PortStdLogicVector port_IMM;
    protected PortStdLogicVector port_Y;
    protected PortStdLogic1164 port_Cin;
    protected PortStdLogic1164 port_Cout;
    protected StdLogicVector vector_Y;
    protected StdLogic1164 value_Cout;
    protected StdLogicVector zero12;
    public int n_operations;
    protected int[] opcodeArray;
    protected int currentOpcode = 0;
    public static final int CONST_0 = 0;
    public static final int CONST_1 = 1;
    public static final int CONST_FFFF = 2;
    public static final int PASS_B = 3;
    public static final int INCR_A = 4;
    public static final int ADD_AB = 5;
    public static final int ADD_ABCin = 6;
    public static final int SUB_AB = 7;
    public static final int AND_AB = 8;
    public static final int OR_AB = 9;
    public static final int XOR_AB = 10;
    public static final int NOT_A = 11;
    public static final int SHL_A = 12;
    public static final int SRA_A = 13;
    public static final int ROL_A = 14;
    public static final int ROR_A = 15;
    public static final int CMP_EQ = 16;
    public static final int CMP_NEQ = 17;
    public static final int CMP_AGTB = 18;
    public static final int CMP_ALTB = 19;
    public static final int ADDI = 20;
    public static final int SUBI = 21;
    public static final int ANDI = 22;
    public static final int SHLI = 23;
    String[] operationLabels = new String[]{"const 0", "const 1", "const -1 (FFFF)", "pass B", "incr A", "add A + B", "add A + B + Cin", "sub A - B", "A and B", "A or B", "A xor B", "not A", "shl A, A << B", "sra A, A >> B", "rol A by B bits", "ror A by B bits", "pass A, compare A==B", "pass A, compare A<>B", "pass A, compare A>B", "pass A, compare A<B", "add A + immediate", "sub A - immediate", "A and immediate", "shl A by immediate"};
    protected ConfigDialog configDialog = null;

    public DcoreALU() {
        this.n_operations = this.operationLabels.length;
        this.opcodeArray = new int[this.n_operations];
        int i = 0;
        while (i < this.n_operations) {
            this.opcodeArray[i] = i;
            ++i;
        }
        this.zero12 = new StdLogicVector(12, 0L);
    }

    public void constructPorts() {
        this.port_OPC = new PortStdLogicVector((SimObject)this, "OPC", 0, null, 5);
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.n_bits);
        this.port_B = new PortStdLogicVector((SimObject)this, "B", 0, null, this.n_bits);
        this.port_Y = new PortStdLogicVector((SimObject)this, "Y", 1, null, this.n_bits);
        this.port_Cin = new PortStdLogic1164(this, "CIN", 0, null);
        this.port_Cout = new PortStdLogic1164(this, "COUT", 1, null);
        this.port_IMM = new PortStdLogicVector((SimObject)this, "IMM", 0, null, 4);
        this.ports = new Port[7];
        this.ports[0] = this.port_OPC;
        this.ports[1] = this.port_A;
        this.ports[2] = this.port_B;
        this.ports[3] = this.port_Y;
        this.ports[4] = this.port_Cin;
        this.ports[5] = this.port_Cout;
        this.ports[6] = this.port_IMM;
        this.vector_Y = new StdLogicVector(this.n_bits);
        this.value_Cout = Const1164.__U;
        this.vectorOutputPort = this.port_Y;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.delay + " " + this.opcodeArray.length);
        int i = 0;
        while (i < this.opcodeArray.length) {
            ps.print(" ");
            ps.print(this.opcodeArray[i]);
            ++i;
        }
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- Error initializing " + this.toString() + ", s=" + s);
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public SimObject copy() {
        DcoreALU tmp = null;
        try {
            tmp = (DcoreALU)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            tmp.setWidth(this.getWidth());
            tmp.setValue(this.getValue());
            tmp.setDelay(this.getDelay());
            tmp.setVersionId(this.getVersionId());
            tmp.opcodeArray = new int[this.opcodeArray.length];
            int i = 0;
            while (i < this.opcodeArray.length) {
                tmp.opcodeArray[i] = this.opcodeArray[i];
                ++i;
            }
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in GenericRtlibObject.copy(): " + e);
            e.printStackTrace();
            ExceptionTracer.trace(e);
            return null;
        }
    }

    public void configure() {
        if (this.configDialog == null) {
            this.configDialog = new ConfigDialog();
        }
        this.configDialog.getFrame().setVisible(true);
    }

    public Component getPropertySheet() {
        if (this.configDialog != null) {
            return this.configDialog.getFrame();
        }
        return null;
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate: " + arg);
        }
        StdLogicVector vector_OPC = this.port_OPC.getVectorOrUUU();
        StdLogicVector vector_IMM = this.port_IMM.getVectorOrUUU();
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_B = this.port_B.getVectorOrUUU();
        StdLogic1164 value_Cin = this.port_Cin.getValueOrU();
        try {
            this.currentOpcode = this.decodeOpcode(vector_OPC);
            this.calculateOutput(vector_A, vector_B, value_Cin, vector_IMM, this.currentOpcode);
            this.scheduleOutputsAndFlags();
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".evaluate: internal error " + e);
            this.message(" A,B,Cin,IMM,Y: " + vector_A + " " + vector_B + " " + value_Cin + " " + vector_IMM + " " + this.vector_Y);
            ExceptionTracer.trace(e);
        }
    }

    public int decodeOpcode(StdLogicVector OPC) {
        int tmp = (int)OPC.getValue();
        if (tmp < 0) {
            return tmp;
        }
        if (tmp >= this.opcodeArray.length) {
            return -1;
        }
        return this.opcodeArray[tmp];
    }

    protected void scheduleOutputsAndFlags() {
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        this.schedule(simulator, time, (Port)this.port_Y, this.vector_Y);
        this.schedule(simulator, time, (Port)this.port_Cout, this.value_Cout);
    }

    void schedule(SimKernel simulator, double time, Port port, Object value) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        simulator.scheduleEvent(new SimEvent(signal, time, value, port));
    }

    void schedule(SimKernel simulator, double time, Port port, StdLogic1164 v) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, v, (Object)port));
    }

    protected void calculateOutput(StdLogicVector A, StdLogicVector B, StdLogic1164 Cin, StdLogicVector IMM, int opcode) {
        int shiftcount = 0;
        this.vector_Y = null;
        this.value_Cout = null;
        try {
            switch (opcode) {
                case 0: {
                    this.vector_Y = new StdLogicVector(this.n_bits, 0L);
                    this.value_Cout = Cin;
                    break;
                }
                case 1: {
                    this.vector_Y = new StdLogicVector(this.n_bits, 1L);
                    this.value_Cout = Cin;
                    break;
                }
                case 2: {
                    this.vector_Y = new StdLogicVector(this.n_bits, Const1164.__1);
                    this.value_Cout = Cin;
                    break;
                }
                case 3: {
                    this.vector_Y = B.copy();
                    this.value_Cout = Cin;
                    break;
                }
                case 6: {
                    if (!Cin.is_01()) {
                        this.vector_Y = this.vector_XXX.copy();
                        this.value_Cout = Const1164.__X;
                        break;
                    }
                    if (Cin.is_1()) {
                        this.vector_Y = A.add(B).incr();
                        this.setCarry(A.getValue() + B.getValue() + 1L);
                        break;
                    }
                    this.vector_Y = A.add(B);
                    this.setCarry(A.getValue() + B.getValue());
                    break;
                }
                case 5: {
                    this.vector_Y = A.add(B);
                    this.value_Cout = Cin;
                    break;
                }
                case 7: {
                    this.vector_Y = A.sub(B);
                    this.value_Cout = Cin;
                    break;
                }
                case 4: {
                    this.vector_Y = A.incr();
                    this.value_Cout = Cin;
                    break;
                }
                case 8: {
                    this.vector_Y = A.and_bitwise(B);
                    this.value_Cout = Cin;
                    break;
                }
                case 9: {
                    this.vector_Y = A.or_bitwise(B);
                    this.value_Cout = Cin;
                    break;
                }
                case 10: {
                    this.vector_Y = A.xor_bitwise(B);
                    this.value_Cout = Cin;
                    break;
                }
                case 11: {
                    this.vector_Y = A.invert_bitwise();
                    this.value_Cout = Cin;
                    break;
                }
                case 12: {
                    shiftcount = (int)B.subset(3, 0).getValue();
                    if (shiftcount < 0) {
                        shiftcount = 0;
                    }
                    this.vector_Y = A.shl(shiftcount);
                    this.value_Cout = Cin;
                    break;
                }
                case 13: {
                    shiftcount = (int)B.subset(3, 0).getValue();
                    if (shiftcount < 0) {
                        shiftcount = 0;
                    }
                    this.vector_Y = A.shr_arithmetical(shiftcount);
                    this.value_Cout = Cin;
                    break;
                }
                case 14: {
                    shiftcount = (int)B.subset(3, 0).getValue();
                    if (shiftcount < 0) {
                        shiftcount = 0;
                    }
                    this.vector_Y = A.rol(shiftcount);
                    this.value_Cout = Cin;
                    break;
                }
                case 15: {
                    shiftcount = (int)B.subset(3, 0).getValue();
                    if (shiftcount < 0) {
                        shiftcount = 0;
                    }
                    this.vector_Y = A.ror(shiftcount);
                    this.value_Cout = Cin;
                    break;
                }
                case 16: {
                    this.vector_Y = A.copy();
                    if (A.equals(B)) {
                        this.value_Cout = Const1164.__1;
                        break;
                    }
                    this.value_Cout = Const1164.__0;
                    break;
                }
                case 17: {
                    this.vector_Y = A.copy();
                    if (!A.equals(B)) {
                        this.value_Cout = Const1164.__1;
                        break;
                    }
                    this.value_Cout = Const1164.__0;
                    break;
                }
                case 18: {
                    this.vector_Y = A.copy();
                    if (A.getSignedValue() > B.getSignedValue()) {
                        this.value_Cout = Const1164.__1;
                        break;
                    }
                    this.value_Cout = Const1164.__0;
                    break;
                }
                case 19: {
                    this.vector_Y = A.copy();
                    if (A.getSignedValue() < B.getSignedValue()) {
                        this.value_Cout = Const1164.__1;
                        break;
                    }
                    this.value_Cout = Const1164.__0;
                    break;
                }
                case 20: {
                    this.vector_Y = A.add(this.zero12.append(IMM));
                    this.value_Cout = Cin;
                    break;
                }
                case 21: {
                    this.vector_Y = A.sub(this.zero12.append(IMM));
                    this.value_Cout = Cin;
                    break;
                }
                case 22: {
                    this.vector_Y = A.and_bitwise(this.zero12.append(IMM));
                    this.value_Cout = Cin;
                    break;
                }
                case 23: {
                    this.vector_Y = A.shl((int)IMM.getValue());
                    this.value_Cout = Cin;
                    break;
                }
                default: {
                    this.message("-W- DcoreALU: undefined (open?) ALU opcode: " + opcode + ", ignored!");
                    this.vector_Y = this.vector_XXX.copy();
                    this.value_Cout = Const1164.__X;
                    break;
                }
            }
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + " internal error: " + e);
        }
        this.vector = this.vector_Y;
    }

    public void setCarry(long value) {
        this.value_Cout = value > this.vector.getBitMask() || value < 0L ? Const1164.__1 : Const1164.__0;
    }

    public String getCurrentOpcodeName() {
        if (this.currentOpcode < 0) {
            return "UNDEFINED";
        }
        return this.operationLabels[this.currentOpcode];
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "operation: " + this.getCurrentOpcodeName() + "\n" + "value A:   " + this.port_A.getVectorOrUUU().toHexString() + "\n" + "value B:   " + this.port_B.getVectorOrUUU().toHexString() + "\n" + "value Cin: " + this.port_Cin.getValueOrU() + "\n" + "value Cout:" + this.value_Cout.getChar() + "\n" + "value Y:   " + this.vector.toHexString();
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        DcoreALU.msg("-I- DcoreALU selftest...");
        DcoreALU alu = new DcoreALU();
        alu.configure();
    }

    protected class ConfigDialog
    implements ActionListener {
        protected JFrame configFrame;
        protected JPanel textFieldsPanel;
        protected JPanel choicePanel;
        protected JPanel buttonPanel;
        protected JTextField nameTF;
        protected JTextField widthTF;
        protected JTextField delayTF;
        protected JButton okButton;
        protected JButton applyButton;
        protected JButton cancelButton;
        protected JComboBox[] operationChoice;

        public ConfigDialog() {
            this.configFrame = new JFrame("Configure: DcoreALU " + DcoreALU.this.getName());
            this.buildTextFieldsPanel();
            this.buildOpcodeChoicePanel();
            this.buildButtonPanel();
            this.configFrame.getContentPane().add("North", this.textFieldsPanel);
            this.configFrame.getContentPane().add("Center", this.choicePanel);
            this.configFrame.getContentPane().add("South", this.buttonPanel);
            this.configFrame.pack();
            this.configFrame.setVisible(true);
        }

        public Frame getFrame() {
            return this.configFrame;
        }

        protected void buildTextFieldsPanel() {
            this.nameTF = new JTextField(DcoreALU.this.getName(), 20);
            this.widthTF = new JTextField("" + DcoreALU.this.getWidth(), 10);
            this.delayTF = new JTextField("" + DcoreALU.this.getDelay(), 20);
            JPanel lpanel = new JPanel(new GridLayout(0, 1));
            lpanel.add(new JLabel(""));
            lpanel.add(new JLabel("instance name: ", 4));
            lpanel.add(new JLabel("bus width [1..32]: ", 4));
            lpanel.add(new JLabel("delay [sec.]: ", 4));
            lpanel.add(new JLabel(""));
            JPanel tfpanel = new JPanel(new GridLayout(0, 1));
            tfpanel.add(new JLabel(""));
            tfpanel.add(this.nameTF);
            tfpanel.add(this.widthTF);
            tfpanel.add(this.delayTF);
            tfpanel.add(new JLabel(""));
            this.textFieldsPanel = new JPanel();
            this.textFieldsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.textFieldsPanel.setLayout(new BorderLayout());
            this.textFieldsPanel.add("West", lpanel);
            this.textFieldsPanel.add("East", tfpanel);
        }

        protected void buildOpcodeChoicePanel() {
            this.choicePanel = new JPanel();
            this.choicePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.choicePanel.setLayout(new GridLayout(DcoreALU.this.n_operations / 2 + 2, 2));
            this.choicePanel.add(new JLabel("opcode index and operation: ", 4));
            this.choicePanel.add(new JLabel(""));
            this.operationChoice = new JComboBox[DcoreALU.this.n_operations];
            int j = 0;
            while (j < DcoreALU.this.n_operations) {
                JLabel tmp_label = new JLabel("  " + j + ":", 4);
                JPanel tmp_panel = new JPanel(new FlowLayout(2, 10, 0));
                JComboBox<String> tmp_choice = new JComboBox<String>();
                int i = 0;
                while (i < DcoreALU.this.operationLabels.length) {
                    tmp_choice.addItem(DcoreALU.this.operationLabels[i]);
                    ++i;
                }
                tmp_choice.setSelectedIndex(DcoreALU.this.opcodeArray[j]);
                this.operationChoice[j] = tmp_choice;
                tmp_panel.add(tmp_label);
                tmp_panel.add(tmp_choice);
                this.choicePanel.add(tmp_panel);
                ++j;
            }
            this.choicePanel.add(new JLabel(""));
            this.choicePanel.add(new JLabel(""));
        }

        protected void buildButtonPanel() {
            this.cancelButton = new JButton("Cancel");
            this.applyButton = new JButton("Apply");
            this.okButton = new JButton("OK");
            this.buttonPanel = new JPanel();
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.buttonPanel.setLayout(new FlowLayout(1));
            this.buttonPanel.add(new JLabel(" "));
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(new JLabel(" "));
            this.buttonPanel.add(this.applyButton);
            this.buttonPanel.add(this.okButton);
            this.buttonPanel.add(new JLabel(" "));
            this.cancelButton.addActionListener(this);
            this.applyButton.addActionListener(this);
            this.okButton.addActionListener(this);
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == this.cancelButton) {
                this.configFrame.setVisible(false);
            } else if (source == this.applyButton) {
                this.applyValues();
            } else if (source == this.okButton) {
                this.applyValues();
                this.configFrame.setVisible(false);
            } else {
                DcoreALU.msg("-E- unknown event source: " + evt);
            }
        }

        public void applyValues() {
            try {
                DcoreALU.this.setName(this.nameTF.getText());
                DcoreALU.this.setWidth(this.widthTF.getText());
                DcoreALU.this.setDelay(this.delayTF.getText());
                int i = 0;
                while (i < DcoreALU.this.opcodeArray.length) {
                    DcoreALU.this.opcodeArray[i] = this.operationChoice[i].getSelectedIndex();
                    ++i;
                }
            }
            catch (Exception e) {
                DcoreALU.this.message("-E- in " + DcoreALU.this.toString() + ".applyValues: " + e);
                ExceptionTracer.trace(e);
            }
            DcoreALU.this.evaluate(null);
        }
    }
}

