/*
 * Decompiled with CFR 0.152.
 */
package hades.models.register;

import hades.gui.PropertySheet;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.BboxRectangle;
import hades.symbols.ClassLabel;
import hades.symbols.InstanceLabel;
import hades.symbols.Label;
import hades.symbols.Polyline;
import hades.symbols.PortSymbol;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.canvas.FigCanvasEvent;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;

public class Register
extends SimObject
implements Simulatable,
Serializable {
    public static final int w = 1200;
    public static final int h = 1200;
    protected int n_bits = 4;
    protected Port port_C;
    protected StdLogic1164 value_U = new StdLogic1164(0);
    protected StdLogic1164 value_X = new StdLogic1164(1);
    protected StdLogic1164 value_0 = new StdLogic1164(2);
    protected StdLogic1164 value_1 = new StdLogic1164(3);
    protected StdLogic1164[] data;
    protected Label[] labels;
    protected FigCompound display;
    protected double t_pass = 8.0E-9;
    protected double t_setup = 4.0E-9;

    public Register() {
        this.n_bits = this.getDefaultBitWidth();
        this.initPortsAndData();
    }

    protected int getDefaultBitWidth() {
        return 4;
    }

    protected boolean showDInputPorts() {
        return true;
    }

    protected void initPortsAndData() {
        if (this.n_bits < 0 || this.n_bits > 32) {
            this.message("-W- invalid number of bits: " + this.n_bits);
            this.message("-W- using 1 bit instead");
            this.n_bits = 1;
        }
        this.ports = new Port[this.n_bits + this.n_bits + 1];
        int i = 0;
        int j = 0;
        while (j < this.n_bits) {
            this.ports[i++] = new Port(this, "D" + j, 3, null);
            ++j;
        }
        int j2 = 0;
        while (j2 < this.n_bits) {
            this.ports[i++] = new Port(this, "Q" + j2, 1, null);
            ++j2;
        }
        this.ports[i] = new Port(this, "C", 0, null);
        this.port_C = this.ports[i];
        ++i;
        this.data = new StdLogic1164[this.n_bits];
        int j3 = 0;
        while (j3 < this.n_bits) {
            this.data[j3] = this.value_U;
            ++j3;
        }
    }

    public int getBitWidth() {
        return this.n_bits;
    }

    public void setBitWidth(int n_new) {
        int n_old = this.n_bits;
        if (n_new < 1) {
            this.message("-W- invalid Register bit width: " + n_new);
            this.message("-W- using width 1 instead");
            n_new = 1;
        }
        this.n_bits = n_new;
        if (this.n_bits != n_old) {
            this.initPortsAndData();
            if (this.symbol != null) {
                this.initDisplay();
            }
        }
    }

    public void setBitWidth(String s) {
        this.setBitWidth(Integer.parseInt(s));
    }

    public boolean needsDynamicSymbol() {
        return true;
    }

    public void constructDynamicSymbol() {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".constructDynamicSymbol...");
        }
        this.symbol = new Symbol();
        this.symbol.setParent(this);
        this.initDisplay();
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            int n_new = Integer.parseInt(st.nextToken());
            this.t_pass = Double.valueOf(st.nextToken());
            this.setBitWidth(n_new);
            if (SimObject.debug) {
                this.message("-I- Register.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            this.message("-E- Register.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.t_pass);
    }

    public double getPassTime() {
        return this.t_pass;
    }

    public void setPassTime(double t) {
        if (t >= 0.0) {
            this.t_pass = t;
        } else {
            this.t_pass = 8.0E-9;
            this.message("-W- changed invalid pass time " + t + " to " + this.t_pass);
        }
    }

    public void setPassTime(String s) {
        double t = 0.0;
        try {
            t = Double.valueOf(s);
        }
        catch (Exception e) {
            t = 8.0E-9;
        }
        this.setPassTime(t);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.initDisplay();
    }

    public void initDisplay() {
        int y;
        int x;
        PortSymbol portSymbol;
        int i;
        if (SimObject.debug) {
            this.message("-#- Register.initDisplay...");
        }
        if (this.symbol != null) {
            this.symbol.deleteAllMembers();
        }
        Point pos = this.symbol.getPos();
        this.symbol.move(-pos.x, -pos.y);
        this.display = new FigCompound();
        this.display.setTrafo(this.symbol.getTrafo());
        this.labels = new Label[this.n_bits];
        BboxRectangle bbr = new BboxRectangle();
        int xmax = (this.n_bits + 1) * 1200;
        bbr.initialize(" 0 0 " + xmax + " 1200");
        Rectangle rr = new Rectangle();
        rr.initialize("  0 0 " + xmax + " 1200");
        InstanceLabel il = new InstanceLabel();
        il.initialize("" + (xmax + 100) + " 1100 " + this.getName());
        Polyline clockline = new Polyline();
        clockline.initialize("3 450 0 600 300 750 0");
        Polyline leftline = new Polyline();
        leftline.initialize("2 0 1200 1200 1200");
        this.symbol.fastAddMember(bbr);
        this.symbol.fastAddMember(rr);
        this.symbol.fastAddMember(il);
        this.symbol.fastAddMember(clockline);
        this.symbol.fastAddMember(leftline);
        if (this.showDInputPorts()) {
            i = 0;
            while (i < this.n_bits) {
                portSymbol = new PortSymbol();
                x = (int)(((double)(this.n_bits - i) + 0.5) * 1200.0);
                y = 0;
                portSymbol.initialize("" + x + " " + y + " D" + i);
                this.display.fastAddMember(portSymbol);
                ++i;
            }
        }
        i = 0;
        while (i < this.n_bits) {
            portSymbol = new PortSymbol();
            x = (int)(((double)(this.n_bits - i) + 0.5) * 1200.0);
            y = 1200;
            portSymbol.initialize("" + x + " " + y + " Q" + i);
            this.display.fastAddMember(portSymbol);
            ++i;
        }
        this.createGlobalPortSymbols();
        Rectangle background = new Rectangle();
        xmax = 1200 + this.n_bits * 1200 - 50;
        background.initialize("1250 50 " + xmax + " 1150");
        FigAttribs attr = background.getAttributes();
        attr.currentLayer = 95;
        attr.fillStyle = 2;
        attr.fillColor = new Color(220, 220, 220);
        attr.lineColor = new Color(220, 220, 220);
        attr.fig_line_color = 7;
        attr.fig_fill_color = 0;
        attr.fig_area_fill = 5;
        background.setAttributes(attr);
        this.display.fastAddMember(background);
        int i2 = 0;
        while (i2 < this.n_bits) {
            x = (int)(((double)(this.n_bits - i2) + 0.5) * 1200.0);
            y = 950;
            this.labels[i2] = new Label();
            this.labels[i2].initialize("" + x + " " + y + " 2 U");
            attr = this.labels[i2].getAttributes();
            attr.fontSize = 24;
            attr.fig_font = 14;
            attr.currentLayer = 10;
            this.labels[i2].setAttributes(attr);
            this.display.fastAddMember(this.labels[i2]);
            ++i2;
        }
        int i3 = 1;
        while (i3 < this.n_bits) {
            Polyline polyline = new Polyline();
            x = (i3 + 1) * 1200;
            polyline.initialize("2 " + x + " 1000 " + x + " 1200");
            this.display.fastAddMember(polyline);
            ++i3;
        }
        this.addDisplayElementsToSymbol();
        this.symbol.update_bbox();
        this.symbol.build_sc_bbox();
        this.symbol.setTrafo(this.symbol.getTrafo());
        this.symbol.setObjectPainter(this.symbol.painter);
        this.symbol.move(pos.x, pos.y);
    }

    protected void createGlobalPortSymbols() {
        PortSymbol clockSymbol = new PortSymbol();
        clockSymbol.initialize("600 0 C");
        this.symbol.fastAddMember(clockSymbol);
        int xmax = (this.n_bits + 1) * 1200;
        ClassLabel cl = new ClassLabel();
        cl.initialize("" + (xmax + 100) + " 450 " + "Reg" + this.n_bits);
        this.symbol.fastAddMember(cl);
    }

    protected void addDisplayElementsToSymbol() {
        Enumeration E = this.display.getMembers().elements();
        while (E.hasMoreElements()) {
            FigObject tmp = (FigObject)E.nextElement();
            this.symbol.fastAddMember(tmp);
        }
    }

    protected void removeDisplayElementsFromSymbol() {
        Enumeration E = this.display.getMembers().elements();
        while (E.hasMoreElements()) {
            FigObject tmp = (FigObject)E.nextElement();
            this.symbol.deleteMember(tmp);
        }
    }

    public void show() {
        if (SimObject.debug) {
            this.message("-#- Register.show...");
        }
        if (this.symbol == null) {
            return;
        }
        if (this.symbol.painter == null) {
            return;
        }
        int i = 0;
        while (i < this.n_bits) {
            char value = StdLogic1164.chars[this.data[i].intValue()];
            this.labels[i].setText("" + value);
            ++i;
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 100);
        }
    }

    public void mousePressed(MouseEvent me) {
        if (SimObject.debug) {
            this.message("Register: mousePressed...");
        }
        try {
            FigCanvasEvent ME = (FigCanvasEvent)me;
            Point WP = ME.getWorldCoordinatePoint();
            int dx = WP.x - this.symbol.getPos().x;
            int index = this.n_bits - dx / 1200;
            if (SimObject.debug) {
                this.message("dx= " + dx + " index= " + index);
            }
            if (index < 0 || index > this.n_bits - 1) {
                return;
            }
            StdLogic1164 tmp = this.data[index];
            this.data[index] = tmp.is_0() ? this.value_1 : (tmp.is_1() && ME.isShiftDown() ? this.value_X : (tmp.is_1() ? this.value_0 : this.value_0));
            if (this.symbol != null) {
                this.show();
            }
            double time = this.simulator.getSimTime() + this.t_pass;
            this.schedule(index, time);
        }
        catch (Exception e) {
            this.message("-W- Exception in Register.mousePressed: " + e);
            e.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()...ignored.");
        }
        this.simulator = this.parent.getSimulator();
    }

    public void evaluate(Object arg) {
        int i;
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".evaluate...");
        }
        StdLogic1164 value_C = null;
        double time = this.simulator.getSimTime() + this.t_pass;
        Signal signal_C = this.port_C.getSignal();
        value_C = signal_C != null ? (StdLogic1164)signal_C.getValue() : this.value_U;
        if (signal_C == null) {
            i = 0;
            while (i < this.n_bits) {
                this.data[i] = this.value_U;
                ++i;
            }
        } else if (signal_C.hasEvent() && value_C.is_1()) {
            i = 0;
            while (i < this.n_bits) {
                Signal signal_tmp = this.ports[i].getSignal();
                this.data[i] = signal_tmp == null ? this.value_X : ((StdLogic1164)signal_tmp.getValue()).copy();
                ++i;
            }
        } else {
            return;
        }
        this.show();
        int i2 = 0;
        while (i2 < this.n_bits) {
            Port port_Q = this.ports[this.n_bits + i2];
            SignalStdLogic1164 signal_Q = (SignalStdLogic1164)port_Q.getSignal();
            if (signal_Q != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time, this.data[i2], (Object)port_Q));
            }
            ++i2;
        }
    }

    public void schedule(int bitIndex, double time) {
        Port port_Q = this.ports[this.n_bits + bitIndex];
        SignalStdLogic1164 signal_Q = (SignalStdLogic1164)port_Q.getSignal();
        if (signal_Q != null) {
            this.simulator.scheduleInteractiveEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Q, time, this.data[bitIndex], (Object)port_Q));
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "bit width:", "bitWidth", "pass time:", "passTime"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, \nnumber of bits [1 .. 64],\nand register delay parameters [seconds]");
        this.propertySheet.setVisible(true);
    }

    public SimObject copy() {
        Register tmp = null;
        try {
            tmp = (Register)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setBitWidth(this.getBitWidth());
            tmp.setPassTime(this.getPassTime());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in Register.copy: " + e);
            return null;
        }
    }

    public String toString() {
        return "Register<" + this.n_bits + ">: " + this.getFullName();
    }
}

