/*
 * Decompiled with CFR 0.152.
 */
package hades.models.register;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.HexFormat;
import hades.utils.LFSR32;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class LFSRGenerator
extends GenericGate
implements Simulatable {
    protected int n_outputs = 0;
    protected PortStdLogic1164 port_CLK;
    protected PortStdLogic1164 port_NRESET;
    private LFSR32 lfsr;
    private int seed = 13534451;

    public LFSRGenerator(int n_outputs) {
        this.n_outputs = n_outputs;
        this.port_CLK = new PortStdLogic1164(this, "CLK", 0, null);
        this.port_NRESET = new PortStdLogic1164(this, "NRESET", 0, null);
        this.ports = new Port[n_outputs + 2];
        int i = 0;
        while (i < n_outputs) {
            this.ports[i] = new PortStdLogic1164(this, "Q" + i, 1, null);
            ++i;
        }
        this.ports[n_outputs] = this.port_CLK;
        this.ports[n_outputs + 1] = this.port_NRESET;
        this.t_delay = 1.0E-8;
        this.lfsr = new LFSR32();
        this.lfsr.setValue(this.seed);
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        this.lfsr.setValue(this.seed);
        this.scheduleOutputs();
    }

    public void evaluate(Object arg) {
        Signal s_CLK = this.port_CLK.getSignal();
        StdLogic1164 value_CLK = this.port_CLK.getValueOrU();
        StdLogic1164 value_NR = this.port_NRESET.getValueOrU();
        if (!value_NR.is_1()) {
            this.scheduleOutputs();
            this.lfsr.setValue(this.seed);
        } else if (s_CLK != null && s_CLK.hasEvent() && value_CLK.is_1()) {
            this.lfsr.normal_clock();
            this.scheduleOutputs();
        }
    }

    private void scheduleOutputs() {
        int value = this.lfsr.getValue();
        int mask = 1;
        int i = 0;
        while (i < this.n_outputs) {
            Port port_QI = this.ports[i];
            Const1164 next_QI = null;
            next_QI = (value & mask) != 0 ? Const1164.__1 : Const1164.__0;
            this.scheduleOutputValueAfter(port_QI, next_QI, this.t_delay);
            mask <<= 1;
            ++i;
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_delay + " " + this.seed);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.t_delay = Double.valueOf(st.nextToken());
            this.seed = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- LFSR...initialize(): " + e + " " + s);
        }
        return true;
    }

    public int getValue() {
        return this.lfsr.getValue();
    }

    public void setValue(String s) {
        this.setValue(Integer.parseInt(s.trim(), 10));
    }

    public void setValue(int value) {
        this.lfsr.setValue(value);
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(String s) {
        this.setSeed(Integer.parseInt(s.trim(), 10));
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "gate delay [sec]:", "delay", "seed [int]:", "seed", "value [int]:", "value"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and gate delay:");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "value=" + HexFormat.getHexString(0xFFFFFFFFL & (long)this.getValue(), 8) + "\n" + "seed= " + HexFormat.getHexString(0xFFFFFFFFL & (long)this.getSeed(), 8);
    }
}

