/*
 * Decompiled with CFR 0.152.
 */
package hades.models.register;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.HexFormat;
import hades.utils.LFSR32;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class LFSRAnalyzer
extends GenericGate
implements Simulatable {
    protected int n_inputs = 0;
    protected PortStdLogic1164 port_CLK;
    protected PortStdLogic1164 port_NRESET;
    private LFSR32 lfsr;
    private int seed = 13534451;
    private int uxz_mask = 0;
    private int expectedValue = 0;

    public LFSRAnalyzer(int n_inputs) {
        this.n_inputs = n_inputs;
        this.port_CLK = new PortStdLogic1164(this, "CLK", 0, null);
        this.port_NRESET = new PortStdLogic1164(this, "NRESET", 0, null);
        this.ports = new Port[n_inputs + 2];
        int i = 0;
        while (i < n_inputs) {
            this.ports[i] = new PortStdLogic1164(this, "D" + i, 0, null);
            ++i;
        }
        this.ports[n_inputs] = this.port_CLK;
        this.ports[n_inputs + 1] = this.port_NRESET;
        this.t_delay = 1.0E-8;
        this.lfsr = new LFSR32();
        this.lfsr.setValue(this.seed);
        this.setUXZMask(0);
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        this.lfsr.setValue(this.seed);
        this.setUXZMask(0);
    }

    public void evaluate(Object arg) {
        Signal signal = this.port_CLK.getSignal();
        StdLogic1164 value_CLK = this.port_CLK.getValueOrU();
        StdLogic1164 value_NR = this.port_NRESET.getValueOrU();
        if (!value_NR.is_1()) {
            this.lfsr.setValue(this.seed);
            this.setUXZMask(0);
        } else if (signal != null && signal.hasEvent() && value_CLK.is_1()) {
            int pattern = this.sampleInputs();
            this.lfsr.signature_clock(pattern);
        }
    }

    private int sampleInputs() {
        int value = 0;
        int mask = 1;
        int i = 0;
        while (i < this.n_inputs) {
            PortStdLogic1164 port_DI = (PortStdLogic1164)this.ports[i];
            StdLogic1164 value_DI = port_DI.getValueOrU();
            if (value_DI.is_UXZ()) {
                this.uxz_mask |= mask;
            }
            if (value_DI.isHigh_1H()) {
                value |= mask;
            }
            mask <<= 1;
            ++i;
        }
        return value;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_delay + " " + this.seed + " " + this.expectedValue);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.t_delay = Double.valueOf(st.nextToken());
            this.seed = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                this.setExpectedValue(st.nextToken());
            }
        }
        catch (Exception e) {
            this.message("-E- LFSR...initialize(): " + e + " " + s);
        }
        return true;
    }

    public int getValue() {
        return this.lfsr.getValue();
    }

    public void setValue(String s) {
        this.setValue(Integer.parseInt(s.trim(), 10));
    }

    public void setValue(int value) {
        this.lfsr.setValue(value);
    }

    public int getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(int value) {
        this.expectedValue = value;
    }

    public void setExpectedValue(String s) {
        this.setExpectedValue(Integer.parseInt(s.trim(), 10));
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(String s) {
        this.setSeed(Integer.parseInt(s.trim(), 10));
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public int getUXZMask() {
        return this.uxz_mask;
    }

    public void setUXZMask(int mask) {
        this.uxz_mask = mask;
    }

    public void setUXZMask(String s) {
        this.setUXZMask(Integer.parseInt(s.trim(), 10));
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "gate delay [sec]:", "delay", "seed [int]:", "seed", "value [int]:", "value", "expected [int]:", "expectedValue", "uxz mask [int]", "uXZMask"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and gate delay:");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "value=" + HexFormat.getHexString(0xFFFFFFFFL & (long)this.getValue(), 8) + "\n" + "seed= " + HexFormat.getHexString(0xFFFFFFFFL & (long)this.getSeed(), 8);
    }
}

