/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.gui.WindowCloser;
import hades.manager.DesignManager;
import hades.models.pic.HexMemoryCanvas;
import hades.models.pic.MemoryDisassemblerView;
import hades.models.pic.TurboPicCore;
import hades.models.pic.WordButton;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import jfig.gui.SimpleTextViewer;

public class TurboPicGUI {
    private TurboPicCore pic;
    private JFrame frame;
    private FileDialog fileDialog;
    private WordButton workRegButton;
    private WordButton statusRegButton;
    private WordButton pcRegButton;
    private WordButton intconRegButton;
    private JCheckBox enableUpdateGuiCheckbox;
    private JCheckBox enableDebugSignalsCheckbox;
    private HexMemoryCanvas ramCanvas;
    private HexMemoryCanvas eepromCanvas;
    private HexMemoryCanvas stackCanvas;
    private MemoryDisassemblerView epromCanvas;
    private JCheckBoxMenuItem miWDT;
    private JMenuItem miNew;
    private JMenuItem miOpen;
    private JMenuItem miReload;
    private JMenuItem miSave;
    private JMenuItem miClose;
    private JMenuItem miLoadLabels;
    private JMenuItem miHelpAbout;
    private JMenuItem miHelpEditing;
    private JMenuItem miHelpBreakpoints;
    private JMenuItem miHelpOpcodes;
    private JMenuItem miHelpMemorymap;
    private JMenuItem miHelpStatusRegister;

    public void initializeListeners() {
        LoadListener loadListener = new LoadListener();
        this.miOpen.addActionListener(loadListener);
        this.miReload.addActionListener(loadListener);
        this.miSave.addActionListener(new SaveListener());
        this.miLoadLabels.addActionListener(new LoadLabelsListener());
        this.miWDT.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TurboPicGUI.this.pic.setEnableWDT(TurboPicGUI.this.miWDT.getState());
            }
        });
        this.miNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TurboPicGUI.this.pic.reset();
                TurboPicGUI.this.update();
                TurboPicGUI.this.epromCanvas.update();
            }
        });
        this.miClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TurboPicGUI.this.frame.setVisible(false);
            }
        });
        this.miHelpAbout.addActionListener(new SimpleHelpListener("/hades/models/pic/help/about.txt"));
        this.miHelpEditing.addActionListener(new SimpleHelpListener("/hades/models/pic/help/editing.txt"));
        this.miHelpBreakpoints.addActionListener(new SimpleHelpListener("/hades/models/pic/help/breakpoints.txt"));
        this.miHelpOpcodes.addActionListener(new SimpleHelpListener("/hades/models/pic/help/opcodes.txt"));
        this.miHelpMemorymap.addActionListener(new SimpleHelpListener("/hades/models/pic/help/memorymap.txt"));
        this.miHelpStatusRegister.addActionListener(new SimpleHelpListener("/hades/models/pic/help/statusregister.txt"));
    }

    public void prepareMainWindow() {
        this.pcRegButton = new WordButton("PC:", new TurboPicCore.PicRegPCAdapter(this.pic));
        this.workRegButton = new WordButton("Work:", new TurboPicCore.PicRegWAdapter(this.pic));
        this.statusRegButton = new WordButton("Status:", new TurboPicCore.PicRegSTATUSAdapter(this.pic));
        this.intconRegButton = new WordButton("Intcon:", new TurboPicCore.PicRegINTCONAdapter(this.pic));
        this.enableUpdateGuiCheckbox = new JCheckBox("Update display", false);
        this.enableUpdateGuiCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                ((TurboPicGUI)TurboPicGUI.this).pic.enableGUI = TurboPicGUI.this.enableUpdateGuiCheckbox.isSelected();
                TurboPicGUI.this.update();
            }
        });
        this.enableDebugSignalsCheckbox = new JCheckBox("Debug traces", false);
        this.enableDebugSignalsCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                ((TurboPicGUI)TurboPicGUI.this).pic.enableDebugSignals = TurboPicGUI.this.enableDebugSignalsCheckbox.isSelected();
                TurboPicGUI.this.update();
            }
        });
        this.ramCanvas = new HexMemoryCanvas(new TurboPicCore.PicMemoryRegbankAdapter(this.pic), 10, 8);
        this.eepromCanvas = new HexMemoryCanvas(new TurboPicCore.PicMemoryEepromAdapter(this.pic), 8, 8);
        this.stackCanvas = new HexMemoryCanvas(new TurboPicCore.PicMemoryStackAdapter(this.pic), 2, 4);
        this.epromCanvas = new MemoryDisassemblerView("Program memory:", new TurboPicCore.PicMemoryEpromAdapter(this.pic), null, null, 25);
        int y_row1 = 0;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constr = new GridBagConstraints();
        this.frame = new JFrame("PIC 16C84");
        this.frame.setBackground(Color.lightGray);
        this.frame.getContentPane().setLayout(gridbag);
        constr.fill = 0;
        constr.anchor = 12;
        constr.ipadx = 0;
        constr.ipady = 0;
        constr.insets = new Insets(0, 7, 0, 7);
        JLabel regfileLabel = new JLabel("Register file:", 4);
        constr.gridx = 1;
        constr.gridy = 0;
        constr.gridwidth = 8;
        constr.gridheight = 1;
        gridbag.setConstraints(regfileLabel, constr);
        this.frame.getContentPane().add(regfileLabel);
        constr.gridx = 1;
        constr.gridy = y_row1 += constr.gridheight;
        constr.gridwidth = 8;
        constr.gridheight = 10;
        JScrollPane ramPane = new JScrollPane(this.ramCanvas);
        ramPane.setPreferredSize(this.ramCanvas.getMinimumSize(10));
        gridbag.setConstraints(ramPane, constr);
        this.frame.getContentPane().add(ramPane);
        y_row1 += constr.gridheight;
        JLabel dummy = new JLabel("   ");
        constr.gridx = 9;
        constr.gridy = 0;
        constr.gridwidth = 1;
        constr.gridheight = 1;
        gridbag.setConstraints(dummy, constr);
        this.frame.getContentPane().add(dummy);
        JLabel epromCanvasLabel = new JLabel("Program memory:", 4);
        constr.gridx = 10;
        constr.gridy = 0;
        constr.gridwidth = 25;
        constr.gridheight = 1;
        gridbag.setConstraints(epromCanvasLabel, constr);
        this.frame.getContentPane().add(epromCanvasLabel);
        constr.gridx = 10;
        constr.gridy = 1;
        constr.gridwidth = 25;
        constr.gridheight = 24;
        gridbag.setConstraints(this.epromCanvas, constr);
        this.frame.getContentPane().add(this.epromCanvas);
        JLabel eepromCanvasLabel = new JLabel("EEPROM memory:", 4);
        constr.gridx = 1;
        constr.gridy = y_row1;
        constr.gridwidth = 8;
        constr.gridheight = 1;
        gridbag.setConstraints(eepromCanvasLabel, constr);
        this.frame.getContentPane().add(eepromCanvasLabel);
        constr.gridx = 1;
        constr.gridy = y_row1 += constr.gridheight;
        constr.gridwidth = 8;
        constr.gridheight = 4;
        JScrollPane eepromPane = new JScrollPane(this.eepromCanvas);
        eepromPane.setPreferredSize(this.eepromCanvas.getMinimumSize(4));
        gridbag.setConstraints(eepromPane, constr);
        this.frame.getContentPane().add(eepromPane);
        JLabel stackLabel = new JLabel("Stack:", 4);
        constr.gridx = 1;
        constr.gridy = y_row1 += constr.gridheight;
        constr.gridwidth = 8;
        constr.gridheight = 1;
        gridbag.setConstraints(stackLabel, constr);
        this.frame.getContentPane().add(stackLabel);
        constr.gridx = 1;
        constr.gridy = y_row1 += constr.gridheight;
        constr.gridwidth = 8;
        constr.gridheight = 2;
        JScrollPane stackPane = new JScrollPane(this.stackCanvas);
        stackPane.setPreferredSize(this.stackCanvas.getMinimumSize(3));
        gridbag.setConstraints(stackPane, constr);
        this.frame.getContentPane().add(stackPane);
        JLabel dummy2 = new JLabel("   ");
        constr.gridx = 1;
        constr.gridy = y_row1 += constr.gridheight;
        constr.gridwidth = 8;
        constr.gridheight = 1;
        gridbag.setConstraints(dummy2, constr);
        this.frame.getContentPane().add(dummy2);
        constr.gridx = 1;
        constr.gridy = y_row1 += constr.gridheight;
        constr.gridwidth = 4;
        constr.gridheight = 1;
        gridbag.setConstraints(this.workRegButton, constr);
        this.frame.getContentPane().add(this.workRegButton);
        constr.gridx = 5;
        constr.gridy = y_row1;
        constr.gridwidth = 4;
        constr.gridheight = 1;
        gridbag.setConstraints(this.statusRegButton, constr);
        this.frame.getContentPane().add(this.statusRegButton);
        constr.gridx = 1;
        constr.gridy = y_row1 += constr.gridheight;
        constr.gridwidth = 4;
        constr.gridheight = 1;
        gridbag.setConstraints(this.pcRegButton, constr);
        this.frame.getContentPane().add(this.pcRegButton);
        constr.gridx = 5;
        constr.gridy = y_row1;
        constr.gridwidth = 4;
        constr.gridheight = 1;
        gridbag.setConstraints(this.intconRegButton, constr);
        this.frame.getContentPane().add(this.intconRegButton);
        JLabel dummy3 = new JLabel("   ");
        constr.gridx = 1;
        constr.gridy = y_row1 += constr.gridheight;
        constr.gridwidth = 8;
        constr.gridheight = 1;
        gridbag.setConstraints(dummy3, constr);
        this.frame.getContentPane().add(dummy3);
        constr.gridx = 10;
        constr.gridy = y_row1 += constr.gridheight;
        constr.gridwidth = 4;
        constr.gridheight = 1;
        gridbag.setConstraints(this.enableUpdateGuiCheckbox, constr);
        this.frame.getContentPane().add(this.enableUpdateGuiCheckbox);
        constr.gridx = 14;
        constr.gridy = y_row1;
        constr.gridwidth = 4;
        constr.gridheight = 1;
        gridbag.setConstraints(this.enableDebugSignalsCheckbox, constr);
        this.frame.getContentPane().add(this.enableDebugSignalsCheckbox);
        JMenuBar mb = new JMenuBar();
        JMenu filemenu = new JMenu("File");
        this.miNew = new JMenuItem("New");
        this.miOpen = new JMenuItem("Open...");
        this.miReload = new JMenuItem("Reload...");
        this.miLoadLabels = new JMenuItem("Load labels...");
        this.miSave = new JMenuItem("Save as...");
        this.miClose = new JMenuItem("Close");
        filemenu.add(this.miNew);
        filemenu.add(this.miOpen);
        filemenu.add(this.miReload);
        filemenu.add(this.miLoadLabels);
        filemenu.addSeparator();
        filemenu.add(this.miSave);
        filemenu.addSeparator();
        filemenu.add(this.miClose);
        JMenu componentsmenu = new JMenu("Components");
        this.miWDT = new JCheckBoxMenuItem("Watchdog-Timer");
        componentsmenu.add(this.miWDT);
        JMenu helpmenu = new JMenu("Help");
        this.miHelpAbout = new JMenuItem("About...");
        this.miHelpEditing = new JMenuItem("Editing...");
        this.miHelpBreakpoints = new JMenuItem("Breakpoints...");
        this.miHelpOpcodes = new JMenuItem("PIC16C8x opcodes...");
        this.miHelpMemorymap = new JMenuItem("PIC16C8x memory map...");
        this.miHelpStatusRegister = new JMenuItem("PIC16C8x status register...");
        helpmenu.add(this.miHelpAbout);
        helpmenu.addSeparator();
        helpmenu.add(this.miHelpEditing);
        helpmenu.add(this.miHelpBreakpoints);
        helpmenu.addSeparator();
        helpmenu.add(this.miHelpOpcodes);
        helpmenu.add(this.miHelpMemorymap);
        helpmenu.add(this.miHelpStatusRegister);
        mb.add(filemenu);
        mb.add(componentsmenu);
        mb.add(helpmenu);
        this.frame.setJMenuBar(mb);
        this.frame.addWindowListener(new WindowCloser(this.frame));
        this.frame.pack();
    }

    public TurboPicGUI(TurboPicCore _pic) {
        this.pic = _pic;
        this.prepareMainWindow();
        this.initializeListeners();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void update() {
        if (this.enableUpdateGuiCheckbox.isSelected()) {
            this.workRegButton.smartUpdate();
            this.pcRegButton.smartUpdate();
            this.statusRegButton.smartUpdate();
            this.intconRegButton.smartUpdate();
            this.ramCanvas.smartUpdate();
            this.stackCanvas.smartUpdate();
            this.eepromCanvas.smartUpdate();
        }
    }

    public void load(String name, String dir) {
        try {
            this.pic.loadProgramFormatHEX(new FileInputStream(new File(name, dir)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(String name, String dir) {
        this.pic.error("Save program not implemented!");
    }

    public static void main(String[] argv) throws Exception {
        TurboPicCore pic = new TurboPicCore();
        TurboPicGUI showPic = new TurboPicGUI(pic);
        try {
            pic.loadProgramFormatHEX(new FileInputStream("pedal-nomux.hex"));
        }
        catch (Throwable t) {
            // empty catch block
        }
        showPic.frame.setVisible(true);
        System.out.println("-#- GUI init ok., executing program...");
        int N = 1000000;
        int i = 0;
        while (i < N) {
            pic.singleStep();
            showPic.update();
            ++i;
        }
        System.out.println("-#- program execution stopped " + N);
    }

    class SaveListener
    implements ActionListener {
        SaveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (TurboPicGUI.this.fileDialog == null) {
                TurboPicGUI.this.fileDialog = new FileDialog(TurboPicGUI.this.frame);
            }
            TurboPicGUI.this.fileDialog.setMode(1);
            TurboPicGUI.this.fileDialog.setTitle("Save PIC ROM-Image");
            TurboPicGUI.this.fileDialog.setFilenameFilter(new RomHexFilter());
            TurboPicGUI.this.fileDialog.setVisible(true);
            String name = TurboPicGUI.this.fileDialog.getFile();
            String dir = TurboPicGUI.this.fileDialog.getDirectory();
            if (name != null) {
                TurboPicGUI.this.save(name, dir);
            }
        }
    }

    class LoadLabelsListener
    implements ActionListener {
        private String name;
        private String dir;

        LoadLabelsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (TurboPicGUI.this.fileDialog == null) {
                    TurboPicGUI.this.fileDialog = new FileDialog(TurboPicGUI.this.frame);
                }
                TurboPicGUI.this.fileDialog.setMode(0);
                TurboPicGUI.this.fileDialog.setTitle("Load PIC EPROM-Labels");
                TurboPicGUI.this.fileDialog.setVisible(true);
                this.name = TurboPicGUI.this.fileDialog.getFile();
                this.dir = TurboPicGUI.this.fileDialog.getDirectory();
                if (this.name != null) {
                    FileInputStream FIS = new FileInputStream(this.dir + this.name);
                    TurboPicGUI.this.pic.error("Load labels not implemented");
                    FIS.close();
                }
            }
            catch (Exception t) {
                System.err.println("-E- TurboPicGUI.LoadLabelsListener: " + t);
            }
        }
    }

    class LoadListener
    implements ActionListener {
        private String name;
        private String dir;

        LoadListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Open...")) {
                if (TurboPicGUI.this.fileDialog == null) {
                    TurboPicGUI.this.fileDialog = new FileDialog(TurboPicGUI.this.frame);
                }
                TurboPicGUI.this.fileDialog.setMode(0);
                TurboPicGUI.this.fileDialog.setTitle("Load PIC ROM-Image");
                TurboPicGUI.this.fileDialog.setFilenameFilter(new RomHexFilter());
                TurboPicGUI.this.fileDialog.setVisible(true);
                this.name = TurboPicGUI.this.fileDialog.getFile();
                this.dir = TurboPicGUI.this.fileDialog.getDirectory();
            } else if (e.getActionCommand().equals("Reload...")) {
                System.out.println("-#- TurboPicGUI: reloading program...");
            } else {
                System.out.println("-E- TurboPicGUI: reloading program...");
                return;
            }
            if (this.name != null) {
                TurboPicGUI.this.load(this.name, this.dir);
                TurboPicGUI.this.epromCanvas.update();
            }
        }
    }

    class SimpleHelpListener
    implements ActionListener {
        private String helpFileName = null;

        public SimpleHelpListener(String s) {
            this.helpFileName = s;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                SimpleTextViewer helpViewer = new SimpleTextViewer(this.helpFileName, 30, 80);
                helpViewer.parse(DesignManager.getDesignManager().getInputStream(this, this.helpFileName));
                helpViewer.setVisible(true);
            }
            catch (Exception e) {
                System.err.println("-E- in SimpleHelpListener: " + e);
            }
        }
    }

    class RomHexFilter
    implements FilenameFilter {
        RomHexFilter() {
        }

        public boolean accept(File dir, String name) {
            if (name.endsWith(".rom") || name.endsWith(".hex")) {
                return true;
            }
            return new File(dir, name).isDirectory();
        }
    }
}

