/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicByteReg;
import hades.models.pic.PicExec;
import hades.models.pic.PicReg;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class TestPic {
    public PicExec pic = new PicExec();
    PrintStream out = System.out;
    InputStream in = System.in;

    public void printBit(String name, boolean bit) {
        this.out.print(name);
        if (bit) {
            this.out.print("-set  ");
        } else {
            this.out.print("-clr  ");
        }
    }

    public void printStatus() {
        PicByteReg status = this.pic.regBank.status;
        this.out.print("Status: ");
        this.printBit("Z", status.getBit(0));
        this.printBit("DC", status.getBit(1));
        this.printBit("C", status.getBit(2));
        this.printBit("Power", status.getBit(3));
        this.printBit("Time", status.getBit(4));
        this.printBit("Rp0", status.getBit(5));
        this.printBit("Rp1", status.getBit(6));
        this.printBit("Irp", status.getBit(7));
        this.out.println();
    }

    public void printReg(String name, PicReg reg) {
        this.out.print(name);
        this.out.print("=");
        this.out.print(Integer.toHexString(reg.read()));
        this.out.print("  ");
    }

    public void printBaseRegs() {
        this.out.print("Base-Regs: ");
        this.printReg("WORK", this.pic.workReg);
        this.printReg("INDF", this.pic.regBank.indf);
        this.printReg("TMR0", this.pic.regBank.tmr0);
        this.printReg("PCL", this.pic.regBank.pcl);
        this.printReg("STATUS", this.pic.regBank.status);
        this.printReg("FSR", this.pic.regBank.fsr);
        this.printReg("PORTA", this.pic.regBank.porta);
        this.out.println();
    }

    public void printInternal() {
        this.out.print("Internal: State=");
        this.out.print(this.pic.clocking.getState());
        this.out.print(" Inst=");
        this.out.print(Integer.toHexString(this.pic.nextInstruction.read()));
        this.out.print(" Op=");
        this.out.print(Integer.toHexString(this.pic.operand));
        this.out.print(" Result=");
        this.out.print(Integer.toHexString(this.pic.result));
        this.printBit(" Skip", this.pic.skip.getBit());
        this.out.println();
    }

    public void printDecode() {
        this.out.print("Decode: All=");
        this.out.print(Integer.toHexString(this.pic.decode.getDecoded()));
        this.out.print(" Reg=");
        this.out.print(Integer.toHexString(this.pic.decode.getRegister()));
        this.out.print(" Dest=");
        this.out.print(this.pic.decode.getDestination());
        this.out.print(" ALU=");
        this.out.print(Integer.toHexString(this.pic.decode.getInstruction()));
        this.out.println();
    }

    public String fillString(String in, int len) {
        String out = new String(in);
        while (len > out.length()) {
            out = " " + out;
        }
        return out;
    }

    public int splitInput(String input, String[] word) {
        int wordCount = 0;
        int pos = 0;
        int start = 0;
        while (true) {
            if (pos < input.length() && input.substring(pos, pos + 1).equals(" ")) {
                ++pos;
                continue;
            }
            start = pos;
            while (pos < input.length() && !input.substring(pos, pos + 1).equals(" ")) {
                ++pos;
            }
            if (pos > start) {
                word[wordCount++] = new String(input.substring(start, pos));
            }
            if (pos >= input.length()) break;
        }
        return wordCount;
    }

    /*
     * Unable to fully structure code
     */
    public void workloop() {
        exit = false;
        len = 0;
        command = "";
        word = new String[20];
        wordCount = 0;
        buffer = new byte[1000];
        do {
            this.printBaseRegs();
            this.printStatus();
            this.printInternal();
            this.printDecode();
            this.out.print("> ");
            this.out.flush();
            try {
                len = this.in.read(buffer);
            }
            catch (IOException e) {
                this.out.println("IOException!!");
                exit = true;
            }
            command = new String(buffer, 0, len - 1);
            wordCount = this.splitInput(command, word);
            i = 0;
            while (i < wordCount) {
                this.out.print(word[i]);
                this.out.print("/");
                ++i;
            }
            this.out.println(wordCount);
            if (wordCount <= 0) ** GOTO lbl130
            if (word[0].equalsIgnoreCase("EXIT")) {
                this.out.println("Exit!");
                exit = true;
                continue;
            }
            if (word[0].equalsIgnoreCase("STEP")) {
                this.out.println("Step");
                this.pic.clock();
                this.pic.clock();
                System.out.print("RESULT = ");
                System.out.println(this.pic.result);
                continue;
            }
            if (word[0].equalsIgnoreCase("CLOCK")) {
                this.out.println("CLOCK");
                i = 0;
                while (i < 8) {
                    this.pic.clock();
                    ++i;
                }
            } else {
                if (word[0].equalsIgnoreCase("RROM")) {
                    this.out.println("RROM");
                    if (wordCount < 2) continue;
                    addr = Integer.parseInt(word[1], 16);
                    this.out.print(Integer.toHexString(addr));
                    this.out.print(": ");
                    this.out.println(Integer.toHexString(this.pic.eprom.readMemory(addr)));
                    continue;
                }
                if (word[0].equalsIgnoreCase("RRAM")) {
                    this.out.println("RRAM");
                    if (wordCount < 2) continue;
                    addr = Integer.parseInt(word[1], 16);
                    this.out.print(Integer.toHexString(addr));
                    this.out.print(": ");
                    this.out.println(Integer.toHexString(this.pic.regBank.readMemory(addr)));
                    continue;
                }
                if (word[0].equalsIgnoreCase("WROM")) {
                    this.out.println("WROM");
                    if (wordCount < 3) continue;
                    addr = Integer.parseInt(word[1], 16);
                    value = Integer.parseInt(word[2], 16);
                    this.out.print(Integer.toHexString(addr));
                    this.out.print(": ");
                    this.out.println(Integer.toHexString(value));
                    this.pic.eprom.writeMemory(addr, value);
                    continue;
                }
                if (word[0].equalsIgnoreCase("WRAM")) {
                    this.out.println("WRAM");
                    if (wordCount < 3) continue;
                    addr = Integer.parseInt(word[1], 16);
                    value = Integer.parseInt(word[2], 16);
                    this.out.print(Integer.toHexString(addr));
                    this.out.print(": ");
                    this.out.println(Integer.toHexString(value));
                    this.pic.regBank.writeMemory(addr, value);
                    continue;
                }
                if (word[0].equalsIgnoreCase("MEM")) {
                    this.out.println("MEM");
                    i = 0;
                    while (i < 256) {
                        this.out.print(this.fillString(Integer.toHexString(i), 2));
                        this.out.print(":");
                        j = 0;
                        while (j < 16) {
                            this.out.print(" ");
                            this.out.print(this.fillString(Integer.toHexString(this.pic.eprom.readMemory(i + j)), 3));
                            ++j;
                        }
                        this.out.println();
                        i += 16;
                    }
                } else if (word[0].equalsIgnoreCase("REG")) {
                    this.out.println("REG");
                    i = 0;
                    while (i < 256) {
                        this.out.print(this.fillString(Integer.toHexString(i), 2));
                        this.out.print(":");
                        j = 0;
                        while (j < 16) {
                            this.out.print(" ");
                            this.out.print(this.fillString(Integer.toHexString(this.pic.regBank.readMemory(i + j)), 2));
                            ++j;
                        }
                        this.out.println();
                        i += 16;
                    }
                } else {
                    this.out.println("HELP");
                    this.out.println("Commands:");
                    this.out.println("exit                    - leave");
                    this.out.println("step                    - Do one step, quarter clock");
                    this.out.println("clock                   - One clock, four steps");
                    this.out.println("wrom <addr> <value>     - Write 14-bit-value to program-memory at addr");
                    this.out.println("wram <register> <value> - Write 8-bit-value to Register");
                    this.out.println("rrom <addr>             - Read contents of addr");
                    this.out.println("rram <register>         - Read contents of register");
                    this.out.println("mem                     - Show the first 256 words of the program-memory");
                    this.out.println("reg                     - Show the first 256 registers");
                    this.out.println();
                    continue;
lbl130:
                    // 1 sources

                    this.out.println("STEP");
                    this.pic.clock();
                    this.pic.clock();
                }
            }
        } while (!exit);
        this.out.println("Kommandozeilenverarbeitung verlassen...");
    }

    public static void main(String[] argv) {
        TestPic testPic = new TestPic();
        testPic.workloop();
        testPic.out.println("Und fertig");
    }
}

