/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicBreakPoint;
import hades.models.pic.PicReg;

public class PicWordReg
implements PicReg {
    protected int size = 0;
    private int size_mask = 0;
    private int intValue;
    private int bpValue;
    private PicBreakPoint bp;
    private boolean dirty;
    private static int[] size_masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static int[] bit_masks = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE};

    public PicWordReg(PicBreakPoint newBp) {
        this(newBp, 8);
    }

    public PicWordReg(PicBreakPoint newBp, int bitSize) {
        this.bp = newBp;
        this.size = bitSize;
        this.size_mask = size_masks[this.size];
        if (this.size > 24) {
            this.size = 24;
        }
        this.dirty = true;
        this.intValue = 0;
        this.por();
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeAll() {
        return this.size;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirtyFlag() {
        this.dirty = false;
    }

    public void setDirtyFlag(boolean b) {
        this.dirty = b;
    }

    public void por() {
        this.intValue = 0;
        this.bpValue = -1;
    }

    public void reset() {
        this.intValue = 0;
    }

    public int read() {
        return this.intValue;
    }

    public int readAll() {
        return this.read();
    }

    public void write(int newValue) {
        this.dirty = true;
        if (newValue < 0) {
            System.err.println("-E- Cannot write value<0 into PicWordReg: " + newValue);
            this.intValue = -1;
        } else {
            this.intValue = newValue & this.size_mask;
        }
        this.testBreakPoint();
    }

    public void writeAll(int newValue) {
        this.write(newValue);
    }

    public void setBit(int selectedBit, boolean newValue) {
        this.dirty = true;
        if (selectedBit > this.size) {
            System.err.println("-E- Internal: bit index " + selectedBit + " out of range in PicWordReg.setBit ");
            selectedBit = 0;
        }
        int mask = bit_masks[selectedBit];
        this.intValue = newValue ? (this.intValue |= mask) : (this.intValue | mask) ^ mask;
        this.testBreakPoint();
    }

    public boolean getBit(int selectedBit) {
        if (selectedBit > this.size) {
            System.err.println("-E- Internal: bit index " + selectedBit + " out of range in PicWordReg.setBit ");
            selectedBit = 0;
        }
        return (this.intValue & bit_masks[selectedBit]) > 0;
    }

    public void setBreakPoint(int value) {
        this.bpValue = value;
    }

    public int getBreakPoint() {
        return this.bpValue;
    }

    protected void testBreakPoint() {
        if (this.bpValue >= 0) {
            if (this.read() == this.bpValue) {
                this.bp.report(this.bpValue);
            }
        } else if (this.bpValue == -2) {
            this.bp.report(this.read());
        }
    }
}

