/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicByteReg;
import hades.models.pic.PicExec;
import hades.models.pic.PicWordReg;

public class PicWdt {
    private PicWordReg option;
    private PicByteReg status;
    private PicExec pic;
    private int prescaler = 0;
    private int value = 0;
    private boolean enabled = false;

    public PicWdt(PicWordReg newOption, PicByteReg newStatus, PicExec newPic) {
        this.option = newOption;
        this.status = newStatus;
        this.pic = newPic;
        this.por();
    }

    public void por() {
        this.enabled = false;
        this.reset();
    }

    public void reset() {
        this.prescaler = 0;
        this.value = 0;
        this.status.setBit(3, true);
        this.status.setBit(4, true);
    }

    private int prescalerMax() {
        int max = 0;
        if (this.option.getBit(0)) {
            ++max;
        }
        if (this.option.getBit(1)) {
            max += 2;
        }
        if (this.option.getBit(2)) {
            max += 4;
        }
        max = 1 << max;
        return max;
    }

    public void inc() {
        boolean hasChanged = false;
        if (!this.enabled) {
            return;
        }
        if (this.option.getBit(3)) {
            ++this.prescaler;
            if (this.prescaler >= this.prescalerMax()) {
                this.prescaler = 0;
                ++this.value;
                hasChanged = true;
            }
        } else {
            ++this.value;
            hasChanged = true;
        }
        if (hasChanged && this.value == 256) {
            this.value = 0;
            this.prescaler = 0;
            if (this.pic.sleep.getBit()) {
                this.pic.sleep.setBit(false);
            } else {
                this.pic.reset();
                this.status.setBit(4, false);
            }
        }
    }

    public void setEnabled(boolean newEnabled) {
        this.enabled = newEnabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }
}

