/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicBreakPoint;
import hades.models.pic.PicEpromBreakPoints;
import hades.models.pic.PicReg;
import hades.models.pic.PicWordReg;

public class PicPcReg
extends PicWordReg
implements PicReg {
    public static final int realSize = 13;
    public static final int accessSize = 8;
    private PicWordReg pclath;
    private PicEpromBreakPoints epromBreakPoints;
    private PicBreakPoint bp;

    public PicPcReg(PicBreakPoint newBp, PicWordReg newPclath, PicEpromBreakPoints newEpromBreakPoints) {
        super(newBp, 13);
        this.pclath = newPclath;
        this.epromBreakPoints = newEpromBreakPoints;
        this.bp = newBp;
    }

    public int read() {
        this.size = 8;
        int result = super.read();
        this.size = 13;
        return result;
    }

    public int readAll() {
        return super.read();
    }

    public int readPc() {
        return this.readAll();
    }

    public void writeAll(int newValue) {
        super.write(newValue);
        this.testEpromBreakPoint(newValue);
    }

    public void write(int newValue) {
        newValue = (newValue & 0xFF) + (this.pclath.read() << 8);
        this.writeAll(newValue);
    }

    public void writePc(int newValue) {
        newValue = (newValue & 0x7FF) + ((this.pclath.read() & 0x18) << 8);
        this.writeAll(newValue);
    }

    public void setBit(int selectedBit, boolean newValue) {
        super.setBit(selectedBit, newValue);
        this.testEpromBreakPoint(this.readAll());
    }

    public void testEpromBreakPoint(int newValue) {
        if (this.epromBreakPoints.readMemory(newValue) != 0) {
            this.bp.report(newValue);
        }
    }
}

