/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicBreakPoint;
import hades.models.pic.PicByteReg;
import hades.models.pic.PicNoReg;
import hades.models.pic.PicReg;
import hades.models.pic.PicWordReg;

public class PicIndfReg
implements PicReg {
    private static final int size = 8;
    public PicNoReg byte0;
    public PicWordReg fsr;
    public PicReg[] reg;
    public PicByteReg status;
    private PicBreakPoint bp;
    private int bpValue;

    public PicIndfReg(PicBreakPoint newBp, PicWordReg newFsr, PicByteReg newStatus, PicReg[] newReg) {
        this.byte0 = new PicNoReg(newBp);
        this.fsr = newFsr;
        this.status = newStatus;
        this.reg = newReg;
        this.bp = newBp;
        this.por();
    }

    public int getSize() {
        return 8;
    }

    public int getSizeAll() {
        return 8;
    }

    protected PicReg findSource() {
        int source = this.fsr.read();
        if (this.status.getBit(7)) {
            source |= 0x100;
        }
        PicReg result = source == 0 ? this.byte0 : (source == 256 ? this.byte0 : (source < 0 ? this.byte0 : this.reg[source]));
        return result;
    }

    public void por() {
        this.bpValue = -1;
    }

    public void reset() {
    }

    public int read() {
        return this.findSource().read();
    }

    public int readAll() {
        return this.read();
    }

    public void write(int newValue) {
        this.findSource().write(newValue);
        this.testBreakPoint();
    }

    public void writeAll(int newValue) {
        this.write(newValue);
    }

    public void setBit(int selectedBit, boolean newValue) {
        this.findSource().setBit(selectedBit, newValue);
        this.testBreakPoint();
    }

    public boolean getBit(int selectedBit) {
        return this.findSource().getBit(selectedBit);
    }

    public void setBreakPoint(int value) {
        this.bpValue = value;
    }

    public int getBreakPoint() {
        return this.bpValue;
    }

    protected void testBreakPoint() {
        if (this.bpValue >= 0) {
            if (this.read() == this.bpValue) {
                this.bp.report(this.bpValue);
            }
        } else if (this.bpValue == -2) {
            this.bp.report(this.read());
        }
    }
}

