/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.manager.DesignManager;
import hades.models.memory.MemoryListener;
import hades.models.pic.PicMemory;
import hades.utils.IntelHexFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class PicEprom
implements PicMemory {
    protected int bits;
    protected long maxWord;
    protected int bytes;
    protected long[] eprom;
    protected String filename;
    protected Hashtable mlTable;
    protected String[] labels;

    public PicEprom(int size, int bitsPerWord) {
        if (bitsPerWord > 30) {
            bitsPerWord = 30;
        }
        this.bits = bitsPerWord;
        this.maxWord = 1 << this.bits;
        this.bytes = size;
        this.eprom = new long[size];
        this.labels = new String[size];
        this.filename = new String();
        this.por();
    }

    public PicEprom() {
        this(2048, 16);
    }

    public void por() {
        int i = 0;
        while (i < this.bytes) {
            this.eprom[i] = 0L;
            ++i;
        }
    }

    public void reset() {
    }

    public boolean resize(int i, int j) {
        return false;
    }

    public int getMemorySize() {
        return this.bytes;
    }

    public int getWordWidth() {
        return this.bits;
    }

    public int readMemory(int address) {
        return (int)(this.eprom[address % this.bytes] % this.maxWord);
    }

    public void writeMemory(int address, int word) {
        this.eprom[address % this.bytes] = (long)word % this.maxWord;
    }

    public void setFilename(String name) {
        this.filename = name;
    }

    public void setFilename(String name, String dir) {
        this.filename = dir + name;
        if (this.filename != null) {
            this.filename = this.filename.replace(File.separatorChar, '/');
        }
    }

    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void load(String name, String dir) {
        block14: {
            error = false;
            fis = null;
            try {
                block13: {
                    fis = new FileInputStream(new File(dir, name));
                    if (name.toLowerCase().endsWith(".hex")) {
                        error = this.loadHEX(fis);
                        break block13;
                    }
                    error = this.loadROM(fis);
                }
                var7_5 = null;
                ** if (fis == null) goto lbl-1000
            }
            catch (Throwable var6_12) {
                var7_7 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                throw var6_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (Exception e) {
                    error = true;
                    var7_6 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        if (!error) {
            this.filename = dir + name;
        }
    }

    public boolean load(String resourcename) {
        InputStream is = DesignManager.getDesignManager().getInputStream(this, resourcename);
        if (resourcename.toLowerCase().endsWith(".hex")) {
            return this.loadHEX(is);
        }
        return this.loadROM(is);
    }

    public boolean load(Object parent, String resourcename) {
        InputStream is = DesignManager.getDesignManager().getInputStream(parent, resourcename);
        if (resourcename.toLowerCase().endsWith(".hex")) {
            return this.loadHEX(is);
        }
        return this.loadROM(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    public boolean loadROM(InputStream is) {
        boolean error;
        block14: {
            String line;
            int adr = 0;
            int word = 0;
            error = false;
            this.clearLabels();
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                void var5_7;
                if (var5_7.startsWith("#label")) {
                    this.parseLabelLine((String)var5_7);
                    continue;
                }
                if (var5_7.startsWith("#") || var5_7.startsWith(";")) continue;
                StringTokenizer st = new StringTokenizer((String)var5_7, " \t,");
                while (!error && st.hasMoreTokens()) {
                    try {
                        String token = st.nextToken();
                        if (token.endsWith(":")) {
                            adr = Integer.parseInt(token.substring(0, token.length() - 1), 16);
                            continue;
                        }
                        word = Integer.parseInt(token, 16);
                        this.writeMemory(adr, word);
                        ++adr;
                    }
                    catch (NumberFormatException ex) {
                        error = true;
                    }
                }
            }
            Object var11_11 = null;
            try {
                br.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block14;
            {
                catch (Exception e) {
                    System.out.println("-E- in PicEprom.load(): " + e);
                    error = true;
                    Object var11_12 = null;
                    try {
                        br.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    br.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        return error;
    }

    protected void parseLabelLine(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line, " \t:");
        st.nextToken();
        int addr = Integer.parseInt(st.nextToken(), 16);
        String name = st.nextToken();
        this.addLabel(addr, name);
    }

    public void addLabel(int addr, String name) {
        this.labels[addr] = name;
    }

    public boolean hasLabel(int addr) {
        return this.labels[addr] != null;
    }

    public String getLabel(int addr) {
        if (this.labels[addr] != null) {
            return this.labels[addr];
        }
        return "";
    }

    public void clearLabels() {
        int i = 0;
        while (i < this.labels.length) {
            this.labels[i] = null;
            ++i;
        }
    }

    public boolean loadHEX(InputStream is) {
        IntelHexFile intelHex = new IntelHexFile();
        boolean error = false;
        try {
            this.clearLabels();
            intelHex.parsePic16Bit(is, this.eprom);
        }
        catch (Exception e) {
            e.printStackTrace();
            error = true;
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadLBL(InputStream is) {
        block9: {
            BufferedReader br = null;
            String line = null;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("#label")) continue;
                this.parseLabelLine(line);
            }
            Object var6_4 = null;
            try {
                br.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            break block9;
            {
                catch (Exception e) {
                    System.err.println("-E- loadLBL: parse error: " + e);
                    Object var6_5 = null;
                    try {
                        br.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    br.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String name, String dir) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        int adr = 0;
        int index = 0;
        int max = this.getMemorySize();
        boolean error = false;
        try {
            fw = new FileWriter(new File(dir, name));
            bw = new BufferedWriter(fw);
            adr = 0;
            while (adr < max) {
                String line = Integer.toHexString(adr) + ":";
                index = 0;
                while (index + adr < max && index < 8) {
                    line = line + " " + Integer.toHexString(this.readMemory(adr + index));
                    ++index;
                }
                bw.write(line);
                bw.newLine();
                adr += 8;
            }
        }
        catch (Exception e) {
            System.out.println("-E- in PicEprom.save(): " + e);
            error = true;
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!error) {
            this.filename = dir + name;
        }
    }

    public int getSize() {
        return this.getMemorySize();
    }

    public void setSize(int n_words) throws Exception {
        throw new Exception("Cannot change the PicEprom size!");
    }

    public int getBitsPerWord() {
        return this.getWordWidth();
    }

    public void setBitsPerWord(int n_bits) throws Exception {
        throw new Exception("Cannot change the PicEprom width!");
    }

    public boolean canChangeSize() {
        return false;
    }

    public long getDataAt(int address) {
        return this.readMemory(address);
    }

    public void setDataAt(int address, long value) {
        this.writeMemory(address, (int)value);
    }

    public long[] getDataArray() {
        return this.eprom;
    }

    public void setDataArray(long[] data) {
        this.eprom = data;
    }

    public boolean parse(BufferedReader reader) throws Exception {
        return false;
    }

    public boolean merge(BufferedReader reader) throws Exception {
        return false;
    }

    public boolean save(PrintWriter PW) throws Exception {
        return false;
    }

    public String getResourcename() {
        return this.filename;
    }

    public void setResourcename(String name) {
        this.filename = name;
    }

    public void addMemoryListener(MemoryListener ML) {
        try {
            if (this.mlTable == null) {
                this.mlTable = new Hashtable();
            }
            this.mlTable.put(ML, ML);
        }
        catch (Exception e) {
            System.out.println("-E- failed to add MemoryListener: " + e);
        }
    }

    public void removeMemoryListener(MemoryListener ML) {
        try {
            this.mlTable.remove(ML);
        }
        catch (Exception e) {
            System.out.println("-E- failed to remove MemoryListener: " + e);
        }
    }
}

