/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicByteReg;
import hades.models.pic.PicEprom;
import hades.utils.HexFormat;
import java.io.PrintStream;

public class PicDecode {
    private int decoded;
    private int register;
    private int destination;
    private int bitNumber;
    private int literal;
    private int address;
    private int instruction;
    private int aluOperation;
    private int bitOperation;
    private int jumpOperation;
    private PicByteReg statusReg;
    private PicEprom eprom;
    public static final int ALUACTION = 0;
    public static final int BITACTION = 1;
    public static final int JUMPACTION = 2;
    public static final int LITERALACTION = 3;
    public static final int NOP = 0;
    public static final int RETURN = 0;
    public static final int RETFIE = 0;
    public static final int SLEEP = 0;
    public static final int CLRWDT = 0;
    public static final int MOVWF = 0;
    public static final int CLRW = 1;
    public static final int CLRF = 1;
    public static final int SUBWF = 2;
    public static final int DECF = 3;
    public static final int IORWF = 4;
    public static final int ANDWF = 5;
    public static final int XORWF = 6;
    public static final int ADDWF = 7;
    public static final int MOVF = 8;
    public static final int COMF = 9;
    public static final int INCF = 10;
    public static final int DECFSZ = 11;
    public static final int RRF = 12;
    public static final int RLF = 13;
    public static final int SWAPF = 14;
    public static final int INCFSZ = 15;
    public static final int BCF = 0;
    public static final int BSF = 1;
    public static final int BTFSC = 2;
    public static final int BTFSS = 3;
    public static final int CALL = 0;
    public static final int GOTO = 1;
    public static final int MOVLW = 0;
    public static final int RETLW = 4;
    public static final int IORLW = 8;
    public static final int ANDLW = 9;
    public static final int XORLW = 10;
    public static final int SUBLW = 12;
    public static final int ADDLW = 14;
    public static final String[] bank0Names = new String[]{"INDF", "TMR0", "PCL", "STATUS", "FSR", "PORTA", "PORTB", "-NOREG-", "EEDATA", "EEADR", "PCLATH", "INTCON"};
    public static final String[] bank1Names = new String[]{"INDF", "OPTION", "PCL", "STATUS", "FSR", "TRISA", "TRISB", "-NOREG-", "EECON1", "EECON2", "PCLATH", "INTCON"};

    public PicDecode(PicByteReg _statusReg) {
        this.statusReg = _statusReg;
        this.por();
    }

    public void setEprom(PicEprom _eprom) {
        this.eprom = _eprom;
    }

    public void por() {
        this.reset();
    }

    public void reset() {
        this.decode(0);
    }

    public int splitWord(int word, int lsb, int size) {
        return word >> lsb & (1 << size) - 1;
    }

    public void decode(int word) {
        this.decoded = word;
        this.register = this.splitWord(word, 0, 7);
        this.destination = this.splitWord(word, 7, 1);
        this.bitNumber = this.splitWord(word, 7, 3);
        this.literal = this.splitWord(word, 0, 8);
        this.address = this.splitWord(word, 0, 11);
        this.instruction = this.splitWord(word, 12, 2);
        this.aluOperation = this.splitWord(word, 8, 4);
        this.bitOperation = this.splitWord(word, 10, 2);
        this.jumpOperation = this.splitWord(word, 11, 1);
        if (this.statusReg.getBit(5)) {
            this.register |= 0x80;
        }
        if (this.statusReg.getBit(6)) {
            this.register |= 0x100;
        }
    }

    public int getDecoded() {
        return this.decoded;
    }

    public int getRegister() {
        return this.register;
    }

    public int getDestination() {
        return this.destination;
    }

    public int getBitNumber() {
        return this.bitNumber;
    }

    public int getLiteral() {
        return this.literal;
    }

    public int getAddress() {
        return this.address;
    }

    public int getInstruction() {
        return this.instruction;
    }

    public int getAluOperation() {
        return this.aluOperation;
    }

    public int getBitOperation() {
        return this.bitOperation;
    }

    public int getJumpOperation() {
        return this.jumpOperation;
    }

    public void dump(PrintStream out) {
        out.println("Dumping PicDecode");
        out.print("Last word decoded: ");
        out.println(this.decoded);
        out.print("Register number  : ");
        out.println(this.register);
        out.print("Destination      : ");
        out.println(this.destination);
        out.print("Bit number       : ");
        out.println(this.bitNumber);
        out.print("Literal/Const    : ");
        out.println(this.literal);
        out.print("Absolute Address : ");
        out.println(this.address);
        out.print("Instruction-type : ");
        out.println(this.instruction);
        out.print("ALU-operation    : ");
        out.println(this.aluOperation);
        out.print("Bit-operation    : ");
        out.println(this.bitOperation);
    }

    public String disassemble() {
        switch (this.instruction) {
            case 0: {
                return this.disassembleAluInstruction();
            }
            case 1: {
                return this.disassembleBitInstruction();
            }
            case 2: {
                return this.disassembleJumpInstruction();
            }
            case 3: {
                return this.disassembleLiteralInstruction();
            }
        }
        return "error: unknown opcode value " + this.toHexString(this.decoded, 4);
    }

    public String disassembleAluInstruction() {
        switch (this.aluOperation) {
            case 0: {
                if (this.destination == 1) {
                    return "movwf   " + this.getRegisterName(this.register);
                }
                if (this.register == 99) {
                    return "sleep   ";
                }
                if (this.register == 100) {
                    return "clrwdt  ";
                }
                if (this.register == 8) {
                    return "return  ";
                }
                if (this.register == 9) {
                    return "retfie  ";
                }
                return "nop     ";
            }
            case 1: {
                if (this.destination == 1) {
                    return "clrf    " + this.getRegisterName(this.register);
                }
                return "clrw    ";
            }
            case 2: {
                return "subwf   " + this.formatAluOperands();
            }
            case 3: {
                return "decf    " + this.formatAluOperands();
            }
            case 4: {
                return "iorwf   " + this.formatAluOperands();
            }
            case 5: {
                return "andwf   " + this.formatAluOperands();
            }
            case 6: {
                return "xorwf   " + this.formatAluOperands();
            }
            case 7: {
                return "addwf   " + this.formatAluOperands();
            }
            case 8: {
                return "movf    " + this.formatAluOperands();
            }
            case 9: {
                return "comf    " + this.formatAluOperands();
            }
            case 10: {
                return "incf    " + this.formatAluOperands();
            }
            case 11: {
                return "decfsz  " + this.formatAluOperands();
            }
            case 12: {
                return "rrf     " + this.formatAluOperands();
            }
            case 13: {
                return "rlf     " + this.formatAluOperands();
            }
            case 14: {
                return "swapf   " + this.formatAluOperands();
            }
            case 15: {
                return "incfsz  " + this.formatAluOperands();
            }
        }
        return "UNKNOWN ALU Opcode: " + this.toHexString(this.decoded, 4);
    }

    public String disassembleBitInstruction() {
        switch (this.bitOperation) {
            case 0: {
                return "bcf     " + this.formatBitOperands();
            }
            case 1: {
                return "bsf     " + this.formatBitOperands();
            }
            case 2: {
                return "btfsc   " + this.formatBitOperands();
            }
            case 3: {
                return "btfss   " + this.formatBitOperands();
            }
        }
        return "UNKNOWN BIT Opcode: " + this.toHexString(this.decoded, 4);
    }

    private String getRegisterName(int register) {
        if (register <= 11) {
            return bank0Names[register];
        }
        if (register <= 47) {
            return "reg_" + HexFormat.getHexString(register, 2);
        }
        if (register <= 127) {
            return "-noreg-";
        }
        if (register <= 139) {
            return bank1Names[register - 128];
        }
        if (register <= 175) {
            return "reg_" + HexFormat.getHexString(register, 2);
        }
        return "-noreg-";
    }

    private String formatAluOperands() {
        return this.getRegisterName(this.register) + ", " + (this.destination == 1 ? "F" : "W");
    }

    private String formatBitOperands() {
        return this.getRegisterName(this.register) + ", " + this.bitNumber;
    }

    public String disassembleJumpInstruction() {
        if (this.jumpOperation == 0) {
            return "call    " + this.getJumpTarget();
        }
        return "goto    " + this.getJumpTarget();
    }

    public String getJumpTarget() {
        if (this.eprom != null) {
            String s = this.eprom.getLabel(this.address);
            if (s.length() > 0) {
                return s;
            }
            return this.toHexString(this.address, 3);
        }
        return this.toHexString(this.address, 3);
    }

    public String disassembleLiteralInstruction() {
        switch (this.aluOperation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return "movlw   " + this.formatLiteral(this.literal);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return "retlw   " + this.formatLiteral(this.literal);
            }
            case 8: {
                return "iorlw   " + this.formatLiteral(this.literal);
            }
            case 9: {
                return "andlw   " + this.formatLiteral(this.literal);
            }
            case 10: {
                return "xorlw   " + this.formatLiteral(this.literal);
            }
            case 12: 
            case 13: {
                return "sublw   " + this.formatLiteral(this.literal);
            }
            case 14: 
            case 15: {
                return "addlw   " + this.formatLiteral(this.literal);
            }
        }
        return "UNKNOWN Literal Opcode: " + this.toHexString(this.decoded, 4);
    }

    private String formatLiteral(int literal) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toHexString(literal, 2));
        sb.append(" (");
        sb.append(literal);
        sb.append("d)");
        return sb.toString();
    }

    private String toHexString(int value, int n_chars) {
        return "0x" + HexFormat.getHexString(value, n_chars);
    }
}

