/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.Const1164;
import hades.models.StdLogic1164;
import hades.models.pic.PicExec;
import hades.models.pic.PicPortReg;
import hades.models.pic.ShowPic2;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.utils.IntegerFormatter;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import jfig.utils.ExceptionTracer;

public class Pic16C84
extends SimObject
implements Simulatable,
Serializable,
Wakeable {
    private ShowPic2 show;
    protected PicExec pic;
    private Port portClkin;
    private Port portClkout;
    private Port portMclr;
    private Port[] portA;
    private Port[] portB;
    private StdLogic1164 value_Z;
    private StdLogic1164 value_0;
    private StdLogic1164 value_1;
    Signal signalClkin;
    Signal signalClkout;
    Signal signalMclr;
    Signal[] signalA;
    Signal[] signalB;
    int[] intValueA;
    int[] intValueB;
    protected int n_cycles = 0;
    private int lastClk = 0;
    private boolean lastClkout = false;
    private int lastT0cki = 0;
    private boolean resetActive;
    protected double t_delay = 5.0E-8;
    private double wdtPeriod = 7.0E-5;
    private int[] _portBackupA = new int[5];
    private int[] _portBackupB = new int[8];
    static boolean[] _StdLogic1164ToBooleanTable = new boolean[]{false, false, false, true, false, false, false, true, false};

    public Pic16C84() {
        this.value_Z = Const1164.__Z;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
        this.createPicExec();
        this.show = new ShowPic2(this.pic);
        this.resetActive = false;
        this.ports = new Port[16];
        this.portA = new Port[5];
        this.portB = new Port[8];
        this.ports[0] = new Port(this, "CLKIN", 0, null);
        this.ports[1] = new Port(this, "CLKOUT", 1, null);
        this.ports[2] = new Port(this, "/MCLR", 0, null);
        this.ports[3] = new Port(this, "A0", 2, null);
        this.ports[4] = new Port(this, "A1", 2, null);
        this.ports[5] = new Port(this, "A2", 2, null);
        this.ports[6] = new Port(this, "A3", 2, null);
        this.ports[7] = new Port(this, "A4", 2, null);
        this.ports[8] = new Port(this, "B0", 2, null);
        this.ports[9] = new Port(this, "B1", 2, null);
        this.ports[10] = new Port(this, "B2", 2, null);
        this.ports[11] = new Port(this, "B3", 2, null);
        this.ports[12] = new Port(this, "B4", 2, null);
        this.ports[13] = new Port(this, "B5", 2, null);
        this.ports[14] = new Port(this, "B6", 2, null);
        this.ports[15] = new Port(this, "B7", 2, null);
        this.portClkin = this.ports[0];
        this.portClkout = this.ports[1];
        this.portMclr = this.ports[2];
        int i = 0;
        while (i < 5) {
            this.portA[i] = this.ports[i + 3];
            ++i;
        }
        int i2 = 0;
        while (i2 < 8) {
            this.portB[i2] = this.ports[i2 + 8];
            ++i2;
        }
        this.t_delay = 5.0E-8;
        this.signalA = new Signal[5];
        this.signalB = new Signal[8];
        this.intValueA = new int[5];
        this.intValueB = new int[8];
    }

    public void createPicExec() {
        this.pic = new PicExec();
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.pic.eprom.getFilename()};
        return externals;
    }

    public String toString() {
        return "Pic16C84: " + this.getFullName();
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "n_instructions= " + IntegerFormatter.formatThousandGroups(this.n_cycles) + "\n" + "pc= " + Integer.toHexString(this.pic.regBank.pcl.read()) + " " + "w= " + Integer.toHexString(this.pic.workReg.read()) + "\n";
    }

    public boolean initialize(String s) {
        block7: {
            String filename = new String();
            boolean load = true;
            try {
                StringTokenizer st = new StringTokenizer(s);
                int n_tokens = st.countTokens();
                if (n_tokens == 1) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    load = false;
                } else if (n_tokens == 2) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    filename = NameMangler.decodeUnicodeEscapes(st.nextToken());
                } else {
                    load = false;
                }
                if (load) {
                    this.pic.eprom.setFilename(filename);
                    this.message("-I- Pic16C84: Loading name: " + this.pic.eprom.getFilename());
                    this.message("-I- Pic16C84: Content of adr#0 before reading: " + this.pic.eprom.readMemory(0));
                    this.pic.eprom.load(this, filename);
                    this.message("-I- Pic16C84: Content of adr#0 after reading: " + this.pic.eprom.readMemory(0));
                    this.show.update();
                    break block7;
                }
                this.message("-I- Pic16C84: No default ROM-filename given");
            }
            catch (Exception e) {
                this.message("-E- Pic16C84.initialize(): " + e);
                this.message("-E- offending input is '" + s + "'");
                ExceptionTracer.trace(e);
            }
        }
        return true;
    }

    public void write(PrintWriter ps) {
        this.message("-I- Pic16C84: Writing versionId: " + this.versionId + ", filename: " + this.pic.eprom.getFilename());
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.pic.eprom.getFilename()));
    }

    public void elaborate(Object arg) {
        this.n_cycles = 0;
        this.simulator = this.parent.getSimulator();
        this.resetPortBackupArrays();
        if (this.simulator != null) {
            this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.wdtPeriod, this);
        }
    }

    public void wakeup(Object arg) {
        this.pic.wdt.inc();
        this.pic.eeprom.wakeup();
        this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.wdtPeriod, this);
    }

    private void sample(PicPortReg portReg, int[] intValues) {
        int i = 0;
        while (i < portReg.getSize()) {
            if (portReg.tris.getBit(i) && intValues[i] != 4) {
                portReg.setBitExtern(i, this.convertToBoolean(intValues[i]));
            }
            ++i;
        }
    }

    private void resetPortBackupArrays() {
        int i = 0;
        while (i < this._portBackupA.length) {
            this._portBackupA[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this._portBackupB.length) {
            this._portBackupB[i2] = -1;
            ++i2;
        }
    }

    private void setPortOpen(PicPortReg portReg, Signal[] signal, Port[] port) {
        int[] backup = null;
        if (portReg == this.pic.regBank.porta) {
            backup = this._portBackupA;
        } else if (portReg == this.pic.regBank.portb) {
            backup = this._portBackupB;
        } else {
            System.out.println("Pic.setPortOpen unknown port:" + portReg);
        }
        int i = 0;
        while (i < portReg.getSize()) {
            if (signal[i] != null && portReg.tris.getBit(i)) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal[i], this.simulator.getSimTime() + this.t_delay, this.value_Z, (Object)port[i]));
                backup[i] = 4;
            }
            ++i;
        }
    }

    private void setPort(PicPortReg portReg, Signal[] signal, Port[] port) {
        int[] backup = null;
        if (portReg == this.pic.regBank.porta) {
            backup = this._portBackupA;
        } else if (portReg == this.pic.regBank.portb) {
            backup = this._portBackupB;
        } else {
            System.out.println("Pic.setPort unknown port:" + portReg);
        }
        int i = 0;
        while (i < portReg.getSize()) {
            if (signal[i] != null) {
                if (portReg.tris.getBit(i)) {
                    if (backup[i] != 4) {
                        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal[i], this.simulator.getSimTime() + this.t_delay, this.value_Z, (Object)port[i]));
                        backup[i] = 4;
                    }
                } else {
                    int newValue = 2;
                    if (portReg.getBit(i)) {
                        newValue = 3;
                    }
                    if (backup[i] != newValue) {
                        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal[i], this.simulator.getSimTime() + this.t_delay, newValue == 3 ? this.value_1 : this.value_0, (Object)port[i]));
                        backup[i] = newValue;
                    }
                }
            }
            ++i;
        }
    }

    public void evaluate(Object arg) {
        int i = 0;
        while (i < 5) {
            this.signalA[i] = this.portA[i].getSignal();
            this.intValueA[i] = this.signalA[i] != null ? ((StdLogic1164)this.signalA[i].getValue()).intValue() : 4;
            ++i;
        }
        int i2 = 0;
        while (i2 < 8) {
            this.signalB[i2] = this.portB[i2].getSignal();
            this.intValueB[i2] = this.signalB[i2] != null ? ((StdLogic1164)this.signalB[i2].getValue()).intValue() : 4;
            ++i2;
        }
        if (this.convertToBoolean(this.intValueB[0]) != this.pic.regBank.portb.getBit(0) && this.convertToBoolean(this.intValueB[0]) == this.pic.regBank.option.getBit(6)) {
            this.pic.regBank.extInt.setBit(true);
            this.pic.sleep.setBit(false);
        }
        int i3 = 4;
        while (i3 < 8) {
            if (this.convertToBoolean(this.intValueB[i3]) != this.pic.regBank.portb.getBit(i3)) {
                this.pic.regBank.rbInt.setBit(true);
                this.pic.sleep.setBit(false);
            }
            ++i3;
        }
        this.signalClkin = this.portClkin.getSignal();
        int intValueClkin = this.signalClkin != null ? ((StdLogic1164)this.signalClkin.getValue()).intValue() : 0;
        this.signalMclr = this.portMclr.getSignal();
        int intValueMclr = this.signalMclr != null ? ((StdLogic1164)this.signalMclr.getValue()).intValue() : 0;
        boolean bl = this.resetActive = !this.convertToBoolean(intValueMclr);
        if (this.lastClk != intValueClkin) {
            boolean clkin = this.convertToBoolean(intValueClkin);
            boolean last = this.convertToBoolean(this.lastClk);
            if (clkin && !last) {
                if (this.resetActive) {
                    this.setPortOpen(this.pic.regBank.porta, this.signalA, this.portA);
                    this.setPortOpen(this.pic.regBank.portb, this.signalB, this.portB);
                    this.pic.reset();
                } else {
                    this.pic.advance();
                    if ((this.pic.clocking.getState() == 1 || this.pic.clocking.getState() == 3) && this.pic.regBank.option.getBit(5) && this.convertToBoolean(this.lastT0cki) != this.convertToBoolean(this.intValueA[4])) {
                        if (this.convertToBoolean(this.intValueA[4]) != this.pic.regBank.option.getBit(4)) {
                            this.pic.regBank.tmr0.externInc();
                        }
                        this.lastT0cki = this.intValueA[4];
                    }
                    if (this.pic.clocking.getState() == 2) {
                        this.sample(this.pic.regBank.porta, this.intValueA);
                        this.sample(this.pic.regBank.portb, this.intValueB);
                    }
                    this.pic.clock();
                    if (this.pic.clocking.getState() == 4) {
                        this.setPort(this.pic.regBank.porta, this.signalA, this.portA);
                        this.setPort(this.pic.regBank.portb, this.signalB, this.portB);
                        ++this.n_cycles;
                    }
                    if (this.pic.breakPoint.getIsBreakPoint()) {
                        this.show.getFrame().setVisible(true);
                        this.pic.breakPoint.por();
                        System.out.println("-I- PIC16C84 stopped the simulator, breakpoint at " + this.pic.regBank.pcl.readPc() + " has been reached");
                        this.simulator.pauseSimulation();
                    }
                }
                if (this.show.getSignalFrame().isShowing() && this.show.signals.isEnabled()) {
                    this.show.signals.advance();
                    this.show.signals.repaint();
                }
                if (this.show.getFrame().isShowing()) {
                    this.show.update();
                }
            }
            this.lastClk = intValueClkin;
        }
        if (this.lastClkout != this.pic.clocking.getClkout()) {
            this.lastClkout = !this.lastClkout;
            this.signalClkout = this.portClkout.getSignal();
            if (this.signalClkout != null) {
                StdLogic1164 tmp = this.lastClkout ? this.value_1 : this.value_0;
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)this.signalClkout, this.simulator.getSimTime() + this.t_delay, tmp, (Object)this.portClkout));
            }
        }
    }

    public Component getPropertySheet() {
        return this.show.getFrame();
    }

    public void configure() {
        this.show.getFrame().setVisible(true);
    }

    public boolean convertToBoolean(int value) {
        return _StdLogic1164ToBooleanTable[value];
    }

    public boolean convertToBoolean(StdLogic1164 value) {
        return _StdLogic1164ToBooleanTable[value.intValue()];
    }
}

