/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.PicBreakPoint;
import hades.models.pic.PicByteReg;
import hades.models.pic.PicDecode;
import hades.models.pic.PicEprom;
import hades.models.pic.PicEpromBreakPoints;
import hades.models.pic.PicPcReg;
import hades.models.pic.ShowDisassemblerCanvas;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class MemoryDisassemblerView
extends JPanel {
    protected Font font;
    protected JLabel label;
    protected JScrollBar scrollbar;
    protected PicEprom eprom;
    protected PicEpromBreakPoints breakPoints;
    protected PicPcReg pcreg;
    protected PicDecode decode;
    protected PicByteReg statusReg;
    protected PicBreakPoint breakPoint;
    protected ShowDisassemblerCanvas showDisList;
    protected int factor = 1;

    public MemoryDisassemblerView(String name, PicEprom _eprom, PicEpromBreakPoints _breakPoints, PicPcReg _pcreg, int lines) {
        this.eprom = _eprom;
        this.pcreg = _pcreg;
        this.breakPoints = _breakPoints;
        this.breakPoint = new PicBreakPoint();
        this.statusReg = new PicByteReg(this.breakPoint);
        this.statusReg.write(0);
        this.decode = new PicDecode(this.statusReg);
        this.decode.setEprom(_eprom);
        this.font = new Font("Monospaced", 0, 12);
        this.setFont(this.font);
        this.scrollbar = new JScrollBar(1, 0, lines, 0, this.eprom.getMemorySize());
        this.scrollbar.setUnitIncrement(1);
        this.scrollbar.setBlockIncrement(lines);
        this.showDisList = new ShowDisassemblerCanvas(this, this.breakPoints, this.pcreg, this.scrollbar, this.factor, this.decode, lines);
        this.setLayout(new BorderLayout());
        this.add("Center", this.showDisList);
        this.add("East", this.scrollbar);
        this.scrollbar.addAdjustmentListener(new ScrollListener());
        this.update();
    }

    public void init() {
        this.scrollbar.setValue(0);
    }

    public void smartUpdate() {
        this.showDisList.repaint(50L);
    }

    public void update() {
        this.showDisList.repaint(50L);
    }

    class ScrollListener
    implements AdjustmentListener {
        ScrollListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            MemoryDisassemblerView.this.update();
        }
    }
}

