/*
 * Decompiled with CFR 0.152.
 */
package hades.models.pic;

import hades.models.pic.Advanceable;
import hades.models.pic.PicBitReg;
import hades.models.pic.SignalElement;

class BitSignalElement
extends SignalElement
implements Advanceable {
    private PicBitReg bit;

    public BitSignalElement(int newHistoryCapacity, PicBitReg newBit, String name) {
        super(newHistoryCapacity, name);
        this.bit = newBit;
    }

    public void advance() {
        int next = -1;
        switch (this.bit.read()) {
            case 0: {
                next = -1;
                break;
            }
            case 1: {
                next = -2;
                break;
            }
            case 4: {
                next = -3;
                break;
            }
            case 5: {
                next = -4;
                break;
            }
            case 8: {
                next = -5;
                break;
            }
            case 2: 
            case 6: {
                next = 0;
                break;
            }
            case 3: 
            case 7: {
                next = 1;
                break;
            }
            default: {
                next = -1;
            }
        }
        super.advance(next);
    }

    public boolean isSimpleSignal() {
        return true;
    }
}

