/*
 * Decompiled with CFR 0.152.
 */
package hades.models.microjava;

import hades.gui.PropertySheet;
import hades.models.flipflops.Dff;
import hades.simulator.SimObject;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;

public class DFF
extends Dff {
    int orient = 0;

    public int getOrient() {
        return this.orient;
    }

    public void setOrient(String o) {
        try {
            this.message("-I- setOrient " + this.toString());
            this.orient = Integer.parseInt(o);
            this.symbol.deleteAllMembers();
            Point pos = this.symbol.getPos();
            this.symbol.move(-pos.x, -pos.y);
            this.symbol.initializeFromResource(this);
            this.symbol.setInstanceLabel(this.getName());
            this.symbol.move(pos.x, pos.y);
            this.editor.rebuildObjectList(this.editor.getDesign());
            if (this.symbol.painter != null) {
                this.symbol.painter.paint(this.symbol, 50);
            }
        }
        catch (Exception e) {
            this.message("-I- setOrient " + this.toString() + " exception " + e);
        }
    }

    public String getSymbolResourceName() {
        switch (this.orient) {
            case 1: {
                return "/hades/models/microjava/DFF_1.sym";
            }
            case 2: {
                return "/hades/models/microjava/DFF_2.sym";
            }
            case 3: {
                return "/hades/models/microjava/DFF_3.sym";
            }
        }
        return "/hades/models/microjava/DFF_0.sym";
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "propagation delay [sec]:", "delay", "setup time [sec]:", "setupTime", "hold time [sec]:", "holdTime", "orientation [0, 1, 2, 3]:", "orient"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and gate delay:");
        this.propertySheet.setVisible(true);
    }

    public String toString() {
        return "DFF: " + this.getFullName();
    }

    private double parse(String s) {
        double result;
        try {
            result = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- GenericFlipflop: illegal time value: " + e);
            result = 5.0E-9;
            this.message("-I- resetting to default value, delay = " + result);
        }
        return result;
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int n_tokens = st.countTokens();
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            if (n_tokens >= 2) {
                this.t_pass = this.parse(st.nextToken());
            }
            if (n_tokens >= 4) {
                this.t_setup = this.parse(st.nextToken());
                this.t_hold = this.parse(st.nextToken());
            }
            if (n_tokens >= 5) {
                this.orient = Integer.parseInt(st.nextToken());
            }
            if (this.orient < 0 || this.orient > 3) {
                this.orient = 0;
            }
            if (SimObject.debug) {
                this.message("DFF.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            this.message("-E- GenericFlipflop.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_pass + " " + this.t_setup + " " + this.t_hold + " " + this.orient);
    }
}

