/*
 * Decompiled with CFR 0.152.
 */
package hades.models.meta;

import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.Symbol;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.awt.Frame;
import java.io.PrintWriter;
import java.io.Serializable;
import jfig.commands.FigBasicEditor;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigText;
import jfig.utils.SetupManager;

public class Label
extends SimObject
implements Simulatable,
Serializable {
    private FigText textObject = new FigText();
    Frame frame;
    Component editTextDialog;

    public Label() {
        this.textObject.setText("label");
    }

    public void setText(String s) {
        this.textObject.setText(s);
        if (this.symbol != null) {
            this.symbol.rebuild();
        }
    }

    public String getText() {
        return this.textObject.getText();
    }

    public boolean needsDynamicSymbol() {
        return true;
    }

    public void constructDynamicSymbol() {
        this.symbol = new Symbol();
        this.symbol.setParent(this);
        this.textObject.setTrafo(this.symbol.getTrafo());
        this.symbol.addMember(this.textObject);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()...ignored.");
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()...");
        }
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        String rawText = "";
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            int align = Integer.parseInt(st.nextToken());
            int colorindex = Integer.parseInt(st.nextToken());
            int layer = Integer.parseInt(st.nextToken());
            int fontindex = Integer.parseInt(st.nextToken());
            int fontsize = Integer.parseInt(st.nextToken());
            double angle = Double.valueOf(st.nextToken());
            int fontflags = Integer.parseInt(st.nextToken());
            rawText = st.restOfLine();
            if (rawText == null || rawText.length() <= 1) {
                this.textObject.setText("");
            } else {
                this.textObject.setText(NameMangler.decodeUnicodeEscapes(rawText.substring(1)));
            }
            FigAttribs attribs = this.textObject.getAttributes();
            attribs.textAlign = align;
            attribs.lineColor = ColorCache.getColorCache().get(colorindex);
            attribs.fig_line_color = colorindex;
            attribs.currentLayer = layer;
            attribs.fig_font = fontindex;
            attribs.fontSize = fontsize;
            attribs.fig_angle = angle;
            attribs.fig_font_flags = fontflags;
        }
        catch (Exception e) {
            this.message("-E- Label.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        int versionId = 1001;
        FigAttribs attribs = this.textObject.getAttributes();
        ps.print(" " + versionId + " " + attribs.textAlign + " " + attribs.fig_line_color + " " + attribs.currentLayer + " " + attribs.fig_font + " " + attribs.fontSize + " " + attribs.fig_angle + " " + attribs.fig_font_flags + " " + NameMangler.encodeWithUnicodeEscapes(this.getText()));
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        if (this.editTextDialog == null) {
            this.frame = new Frame("Configure");
            this.editTextDialog = SetupManager.getBoolean("Hades.UseSwingGUI", false) ? new JEditTextDialog(this.textObject, null, this.frame) : new EditTextDialog(this.textObject, null, this.frame);
        }
        this.editTextDialog.setVisible(true);
    }

    public Component getPropertySheet() {
        return this.editTextDialog;
    }

    public SimObject copy() {
        Label clone = (Label)super.copy();
        clone.setText(this.getText());
        clone.textObject.setAttributes(this.textObject.getAttributes().getClone());
        return clone;
    }

    public String toString() {
        return "Label: " + this.getFullName();
    }

    class JEditTextDialog
    extends jfig.gui.JEditTextDialog {
        public JEditTextDialog(FigText textObject, FigBasicEditor editor, Frame parent) {
            super(parent, editor);
            super.setTextObject(textObject);
        }

        public void doApply() {
            this.dbg("-#- Label.EditTextDialog.doApply");
            super.doApply();
            Label.this.symbol.rebuild();
            Label.this.getEditor().doRedraw();
        }

        public void doOK() {
            this.dbg("-#- Label.EditTextDialog.doOK");
            super.doOK();
            Label.this.symbol.rebuild();
            Label.this.getEditor().doRedraw();
        }
    }

    class EditTextDialog
    extends jfig.gui.EditTextDialog {
        public EditTextDialog(FigText textObject, FigBasicEditor editor, Frame parent) {
            super(textObject, editor, parent);
        }

        public void doApply() {
            this.dbg("-#- EditTextDialog.doApply");
            super.doApply();
            Label.this.symbol.rebuild();
            Label.this.getEditor().doRedraw();
        }

        public void doOK() {
            this.dbg("-#- EditTextDialog.doOK");
            super.doOK();
            Label.this.symbol.rebuild();
            Label.this.getEditor().doRedraw();
        }
    }
}

