/*
 * Decompiled with CFR 0.152.
 */
package hades.models.meta;

import hades.gui.Command;
import hades.gui.PropertySheet;
import hades.simulator.SimObject;
import hades.symbols.FigWrapper;
import hades.symbols.Symbol;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;

public class ActionButton
extends SimObject {
    private FigWrapper figWrapper;
    private String resourceName = "/hades/models/meta/ActionButton.sym";
    private String commandName = "hades.gui.OpenDesignCommand";
    private Point commandPos = new Point(0, 0);
    private String commandParamString = "/examples/greta.hds";

    public ActionButton() {
        this.symbol = null;
    }

    public String getSymbolResourceName() {
        return this.resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandParamString() {
        return this.commandParamString;
    }

    public int getCommandXpos() {
        return this.commandPos.x;
    }

    public int getCommandYpos() {
        return this.commandPos.y;
    }

    public void setResourceName(String s) {
        this.resourceName = s;
    }

    public void setCommandName(String s) {
        this.commandName = s;
    }

    public void setCommandParamString(String s) {
        this.commandParamString = s;
    }

    public void setCommandXpos(String s) {
        try {
            this.commandPos = new Point(Integer.parseInt(s), this.commandPos.y);
        }
        catch (Exception e) {
            this.commandPos = new Point(0, 0);
        }
    }

    public void setCommandYpos(String s) {
        try {
            this.commandPos = new Point(this.commandPos.x, Integer.parseInt(s));
        }
        catch (Exception e) {
            this.commandPos = new Point(0, 0);
        }
    }

    public boolean initialize(String s) {
        if (SimObject.debug) {
            this.message("-I- ActionButton.initialize( '" + s + "'...");
        }
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.resourceName = st.nextToken();
            this.symbol = new Symbol();
            this.figWrapper = new FigWrapper();
            this.figWrapper.initialize(" 0 0 " + this.resourceName);
            this.symbol.addMember(this.figWrapper);
            if (this.visible) {
                this.setSymbol(this.symbol);
            }
            this.commandName = st.nextToken();
            this.commandPos = new Point();
            this.commandPos.x = Integer.parseInt(st.nextToken());
            this.commandPos.y = Integer.parseInt(st.nextToken());
            this.commandParamString = st.nextToken();
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize: " + e);
            e.printStackTrace();
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.resourceName + " " + this.commandName + " " + this.commandPos.x + " " + this.commandPos.y + " " + this.commandParamString);
    }

    public void configure() {
        String[] fields = new String[]{"instance name:", "name", "symbol resource:", "resourceName", "action command class name:", "commandName", "action command x pos:", "commandXpos", "action command y pos:", "commandYpos", "command parameter string:", "commandParamString"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify the action command:");
        this.propertySheet.setVisible(true);
    }

    public void mousePressed(MouseEvent evt) {
        try {
            Class<?> cl = Class.forName(this.commandName);
            Class[] argtypes = new Class[]{Class.forName("hades.gui.Editor")};
            Constructor<?> ck = cl.getConstructor(argtypes);
            Object[] args = new Object[]{this.getEditor()};
            Command cmd = (Command)ck.newInstance(args);
            cmd.initialize(this.commandParamString);
            cmd.setPosition(this.commandPos, this.commandPos);
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".mousePressed: " + e);
            e.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message("-I- " + this.toString() + ".elaborate()...ignored.");
        }
    }

    public String toString() {
        return "HADES ActionButton:" + this.commandName + ":" + this.commandParamString;
    }
}

