/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.gui.CloseableFrame;
import hades.gui.MemoryHexEditorField;
import hades.models.mcore.DcoreRAM;
import hades.models.mcs4.i4001Decoder;
import hades.models.memory.Memory;
import hades.utils.HexFormat;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jfig.utils.SetupManager;

public class i4001MemoryCanvas
extends MemoryHexEditorField {
    private int width;
    private int height;
    private boolean useDisassembledFormat = false;
    private i4001Decoder decoder;
    private Memory memory;
    private Memory breakpoints;
    private int n_words;
    private Font textFont;
    private int n_columns;
    private int n_rows;
    private int n_chars_per_addr;
    private int n_chars_per_word;
    private int wordsPerInstruction;
    private int border_width;
    private int border_height;
    private int char_width;
    private int char_height;
    private int baseline;
    private int x0_bp;
    private int x0_addr;
    private int x0_data;
    private int x0_label;
    private int x0_decoded;
    private int y0;

    public i4001MemoryCanvas(Memory _memory, i4001Decoder _decoder, int _words_per_row) {
        super(_memory, _words_per_row);
        this.memory = _memory;
        this.decoder = _decoder;
        this.wordsPerInstruction = 1;
    }

    public void setTextFont(Font f) {
        super.setTextFont(f);
        this.textFont = f;
        FontMetrics fm = this.getFontMetrics(this.textFont);
        this.char_width = fm.charWidth('M');
        this.char_height = fm.getMaxDescent() + fm.getMaxAscent();
        this.baseline = fm.getMaxAscent();
        this.border_width = 5;
        this.border_height = 5;
        this.width = this.n_columns * this.char_width + 2 * this.border_width;
        this.height = this.n_rows * this.char_height + 2 * this.border_height;
        this.y0 = this.border_height + this.baseline;
        this.x0_bp = this.border_width;
        this.x0_addr = this.x0_bp + 2 * this.char_width;
        this.x0_data = this.x0_addr + (this.n_chars_per_addr + 2) * this.char_width;
        this.x0_label = this.x0_data + 7 * this.char_width;
        this.x0_decoded = this.x0_label + 12 * this.char_width;
    }

    public void selectHexFormat() {
        this.useDisassembledFormat = false;
        this.revalidate();
        this.repaint();
    }

    public void selectDisassembledFormat() {
        this.useDisassembledFormat = true;
        this.revalidate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (!this.useDisassembledFormat) {
            super.paint(graphics);
        } else {
            this.checkInit();
            this.paintBackgroundAndBorder(graphics);
            this.paintDisassembled(graphics);
            this.paintCursor(graphics);
        }
    }

    public Dimension getPreferredSize() {
        if (!this.useDisassembledFormat) {
            return super.getPreferredSize();
        }
        this.checkInit();
        return new Dimension(this.width, this.height);
    }

    private void paintDisassembled(Graphics g) {
        g.setColor(Color.black);
        g.setFont(this.textFont);
        Rectangle clip = g.getClipBounds();
        int addr_offset = this.memory.getAddrOffset();
        int startRow = (clip.y - this.border_height) / this.char_height;
        int startAddr = startRow * this.wordsPerInstruction;
        int y_max = clip.y + clip.height + this.char_height;
        int y = this.y0 + startRow * this.char_height;
        int addr = startAddr;
        while (addr < this.n_words) {
            long raw = this.memory.getDataAt(addr);
            int data = 0;
            data = raw == -1L ? -1 : (int)raw & 0xFFFF;
            this.decoder.decode(data, this.wordsPerInstruction * addr + addr_offset);
            String bpString = this.breakpoints != null && this.breakpoints.getDataAt(addr) != 0L ? "# " : "  ";
            String addrString = this.toHexString(addr + addr_offset, this.n_chars_per_addr);
            String dataString = this.toHexString(data, this.n_chars_per_word);
            String labelString = this.getLabel(this.wordsPerInstruction * addr);
            String decodedString = this.decoder.disassemble();
            if (addr == this.getReadHightlightAddress()) {
                g.setColor(this.getReadHightlightColor());
            } else if (addr == this.getWriteHightlightAddress()) {
                g.setColor(this.getWriteHightlightColor());
            } else {
                g.setColor(this.getAddrColor());
            }
            g.drawString(bpString, this.x0_bp, y);
            g.drawString(addrString, this.x0_addr, y);
            if (addr == this.getReadHightlightAddress()) {
                g.setColor(this.getReadHightlightColor());
            } else if (addr == this.getWriteHightlightAddress()) {
                g.setColor(this.getWriteHightlightColor());
            } else {
                g.setColor(this.getDataColor());
            }
            g.drawString(dataString, this.x0_data, y);
            g.drawString(labelString, this.x0_label, y);
            g.drawString(decodedString, this.x0_decoded, y);
            if ((y += this.char_height) > y_max) break;
            addr += this.wordsPerInstruction;
        }
    }

    private String getLabel(int addr) {
        String label = this.decoder.getLabel(addr);
        if (label == null) {
            return this.fill("", ' ', 10);
        }
        return this.fill(label, ' ', 10);
    }

    private String fill(String s, char c, int min_width) {
        StringBuffer sb = new StringBuffer();
        if (s.length() == min_width) {
            return s;
        }
        if (s.length() > min_width) {
            return s.substring(0, min_width);
        }
        sb.append(s);
        while (sb.length() < min_width) {
            sb.append(c);
        }
        return sb.toString();
    }

    private String toHexString(int value, int n_chars) {
        return HexFormat.getHexStringOrX(value, n_chars);
    }

    public static void main(String[] argv) {
        MemoryHexEditorField.msg("-I- i4001MemoryCanvas selftest...");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        CloseableFrame f = new CloseableFrame();
        f.setTitle("i4001MemoryCanvas selftest");
        f.setSize(100, 100);
        f.setVisible(true);
        DcoreRAM memory = new DcoreRAM();
        memory.initialize("1001 1024 16 32768");
        memory.initializeWithRandomValues();
        i4001Decoder decoder = new i4001Decoder();
        int[] addr = new int[]{0, 7, 20, 21, 33, 38, 1023};
        int i = 0;
        while (i < addr.length) {
            decoder.addLabel(addr[i], "L_" + addr[i]);
            ++i;
        }
        i4001MemoryCanvas ddc = new i4001MemoryCanvas(memory, decoder, 8);
        ddc.setReadHighlightAddress(20);
        ddc.setWriteHighlightAddress(7);
        Button toggleButton = new Button("toggle hex/dis");
        i4001MemoryCanvas i4001MemoryCanvas2 = ddc;
        i4001MemoryCanvas2.getClass();
        toggleButton.addActionListener(i4001MemoryCanvas2.new SelftestAdapter(ddc));
        f.add("Center", ddc);
        f.add("South", toggleButton);
        f.pack();
    }

    public void init() {
        this.n_words = this.memory.getSize();
        this.n_rows = this.n_words / this.wordsPerInstruction;
        this.n_columns = 60;
        this.n_chars_per_addr = this.getAddrFieldWidth(this.n_words);
        this.n_chars_per_word = this.getDataFieldWidth(this.memory.getBitsPerWord());
        super.init();
    }

    public int getColumns() {
        if (this.useDisassembledFormat) {
            return this.n_columns;
        }
        return super.getColumns();
    }

    public int getRows() {
        if (this.useDisassembledFormat) {
            return this.n_rows;
        }
        return super.getRows();
    }

    public int getAddrAreaEnd() {
        if (this.useDisassembledFormat) {
            return this.n_chars_per_addr + 2;
        }
        return super.getAddrAreaEnd();
    }

    public int getDataAreaBegin() {
        if (this.useDisassembledFormat) {
            return this.n_chars_per_addr + 4;
        }
        return super.getDataAreaBegin();
    }

    public int getWordsPerRow() {
        if (this.useDisassembledFormat) {
            return this.wordsPerInstruction;
        }
        return super.getWordsPerRow();
    }

    public int getWordsPerInstruction() {
        return 1;
    }

    class SelftestAdapter
    implements ActionListener {
        boolean state = false;
        i4001MemoryCanvas ddc;

        public SelftestAdapter(i4001MemoryCanvas ddc) {
            this.ddc = ddc;
        }

        public void actionPerformed(ActionEvent e) {
            boolean bl = this.state = !this.state;
            if (this.state) {
                this.ddc.selectHexFormat();
            } else {
                this.ddc.selectDisassembledFormat();
            }
        }
    }
}

