/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.gui.MemoryEditorFrame;
import hades.gui.MemoryHexEditorField;
import hades.models.mcs4.i4001Decoder;
import hades.models.mcs4.i4001MemoryCanvas;
import hades.models.memory.Memory;
import hades.models.rtlib.memory.GenericMemory;
import java.awt.event.ActionEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class i4001EditorFrame
extends MemoryEditorFrame {
    private i4001Decoder decoder = null;
    private i4001MemoryCanvas component;
    private Memory romChip;
    private int wordsPerRow;
    private JMenu formatMenu;
    private JMenuItem formatHexMI;
    private JMenuItem formatDisassembleMI;
    private JMenuItem clearLabelsMI;

    public i4001EditorFrame(Memory _memory, int n_visibleRows, int n_words_per_row, String title) {
        super(_memory, n_visibleRows, n_words_per_row, title);
        this.romChip = _memory;
        this.wordsPerRow = n_words_per_row;
        this.decoder = (i4001Decoder)((GenericMemory)this.romChip).getInstructionDecoder();
    }

    protected MemoryHexEditorField getDisplayComponent() {
        if (this.component == null) {
            this.component = new i4001MemoryCanvas(this.romChip, this.decoder, this.wordsPerRow);
        }
        return this.component;
    }

    protected void buildMenus() {
        super.buildMenus();
        this.formatMenu = new JMenu("Format");
        this.formatHexMI = new JMenuItem("hex");
        this.formatDisassembleMI = new JMenuItem("disassemble");
        this.clearLabelsMI = new JMenuItem("clear labels");
        this.formatMenu.add(this.formatHexMI);
        this.formatMenu.add(this.formatDisassembleMI);
        this.formatMenu.add(this.clearLabelsMI);
        this.getEditMenu().addSeparator();
        this.getEditMenu().add(this.formatMenu);
    }

    protected void buildCallbacks() {
        super.buildCallbacks();
        this.formatHexMI.addActionListener(this);
        this.formatDisassembleMI.addActionListener(this);
        this.clearLabelsMI.addActionListener(this);
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.formatHexMI) {
            this.selectHexFormat();
        } else if (source == this.formatDisassembleMI) {
            this.selectDisassembledFormat();
        } else if (source == this.clearLabelsMI) {
            this.clearDecoderLabels();
        } else {
            super.actionPerformed(evt);
        }
    }

    public void selectHexFormat() {
        ((i4001MemoryCanvas)this.getDisplayComponent()).selectHexFormat();
    }

    public void selectDisassembledFormat() {
        ((i4001MemoryCanvas)this.getDisplayComponent()).selectDisassembledFormat();
    }

    public void clearDecoderLabels() {
        System.out.println("-# clearDecoderLabels...");
        if (this.getDecoder() != null) {
            this.getDecoder().clearAllLabels();
        }
    }

    public i4001Decoder getDecoder() {
        return this.decoder;
    }
}

