/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.models.mcore.DcoreDecoder;
import hades.models.mcs4.Instruction;
import hades.models.mcs4.InstructionSet;
import hades.models.rtlib.memory.GenericMemory;
import hades.utils.HexFormat;
import java.util.ArrayList;

class i4001Decoder
extends DcoreDecoder {
    private int address;
    private int opa;
    private Instruction inst;
    private InstructionSet instructions = InstructionSet.getInstance();
    private long doubleWord;
    private ArrayList doubleWords = new ArrayList();
    private GenericMemory romChip;

    i4001Decoder() {
    }

    void setMemory(GenericMemory memory) {
        this.romChip = memory;
    }

    public void decode(int instruction, int address) {
        this.address = address;
        super.decode(instruction, address);
    }

    public void decode(int instruction) {
        if (!this.doubleWords.contains(new Integer(this.address))) {
            Integer oprCode = new Integer((instruction & 0xF0) >> 4);
            Integer opaCode = new Integer(instruction & 0xF);
            this.opa = opaCode;
            this.inst = this.instructions.findInstruction(oprCode, opaCode);
            Integer nextAddress = new Integer(this.address + 1);
            if (this.inst.is2word()) {
                try {
                    this.doubleWord = this.address < 255 ? this.romChip.getDataAt(nextAddress) : 0L;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    this.doubleWord = 0L;
                }
                if (!this.doubleWords.contains(nextAddress)) {
                    this.doubleWords.add(nextAddress);
                }
            } else if (this.doubleWords.contains(nextAddress)) {
                this.doubleWords.remove(nextAddress);
            }
        }
    }

    public String disassemble() {
        StringBuffer text = new StringBuffer();
        if (!this.doubleWords.contains(new Integer(this.address))) {
            text.append(this.inst.getName());
            int argType = this.inst.getArgType();
            if (argType != 0) {
                text.append(" ");
                if (argType == 1 || argType == 6 || argType == 7 || argType == 2) {
                    text.append("R");
                }
                if (argType == 7 || argType == 2) {
                    this.opa >>= 1;
                    text.append(this.opa * 2);
                    text.append(" R");
                    text.append(this.opa * 2 + 1);
                } else {
                    text.append(this.opa);
                }
                if (this.inst.is2word() && this.inst != InstructionSet.FIN) {
                    if (argType != 4) {
                        text.append(", ");
                    }
                    if (argType == 7) {
                        text.append(this.doubleWord & 0xFL);
                        text.append(" ");
                        text.append(this.doubleWord >> 4);
                    } else {
                        text.append(HexFormat.getHexStringOrX(this.doubleWord, 2));
                    }
                }
            }
            text.append("\n");
        } else {
            text.append("------^");
        }
        return new String(text);
    }
}

