/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.mcs4.ContentObject;
import hades.models.mcs4.ContentSender;
import hades.models.mcs4.ValueChangeListener;
import hades.utils.HexFormat;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ContentPanel
extends JPanel
implements ValueChangeListener {
    private JPanel labelsPanel = null;
    private JPanel objectsPanel = null;
    private HashMap fields = new HashMap();

    ContentPanel(ContentSender sender) {
        sender.addValueChangeListener(this);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(new JLabel(sender.getTitle()));
        List children = sender.getContentSender();
        int i = 0;
        while (i < children.size()) {
            Object child = children.get(i);
            if (child instanceof ContentSender) {
                this.add(new ContentPanel((ContentSender)child));
            }
            if (child instanceof ContentObject) {
                if (this.objectsPanel == null) {
                    this.labelsPanel = new JPanel(new GridLayout(children.size(), 1));
                    this.objectsPanel = new JPanel(new GridLayout(children.size(), 1));
                }
                ContentObject content = (ContentObject)child;
                this.labelsPanel.add(new JLabel(content.getName() + ":"));
                JLabel valueLabel = new JLabel();
                valueLabel.setForeground(Color.darkGray);
                if (content.getObject() != null) {
                    this.updateValue(valueLabel, content.getObject());
                }
                this.fields.put(content.getObject(), valueLabel);
                this.objectsPanel.add(valueLabel);
            }
            ++i;
        }
        if (this.objectsPanel != null) {
            this.add(this.labelsPanel);
            this.add(this.objectsPanel);
        }
    }

    private void updateValue(JLabel field, Object valueCarrier) {
        if (valueCarrier instanceof StdLogicVector) {
            StdLogicVector data = (StdLogicVector)valueCarrier;
            field.setText(HexFormat.getHexStringOrX(data.getValue(), data.getWidth() / 4));
        } else if (valueCarrier instanceof StdLogic1164) {
            StdLogic1164 data = (StdLogic1164)valueCarrier;
            field.setText(data.getValueString());
        } else {
            field.setText(valueCarrier.toString());
        }
    }

    public void valueChanged(Object valueCarrier) {
        JLabel valueLabel = (JLabel)this.fields.get(valueCarrier);
        this.updateValue(valueLabel, valueCarrier);
    }
}

