/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.models.StdLogicVector;
import hades.models.mcs4.i4004InternalReg;

class AddressStack {
    private i4004InternalReg programCounter = new i4004InternalReg("Program Counter", 12);
    private i4004InternalReg stack1 = new i4004InternalReg("Level 1", 12);
    private i4004InternalReg stack2 = new i4004InternalReg("Level 2", 12);
    private i4004InternalReg stack3 = new i4004InternalReg("Level 3", 12);
    private StdLogicVector temp = new StdLogicVector(12);

    AddressStack() {
    }

    void elaborate() {
        this.programCounter.initializeWithZeroes();
        this.stack1.setValue(0L);
        this.stack2.setValue(0L);
        this.stack3.setValue(0L);
    }

    void pushAddress() {
        this.stack3.setValue(this.stack2.getValue());
        this.stack2.setValue(this.stack1.getValue());
        this.stack1.setValue(this.programCounter.getValue());
    }

    void pullAddress() {
        this.programCounter.setValue(this.stack1.getValue());
        this.stack1.setValue(this.stack2.getValue());
        this.stack2.setValue(this.stack3.getValue());
    }

    void incrementPC() {
        this.temp.setValue(this.programCounter.getValue());
        this.programCounter.setValue(this.temp.incr().getValue());
    }

    void setLowAddress(long address) {
        this.putAddressInPC(0, address);
    }

    void setMiddleAddress(long address) {
        this.putAddressInPC(4, address);
    }

    void setHighAddress(long address) {
        this.putAddressInPC(8, address);
    }

    StdLogicVector getLowAddress() {
        this.temp.setValue(this.programCounter.getValue());
        return this.temp.subset(3, 0);
    }

    StdLogicVector getMiddleAddress() {
        this.temp.setValue(this.programCounter.getValue());
        return this.temp.subset(7, 4);
    }

    StdLogicVector getHighAddress() {
        this.temp.setValue(this.programCounter.getValue());
        return this.temp.subset(11, 8);
    }

    private void putAddressInPC(int start, long address) {
        this.temp.setValue(this.programCounter.getValue());
        StdLogicVector adr = new StdLogicVector(4, address);
        int i = 0;
        while (i <= 3) {
            this.temp.setBitAt(i + start, adr.getBitAt(i));
            ++i;
        }
        this.programCounter.setValue(this.temp.getValue());
    }

    i4004InternalReg getProgramCounter() {
        return this.programCounter;
    }

    i4004InternalReg getLevel1() {
        return this.stack1;
    }

    i4004InternalReg getLevel2() {
        return this.stack2;
    }

    i4004InternalReg getLevel3() {
        return this.stack3;
    }
}

