/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcs4;

import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.mcs4.InternalState;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;

public abstract class AbstractIntel4000
extends SimObject {
    protected static final double T_OH = 5.0E-8;
    private PortStdLogic1164 port_D0 = new PortStdLogic1164(this, "D0", 2, null);
    private PortStdLogic1164 port_D1 = new PortStdLogic1164(this, "D1", 2, null);
    private PortStdLogic1164 port_D2 = new PortStdLogic1164(this, "D2", 2, null);
    private PortStdLogic1164 port_D3 = new PortStdLogic1164(this, "D3", 2, null);
    private PortStdLogic1164 port_Vss = new PortStdLogic1164(this, "Vss", 0, null);
    private PortStdLogic1164 port_phi1 = new PortStdLogic1164(this, "phi1", 0, null);
    private PortStdLogic1164 port_phi2 = new PortStdLogic1164(this, "phi2", 0, null);
    private PortStdLogic1164 port_Vdd = new PortStdLogic1164(this, "Vdd", 0, null);
    private PortStdLogic1164 port_RESET = new PortStdLogic1164(this, "RESET", 0, null);
    private InternalState cycleClock;
    private double stateChangeTime;
    private boolean hasOutputData = false;
    private boolean dataSent = false;

    public AbstractIntel4000() {
        this.ports = new Port[16];
        this.ports[0] = this.port_D0;
        this.ports[1] = this.port_D1;
        this.ports[2] = this.port_D2;
        this.ports[3] = this.port_D3;
        this.ports[4] = this.port_Vss;
        this.ports[5] = this.port_phi1;
        this.ports[6] = this.port_phi2;
        this.ports[12] = this.port_Vdd;
        this.ports[15] = this.port_RESET;
    }

    protected abstract StdLogicVector getOutputData();

    public void elaborate(Object arg) {
        this.simulator = this.getSimulator();
        this.setState(InternalState.X3);
        this.hasOutputData = false;
        this.dataSent = false;
        this.releaseBus();
    }

    public void evaluate(Object arg) {
        SignalStdLogic1164 phi2 = (SignalStdLogic1164)this.port_phi2.getSignal();
        StdLogic1164 phi1Value = this.port_phi1.getValueOrU();
        StdLogic1164 phi2Value = this.port_phi2.getValueOrU();
        if (this.port_Vdd.getSignal() == null || this.port_Vss.getSignal() == null || !this.port_Vdd.getValueOrU().is_0L() || !this.port_Vss.getValueOrU().is_1H()) {
            this.message("-E- Voltage Supply is incorrect!");
        }
        if (phi1Value.is_UXZ() || phi2Value.is_UXZ()) {
            return;
        }
        if (phi2.hasRisingEdge() && !this.stateChanged()) {
            if (this.hasOutputData()) {
                this.releaseBus();
            }
            this.changeState();
            this.stateChanged(this.cycleClock);
        } else if (phi2.hasFallingEdge()) {
            this.receiveData(this.cycleClock);
        }
        if (this.port_D0.getValueOrU().is_Z() && this.hasOutputData() && !this.dataSent) {
            this.sendData(this.getOutputData());
        }
    }

    protected void stateChanged(InternalState state) {
    }

    protected void receiveData(InternalState state) {
    }

    protected void setState(InternalState state) {
        this.cycleClock = state;
    }

    protected void releaseBus() {
        int i = 0;
        while (i < 4) {
            if (this.ports[i].getSignal() != null) {
                this.createEvent((PortStdLogic1164)this.ports[i], new StdLogic1164('Z'), 5.0E-8);
            }
            ++i;
        }
        this.dataSent = false;
    }

    protected boolean hasOutputData() {
        return this.hasOutputData;
    }

    protected void setHasOutputData(boolean hasOutputData) {
        this.hasOutputData = hasOutputData;
    }

    protected void sendData(StdLogicVector data) {
        if (data.getWidth() > 4 && SimObject.debug) {
            this.message("-W Length of output data vector > 4, using lower 4 bits");
        }
        int i = 0;
        while (i < 4) {
            if (this.ports[i].getSignal() != null) {
                StdLogic1164 tmp = new StdLogic1164('0');
                if (data.getWidth() > i) {
                    tmp = data.getBitAt(i);
                }
                this.createEvent((PortStdLogic1164)this.ports[i], tmp);
            }
            ++i;
        }
        this.dataSent = true;
    }

    protected StdLogicVector receiveData() {
        StdLogicVector data = new StdLogicVector(4);
        int i = 0;
        while (i < 4) {
            data.setBitAt(i, ((PortStdLogic1164)this.ports[i]).getValueOrU());
            ++i;
        }
        return data;
    }

    protected StdLogic1164 getReset() {
        return this.port_RESET.getValueOrU();
    }

    protected void createEvent(PortStdLogic1164 port, StdLogic1164 value) {
        this.createEvent(port, value, 0.0);
    }

    protected void createEvent(PortStdLogic1164 port, StdLogic1164 value, double delay) {
        this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)port.getSignal(), this.simulator.getSimTime() + delay, value, (Object)port));
    }

    protected void changeState() {
        this.stateChangeTime = this.simulator.getSimTime();
        this.cycleClock = this.cycleClock.getNextState();
    }

    protected boolean stateChanged() {
        return this.stateChangeTime == this.simulator.getSimTime();
    }
}

