/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcore;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.mcore.DcoreRAM;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class PIP2ROM
extends DcoreRAM {
    public PIP2ROM() {
        this.constructPorts();
        this.addr_offset = 0;
    }

    @Override
    protected void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.getAddressBusWidth() + 1);
        this.port_DOUT = new PortStdLogicVector((SimObject)this, "DOUT", 1, null, this.n_bits);
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.port_nOE = new PortStdLogic1164(this, "nOE", 0, null);
        this.ports = new Port[4];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_DOUT;
        this.ports[2] = this.port_nCS;
        this.ports[3] = this.port_nOE;
    }

    @Override
    public void evaluate(Object arg) {
        if (debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_DOUT = null;
        StdLogic1164 value_nCS = this.port_nCS.getValueOrU();
        StdLogic1164 value_nOE = this.port_nOE.getValueOrU();
        int addr = 0;
        int _addr = 0;
        long data = 0L;
        if (!value_nCS.is_01()) {
            vector_DOUT = this.vector_XXX.copy();
        } else if (value_nCS.is_1()) {
            vector_DOUT = this.vector_ZZZ.copy();
        } else if (!value_nOE.is_01()) {
            vector_DOUT = this.vector_XXX.copy();
        } else if (value_nOE.is_1()) {
            vector_DOUT = this.vector_ZZZ.copy();
        } else if (value_nOE.is_0()) {
            if (vector_A.has_UXZ()) {
                this.message("-W- " + this.toString() + ": address undefined during read cycle");
                vector_DOUT = this.vector_XXX.copy();
            } else {
                _addr = (int)vector_A.getValue();
                if ((_addr & 1) != 0) {
                    this.message("-W- " + this.toString() + ": misaligned read access at addr: " + _addr);
                }
                addr = _addr >>> 1;
                data = this.getDataAt(addr);
                vector_DOUT = new StdLogicVector(this.n_bits, data);
                this.notifyReadListeners(addr, data);
            }
        }
        Signal signal_DOUT = this.port_DOUT.getSignal();
        if (signal_DOUT != null) {
            this.simulator.scheduleEvent(new SimEvent(signal_DOUT, time, vector_DOUT, this.port_DOUT));
        }
    }

    @Override
    public void configure() {
        super.configure();
        this.editor.setDefaultExtension(".rom");
    }
}

