/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcore;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.mcore.DcoreDisassemblerEditorFrame;
import hades.models.rtlib.memory.GenericMemory;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import jfig.utils.ExceptionTracer;

public class DcoreRAM
extends GenericMemory {
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_DIN;
    protected PortStdLogicVector port_DOUT;
    protected PortStdLogic1164 port_nWE;
    protected PortStdLogic1164 port_nCS;
    protected PortStdLogic1164 port_nOE;
    protected int addr_offset = 0;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    public static final double t_setup = 6.0E-9;
    public static final double t_min_we_cycle = 6.0E-9;
    protected DcoreDisassemblerEditorFrame editor;

    public DcoreRAM() {
        this.constructPorts();
        this.addr_offset = 0;
    }

    @Override
    protected void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.getAddressBusWidth() + 1);
        this.port_DIN = new PortStdLogicVector((SimObject)this, "DIN", 0, null, this.n_bits);
        this.port_DOUT = new PortStdLogicVector((SimObject)this, "DOUT", 1, null, this.n_bits);
        this.port_nWE = new PortStdLogic1164(this, "nWE", 0, null);
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.port_nOE = new PortStdLogic1164(this, "nOE", 0, null);
        this.ports = new Port[6];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_DIN;
        this.ports[2] = this.port_DOUT;
        this.ports[3] = this.port_nWE;
        this.ports[4] = this.port_nCS;
        this.ports[5] = this.port_nOE;
    }

    @Override
    public int getAddrOffset() {
        return this.addr_offset;
    }

    @Override
    public boolean canChangeSize() {
        return !this.isConnected();
    }

    @Override
    public void setSize(int n) {
        this.resize(n, this.getBitsPerWord());
    }

    @Override
    public void setBitsPerWord(int n) {
        this.resize(this.getSize(), n);
    }

    @Override
    public boolean resize(int n, int n2) {
        this.n_words = n;
        this.n_bits = n2;
        this.data = new long[n];
        this.initializeWithZeroes();
        this.constructStandardValues();
        this.constructPorts();
        return true;
    }

    @Override
    public void elaborate(Object object) {
        if (debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null && this.port_DOUT.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DOUT.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DOUT));
        }
    }

    @Override
    public void evaluate(Object object) {
        if (debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double d = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector stdLogicVector = this.port_A.getVectorOrUUU();
        StdLogicVector stdLogicVector2 = this.port_DIN.getVectorOrUUU();
        StdLogicVector stdLogicVector3 = null;
        StdLogic1164 stdLogic1164 = this.port_nCS.getValueOrU();
        StdLogic1164 stdLogic11642 = this.port_nOE.getValueOrU();
        StdLogic1164 stdLogic11643 = this.port_nWE.getValueOrU();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        if (!stdLogic1164.is_01()) {
            if (!stdLogic11643.is_1()) {
                this.warning("-W- DcoreRAM: nCS and nWE undefined: data might be lost!");
                this.checkInvalidateMemory();
            }
            stdLogicVector3 = this.vector_XXX.copy();
        } else if (stdLogic1164.is_1()) {
            stdLogicVector3 = this.vector_ZZZ.copy();
        } else if (!stdLogic11643.is_01()) {
            this.warning("-W- DcoreRAM: nCS active but nWE undefined: data might be lost!");
            this.checkInvalidateMemory();
            stdLogicVector3 = stdLogic11642.is_1() ? this.vector_ZZZ.copy() : this.vector_XXX.copy();
        } else if (stdLogic11643.is_1()) {
            if (stdLogic11642.is_1()) {
                stdLogicVector3 = this.vector_ZZZ.copy();
            } else if (stdLogic11642.is_0()) {
                if (stdLogicVector.has_UXZ()) {
                    this.warning("-W- DcoreRAM: address undefined during read cycle!");
                    stdLogicVector3 = this.vector_XXX.copy();
                } else {
                    n2 = (int)stdLogicVector.getValue();
                    if ((n2 & 1) != 0) {
                        this.warning("-W- DcoreRAM: misaligned read access at addr: " + n2);
                    }
                    n = n2 >>> 1;
                    l = this.getDataAt(n);
                    stdLogicVector3 = new StdLogicVector(this.n_bits, l);
                    this.notifyReadListeners(n, l);
                }
            } else {
                this.warning("-W- DcoreRAM: nOE undefined during read cycle");
                stdLogicVector3 = this.vector_XXX.copy();
            }
        } else if (stdLogic11643.is_0()) {
            if (stdLogicVector.has_UXZ()) {
                this.warning("-W- DcoreRAM: address undefined during write cycle:  complete memory contents might be lost!");
                this.checkInvalidateMemory();
            } else if (stdLogicVector2.has_UXZ()) {
                this.warning("-W- DcoreRAM: data undefined during write cycle:  addressed data is invalidated!");
                n2 = (int)stdLogicVector.getValue();
                if ((n2 & 1) != 0) {
                    this.warning("-W- DcoreRAM: misaligned write access at addr:" + n2);
                }
                n = n2 >>> 1;
                l = (int)this.vector_XXX.getValue();
                l2 = this.getDataAt(n);
                this.setDataAt(n, l);
            } else {
                n2 = (int)stdLogicVector.getValue();
                if ((n2 & 1) != 0) {
                    this.warning("-W- DcoreRAM: misaligned write access at addr:" + n2);
                }
                n = n2 >>> 1;
                l = (int)stdLogicVector2.getValue();
                l2 = this.getDataAt(n);
                this.setDataAt(n, l);
                this.notifyWriteListeners(n, l2, l);
            }
            stdLogicVector3 = this.vector_ZZZ.copy();
        }
        Signal signal = this.port_DOUT.getSignal();
        if (signal != null) {
            this.simulator.scheduleEvent(new SimEvent(signal, d, stdLogicVector3, this.port_DOUT));
        }
    }

    @Override
    public boolean parse(BufferedReader bufferedReader) throws Exception {
        if (bufferedReader == null) {
            return false;
        }
        LineNumberReader lineNumberReader = new LineNumberReader(bufferedReader);
        String string = null;
        StringTokenizer stringTokenizer = null;
        int n = 0;
        int n2 = 0;
        if (debug) {
            this.message("-I- RAM: parsing... ");
        }
        while ((string = lineNumberReader.readLine()) != null) {
            try {
                if (string.startsWith("#label")) {
                    this.parseLabelLine(string);
                    continue;
                }
                if (string.startsWith("#") || string.startsWith(";") || (stringTokenizer = new StringTokenizer(string, " \t:")).countTokens() < 2) continue;
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                n2 = Integer.parseInt(string2, 16);
                if ((n2 & 1) != 0) {
                    if (n < 20) {
                        this.message("-E- " + this.toString() + ".parse: ignoring misaligned address " + n2 + " on line " + lineNumberReader.getLineNumber());
                    }
                    if (n == 20) {
                        this.message("-E- " + this.toString() + " that makes 20 errors");
                        this.message("-E- further messages suppressed");
                    }
                    ++n;
                }
                if (string3.indexOf(88) >= 0) {
                    this.setDataAt(n2 >>> 1, -1L);
                    continue;
                }
                this.setDataAt(n2 >>> 1, Long.parseLong(string3, 16));
            }
            catch (Exception exception) {
                this.message("-E- " + this.toString() + ".parse: " + exception.getMessage());
                this.message("-E- on line " + lineNumberReader.getLineNumber() + ": " + string);
            }
        }
        lineNumberReader.close();
        return true;
    }

    @Override
    protected void parseLabelLine(String string) throws Exception {
        if (this.editor == null) {
            this.createEditor();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t:");
        stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken(), 16);
        String string2 = stringTokenizer.nextToken();
        this.editor.getDecoder().addLabel(n, string2);
    }

    @Override
    public boolean save(PrintWriter printWriter) {
        int n = this.getHexDigitsPerWord();
        if (this.editor == null) {
            this.createEditor();
        }
        for (int i = 0; i < this.data.length; ++i) {
            String string = this.getHexString(i << 1, 4);
            String string2 = this.getHexString(this.data[i], n);
            printWriter.println(string + ":" + string2);
            String string3 = this.editor.getDecoder().getLabel(i << 1);
            if (string3 == null) continue;
            printWriter.println("#label " + string + " " + string3);
        }
        printWriter.flush();
        return false;
    }

    @Override
    public void write(PrintWriter printWriter) {
        String string = " " + this.versionId + " " + this.n_words + " " + this.n_bits + " " + this.addr_offset;
        if (this.resourcename != null) {
            string = string + " " + NameMangler.encodeWithUnicodeEscapes(this.resourcename);
        }
        printWriter.print(string);
    }

    @Override
    public boolean initialize(String string) {
        this.resourcename = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            if (n == 4) {
                this.versionId = Integer.parseInt(stringTokenizer.nextToken());
                this.n_words = Integer.parseInt(stringTokenizer.nextToken());
                this.n_bits = Integer.parseInt(stringTokenizer.nextToken());
                this.addr_offset = Integer.parseInt(stringTokenizer.nextToken());
                this.resourcename = null;
            } else if (n == 5) {
                this.versionId = Integer.parseInt(stringTokenizer.nextToken());
                this.n_words = Integer.parseInt(stringTokenizer.nextToken());
                this.n_bits = Integer.parseInt(stringTokenizer.nextToken());
                this.addr_offset = Integer.parseInt(stringTokenizer.nextToken());
                this.resourcename = NameMangler.decodeUnicodeEscapes(stringTokenizer.nextToken());
            }
            this.createMemory();
            this.constructStandardValues();
            this.constructPorts();
            if (this.resourcename != null) {
                this.parseRAM(this.resourcename);
            } else {
                this.initializeWithX();
            }
        }
        catch (Exception exception) {
            this.message("-E- " + this.toString() + ".initialize(): " + exception);
            this.message("-E- offending input is '" + string + "'");
            ExceptionTracer.trace(exception);
        }
        return true;
    }

    protected void createEditor() {
        int n = (int)Math.ceil((double)this.getSize() / 8.0);
        if (n > 40) {
            n = 40;
        }
        this.editor = new DcoreDisassemblerEditorFrame(this, n, 8, "Edit " + this.getName() + " " + this.getClass().getName());
        this.addMemoryListener(this.editor);
        this.setInstructionDecoder(this.editor.getDecoder());
    }

    @Override
    public void configure() {
        if (this.editor == null) {
            this.createEditor();
        }
        this.editor.pack();
        this.editor.setVisible(true);
        this.editor.setDefaultExtension(".ram");
    }

    @Override
    public Component getPropertySheet() {
        if (this.editor != null) {
            return this.editor;
        }
        return null;
    }
}

