/*
 * Decompiled with CFR 0.152.
 */
package hades.models.mcore;

import hades.gui.CloseableFrame;
import hades.gui.MemoryHexEditorField;
import hades.models.mcore.DcoreDecoder;
import hades.models.mcore.DcoreRAM;
import hades.models.memory.Memory;
import hades.utils.HexFormat;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import jfig.utils.SetupManager;

public class DcoreDisassemblerOrHexCanvas
extends MemoryHexEditorField {
    private int width;
    private int height;
    private boolean useDisassembledFormat = false;
    private DcoreDecoder decoder;
    private Memory memory;
    private Memory breakpoints;
    private int n_words;
    private Font textFont;
    private int n_columns;
    private int n_rows;
    private int n_chars_per_addr;
    private int n_chars_per_word;
    private int wordsPerInstruction;
    private int border_width;
    private int border_height;
    private int char_width;
    private int char_height;
    private int baseline;
    private int x0_bp;
    private int x0_addr;
    private int x0_data;
    private int x0_label;
    private int x0_decoded;
    private int y0;

    public DcoreDisassemblerOrHexCanvas(Memory memory, DcoreDecoder dcoreDecoder, int n) {
        super(memory, n);
        this.memory = memory;
        this.decoder = dcoreDecoder;
        this.wordsPerInstruction = 1;
    }

    @Override
    public void setTextFont(Font font) {
        super.setTextFont(font);
        this.textFont = font;
        FontMetrics fontMetrics = this.getFontMetrics(this.textFont);
        this.char_width = fontMetrics.charWidth('M');
        this.char_height = fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent();
        this.baseline = fontMetrics.getMaxAscent();
        this.border_width = 5;
        this.border_height = 5;
        this.width = this.n_columns * this.char_width + 2 * this.border_width;
        this.height = this.n_rows * this.char_height + 2 * this.border_height;
        this.y0 = this.border_height + this.baseline;
        this.x0_bp = this.border_width;
        this.x0_addr = this.x0_bp + 2 * this.char_width;
        this.x0_data = this.x0_addr + (this.n_chars_per_addr + 2) * this.char_width;
        this.x0_label = this.x0_data + 7 * this.char_width;
        this.x0_decoded = this.x0_label + 12 * this.char_width;
    }

    public void selectHexFormat() {
        this.useDisassembledFormat = false;
        this.moveCursorTo(this.getDataAreaBegin(), 0);
        this.revalidate();
        this.repaint();
    }

    public void selectDisassembledFormat() {
        this.useDisassembledFormat = true;
        this.moveCursorTo(this.getDataAreaBegin(), 0);
        this.revalidate();
        this.repaint();
    }

    @Override
    public int getAddrFromCursorPosition() {
        if (this.useDisassembledFormat) {
            return this.cursor_y * this.getWordsPerRow();
        }
        return super.getAddrFromCursorPosition();
    }

    public void paintBackAndBorder(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = this.getPreferredSize().width;
        int n6 = this.getPreferredSize().height;
        if (this.isEnabled()) {
            graphics.setColor(this.backgroundColor);
        } else {
            graphics.setColor(Color.lightGray);
        }
        int n7 = this.x0_data - 6;
        int n8 = this.x0_label - 20;
        Color color = new Color(236, 234, 214);
        graphics.setColor(color);
        graphics.fillRect(n, n2, n7 - n, n4);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n7 + 1, n2, n8 - n7, n4);
        graphics.setColor(color);
        graphics.fillRect(n8 + 1, n2, n3 - n8, n4);
        if (n + n3 > n5) {
            System.out.println("EXTRA");
            graphics.setColor(super.getBackground());
            graphics.fillRect(n5, n2, n + n3 - n5 + 1, n4);
        }
        if (n2 + n4 > n6) {
            graphics.setColor(super.getBackground());
            graphics.fillRect(n, n6, n + n3, n2 + n4 - n6 + 1);
        }
        graphics.setColor(Color.gray);
        graphics.draw3DRect(0, 0, n5 - 1, n6 - 1, false);
        graphics.draw3DRect(1, 1, n5 - 3, n6 - 3, false);
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.useDisassembledFormat) {
            super.paint(graphics);
        } else {
            this.checkInit();
            this.paintBackAndBorder(graphics);
            this.paintDisassembled(graphics);
            this.paintCursor(graphics);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.useDisassembledFormat) {
            return super.getPreferredSize();
        }
        this.checkInit();
        return new Dimension(this.width, this.height);
    }

    private void paintDisassembled(Graphics graphics) {
        int n;
        graphics.setColor(Color.black);
        graphics.setFont(this.textFont);
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = this.memory.getAddrOffset();
        int n3 = n = (rectangle.y - this.border_height) / this.char_height;
        int n4 = rectangle.y + rectangle.height + this.char_height;
        int n5 = this.y0 + n * this.char_height;
        for (int i = n3; i < this.n_words; ++i) {
            long l = this.memory.getDataAt(i);
            int n6 = 0;
            n6 = l == -1L ? -1 : (int)l & 0xFFFF;
            int n7 = n2 + 2 * i;
            this.decoder.decode(n6, n7);
            String string = this.breakpoints != null && this.breakpoints.getDataAt(i) != 0L ? "# " : "  ";
            String string2 = this.toHexString(n7, this.n_chars_per_addr);
            String string3 = this.toHexString(n6, this.n_chars_per_word);
            String string4 = this.getLabel(n7);
            String string5 = this.decoder.disassemble();
            if (i == this.getReadHightlightAddress()) {
                graphics.setColor(this.getReadHightlightColor());
            } else if (i == this.getWriteHightlightAddress()) {
                graphics.setColor(this.getWriteHightlightColor());
            } else {
                graphics.setColor(this.getAddrColor());
            }
            graphics.drawString(string, this.x0_bp, n5);
            graphics.drawString(string2, this.x0_addr, n5);
            if (i == this.getReadHightlightAddress()) {
                graphics.setColor(this.getReadHightlightColor());
            } else if (i == this.getWriteHightlightAddress()) {
                graphics.setColor(this.getWriteHightlightColor());
            } else {
                graphics.setColor(this.getDataColor());
            }
            graphics.drawString(string3, this.x0_data, n5);
            graphics.drawString(string4, this.x0_label, n5);
            graphics.drawString(string5, this.x0_decoded, n5);
            if ((n5 += this.char_height) > n4) break;
        }
    }

    private String getLabel(int n) {
        String string = this.decoder.getLabel(n);
        if (string == null) {
            return this.fill("", ' ', 10);
        }
        return this.fill(string, ' ', 10);
    }

    private String fill(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == n) {
            return string;
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        stringBuffer.append(string);
        while (stringBuffer.length() < n) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    @Override
    public void paintAllAddresses(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.height;
        if (n > this.x0_data) {
            return;
        }
        int n4 = (n2 - this.border_height) / (this.char_height * this.n_words_per_row) * this.n_words_per_row;
        int n5 = n4 + n3 / this.char_height + this.char_height;
        int n6 = n4 * this.n_words_per_row;
        int n7 = n5 * this.n_words_per_row;
        int n8 = this.border_width;
        int n9 = this.y0_addr + n4 * this.char_height;
        int n10 = this.memoryObject.getAddrOffset();
        graphics.setColor(this.addrColor);
        graphics.setFont(this.textFont);
        for (int i = n6; i <= n7 && i < this.n_words; i += this.n_words_per_row) {
            String string = HexFormat.getHexStringOrX(n10 + 2 * i, this.n_chars_per_addr);
            graphics.drawString(string, n8, n9);
            n9 += this.char_height;
        }
    }

    private String toHexString(int n, int n2) {
        return HexFormat.getHexStringOrX(n, n2);
    }

    public static void main(String[] stringArray) {
        DcoreDisassemblerOrHexCanvas.msg("-I- DcoreDisassemblerOrHexCanvas selftest...");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        CloseableFrame closeableFrame = new CloseableFrame();
        closeableFrame.setTitle("DcoreDisassemblerOrHexCanvas selftest");
        closeableFrame.setSize(100, 100);
        closeableFrame.setVisible(true);
        DcoreRAM dcoreRAM = new DcoreRAM();
        dcoreRAM.initialize("1001 1024 16 32768");
        dcoreRAM.initializeWithRandomValues();
        DcoreDecoder dcoreDecoder = new DcoreDecoder();
        int[] nArray = new int[]{0, 7, 20, 21, 33, 38, 1023};
        for (int i = 0; i < nArray.length; ++i) {
            dcoreDecoder.addLabel(nArray[i], "L_" + nArray[i]);
        }
        DcoreDisassemblerOrHexCanvas dcoreDisassemblerOrHexCanvas = new DcoreDisassemblerOrHexCanvas(dcoreRAM, dcoreDecoder, 8);
        dcoreDisassemblerOrHexCanvas.setReadHighlightAddress(20);
        dcoreDisassemblerOrHexCanvas.setWriteHighlightAddress(7);
        Button button = new Button("toggle hex/dis");
        DcoreDisassemblerOrHexCanvas dcoreDisassemblerOrHexCanvas2 = dcoreDisassemblerOrHexCanvas;
        dcoreDisassemblerOrHexCanvas2.getClass();
        button.addActionListener(dcoreDisassemblerOrHexCanvas2.new SelftestAdapter(dcoreDisassemblerOrHexCanvas));
        closeableFrame.add("Center", dcoreDisassemblerOrHexCanvas);
        closeableFrame.add("South", button);
        closeableFrame.pack();
    }

    @Override
    public void init() {
        this.n_words = this.memory.getSize();
        this.n_rows = this.n_words / this.wordsPerInstruction;
        this.n_columns = 60;
        this.n_chars_per_addr = this.getAddrFieldWidth(this.n_words);
        this.n_chars_per_word = this.getDataFieldWidth(this.memory.getBitsPerWord());
        super.init();
        this.moveCursorTo(this.getDataAreaBegin(), 0);
    }

    @Override
    public int getColumns() {
        if (this.useDisassembledFormat) {
            return this.n_columns;
        }
        return super.getColumns();
    }

    @Override
    public int getRows() {
        if (this.useDisassembledFormat) {
            return this.n_rows;
        }
        return super.getRows();
    }

    @Override
    public int getAddrAreaEnd() {
        if (this.useDisassembledFormat) {
            return this.n_chars_per_addr + 2;
        }
        return super.getAddrAreaEnd();
    }

    @Override
    public boolean isCursorInDataArea() {
        if (this.useDisassembledFormat) {
            return this.cursor_x >= this.getDataAreaBegin() && this.cursor_x < this.getDataAreaBegin() + 4;
        }
        return this.cursor_x >= this.getDataAreaBegin();
    }

    @Override
    public int getDataAreaBegin() {
        if (this.useDisassembledFormat) {
            return this.n_chars_per_addr + 4;
        }
        return super.getDataAreaBegin();
    }

    @Override
    public int getWordsPerRow() {
        if (this.useDisassembledFormat) {
            return this.wordsPerInstruction;
        }
        return super.getWordsPerRow();
    }

    @Override
    public int getWordsPerInstruction() {
        return 1;
    }

    @Override
    public void moveCursorRight() {
        if (this.useDisassembledFormat) {
            if (this.cursor_x < this.getDataAreaBegin() + 3) {
                ++this.cursor_x;
            }
        } else {
            super.moveCursorRight();
        }
    }

    @Override
    public void moveCursorLeft() {
        if (this.useDisassembledFormat) {
            if (this.cursor_x > this.getDataAreaBegin()) {
                --this.cursor_x;
            }
            this.setShiftMode(false);
        } else {
            super.moveCursorLeft();
        }
    }

    @Override
    public void setCursorFromMousePosition(MouseEvent mouseEvent) {
        this.cursor_x = (mouseEvent.getX() - this.border_width) / this.char_width;
        this.cursor_y = (mouseEvent.getY() - this.border_height) / this.char_height;
        if (!this.useDisassembledFormat) {
            this.cursor_x = this.clip(this.cursor_x, 0, this.getColumns() - 1);
        } else if (this.cursor_x < this.getDataAreaBegin()) {
            this.cursor_x = this.getDataAreaBegin();
        } else if (this.cursor_x > this.getDataAreaBegin() + 3) {
            this.cursor_x = this.getDataAreaBegin() + 3;
        }
        this.cursor_y = this.clip(this.cursor_y, 0, this.getRows() - 1);
        this.shiftMode = false;
    }

    class SelftestAdapter
    implements ActionListener {
        boolean state = false;
        DcoreDisassemblerOrHexCanvas ddc;

        public SelftestAdapter(DcoreDisassemblerOrHexCanvas dcoreDisassemblerOrHexCanvas2) {
            this.ddc = dcoreDisassemblerOrHexCanvas2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.state = !this.state;
            if (this.state) {
                this.ddc.selectHexFormat();
            } else {
                this.ddc.selectDisassembledFormat();
            }
        }
    }
}

