/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.symbols.ColoredPolyline;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;

public class SevenSegmentMultiplexed
extends SimObject
implements Simulatable,
Wakeable {
    public static final int LED_UX = 0;
    public static final int LED_OFF = 2;
    public static final int LED_ON = 3;
    public static final int CATHODE_UX = 0;
    public static final int CATHODE_ACTIVE = 2;
    public static final int CATHODE_INACTIVE = 3;
    protected ColoredPolyline[] segments;
    protected FigCompound display;
    protected Color dark_gray;
    protected Color medium_gray;
    protected StdLogic1164 value_U;
    protected int[] portValues;
    protected int[] ledValues;
    protected double[] t_on;
    protected double[] t_off;
    protected double[] t_ux;
    protected double[] t_lastUpdate;
    protected double[] t_total;
    protected double t_delta;
    protected double t_sample = 0.02;
    protected double t_threshold = 2.0E-4;
    protected int n_cycles = 0;
    protected boolean hasNewEvents = false;
    Color COLOR_UX;
    Color COLOR_ON;
    Color COLOR_OFF;
    static char[] names = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'P'};

    public SevenSegmentMultiplexed() {
        this.ports = new Port[9];
        this.ports[0] = new PortStdLogic1164(this, "A", 0, null);
        this.ports[1] = new PortStdLogic1164(this, "B", 0, null);
        this.ports[2] = new PortStdLogic1164(this, "C", 0, null);
        this.ports[3] = new PortStdLogic1164(this, "D", 0, null);
        this.ports[4] = new PortStdLogic1164(this, "E", 0, null);
        this.ports[5] = new PortStdLogic1164(this, "F", 0, null);
        this.ports[6] = new PortStdLogic1164(this, "G", 0, null);
        this.ports[7] = new PortStdLogic1164(this, "P", 0, null);
        this.ports[8] = new PortStdLogic1164(this, "K", 0, null);
        this.value_U = Const1164.__U;
        this.ledValues = new int[8];
        this.portValues = new int[9];
        this.t_on = new double[8];
        this.t_off = new double[8];
        this.t_ux = new double[8];
        this.t_lastUpdate = new double[8];
        this.t_total = new double[8];
        this.COLOR_UX = Color.cyan;
        this.COLOR_ON = Color.red;
        this.COLOR_OFF = new Color(120, 120, 120);
    }

    public void setSymbol(Symbol s) {
        if (!(s instanceof DynSymbol)) {
            throw new Error("-E- not a DynSymbol: " + s);
        }
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    public boolean needsDynamicSymbol() {
        return true;
    }

    public void constructDynamicSymbol() {
        this.symbol = new DynSymbol();
        this.symbol.initializeFromResource(this);
    }

    private void initDisplay() {
        FigAttribs attr;
        this.display = new FigCompound();
        this.display.setTrafo(this.symbol.getTrafo());
        this.dark_gray = new Color(100, 100, 100);
        this.medium_gray = new Color(120, 120, 120);
        this.segments = new ColoredPolyline[8];
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i] = new ColoredPolyline();
            ++i;
        }
        this.segments[0].initialize("2 900 750 2100 750");
        this.segments[1].initialize("2 2100 900 1950 1800");
        this.segments[2].initialize("2 1950 2100 1800 3000");
        this.segments[3].initialize("2 600 3150 1800 3150");
        this.segments[4].initialize("2 750 2100 600 3000");
        this.segments[5].initialize("2 900 900 750 1800");
        this.segments[6].initialize("2 750 1950 1950 1950");
        this.segments[7].initialize("2 2100 3150 2200 3250");
        int i2 = 0;
        while (i2 < this.segments.length) {
            attr = this.segments[i2].getAttributes();
            attr.fillColor = Color.red;
            attr.lineColor = Color.red;
            attr.fig_line_color = 2;
            attr.fig_fill_color = 2;
            attr.fillStyle = 2;
            attr.currentLayer = 5;
            attr.lineWidth = 150.0;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.segments.length) {
            this.display.fastAddMember(this.segments[i3]);
            ++i3;
        }
        Rectangle r = new Rectangle();
        r.initialize("150 450 2550 3600");
        attr = r.getAttributes();
        attr.fillStyle = 2;
        attr.lineColor = Color.black;
        attr.fig_line_color = 0;
        attr.fillColor = this.dark_gray;
        attr.fig_fill_color = 0;
        attr.fig_area_fill = 20;
        attr.currentLayer = 50;
        r.setAttributes(attr);
        this.display.fastAddMember(r);
        this.display.update_bbox();
        Symbol symbol = this.getSymbol();
        this.display.setObjectPainter(symbol.painter);
        symbol.addMember(this.display);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.n_cycles = 0;
        this.initPortValues();
        this.initStatistics();
        this.repaint();
        this.hasNewEvents = false;
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            if (SimObject.debug) {
                this.message(this.toString() + "elaborate(): SIMULATOR IS NULL!");
            }
        } else {
            this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.t_sample, this);
        }
    }

    public void wakeup(Object arg) {
        ++this.n_cycles;
        this.evalStatistics();
        this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.t_sample, this);
    }

    public void evaluate(Object arg) {
        this.hasNewEvents = true;
        try {
            SimEvent event = (SimEvent)arg;
            PortStdLogic1164 target = (PortStdLogic1164)event.getTargetPort();
            double time = event.getTime();
            int i = 0;
            while (i < 8) {
                if (target == this.ports[i]) {
                    this.updateSegmentStatistics(time, i);
                    this.portValues[i] = target.getValueOrU().intValue();
                    break;
                }
                ++i;
            }
            if (target == this.ports[8]) {
                this.updateAllSegmentStatistics(time);
                switch (target.getValueOrU().intValue()) {
                    case 0: 
                    case 1: 
                    case 8: {
                        this.portValues[8] = 0;
                        break;
                    }
                    case 2: {
                        this.portValues[8] = 2;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.portValues[8] = 3;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("-E- in SevenSegmentMuxd.evaluate: " + e);
            e.printStackTrace();
        }
    }

    void repaint() {
        if (this.display.painter != null) {
            this.display.painter.paint(this.display, 60);
            this.getSymbol().painter.paint(this.getSymbol(), 60);
        } else if (SimObject.debug) {
            System.out.println("-E- repaint: painter is null! ");
        }
    }

    void updateSegmentStatistics(double time, int i) {
        int value = this.portValues[i];
        int cathode = this.portValues[8];
        double t_delta = time - this.t_lastUpdate[i];
        if (cathode == 0) {
            int n = i;
            this.t_ux[n] = this.t_ux[n] + t_delta;
        } else if (cathode == 3) {
            int n = i;
            this.t_off[n] = this.t_off[n] + t_delta;
        } else {
            switch (value) {
                case 0: 
                case 1: 
                case 5: 
                case 8: {
                    int n = i;
                    this.t_ux[n] = this.t_ux[n] + t_delta;
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    int n = i;
                    this.t_off[n] = this.t_off[n] + t_delta;
                    break;
                }
                case 3: 
                case 7: {
                    int n = i;
                    this.t_on[n] = this.t_on[n] + t_delta;
                }
            }
        }
        this.t_lastUpdate[i] = time;
        int n = i;
        this.t_total[n] = this.t_total[n] + t_delta;
    }

    void updateAllSegmentStatistics(double time) {
        int cathode = this.portValues[8];
        int i = 0;
        while (i < 8) {
            double t_delta = time - this.t_lastUpdate[i];
            if (cathode == 0) {
                int n = i;
                this.t_ux[n] = this.t_ux[n] + t_delta;
            } else if (cathode == 3) {
                int n = i;
                this.t_off[n] = this.t_off[n] + t_delta;
            } else {
                switch (this.portValues[i]) {
                    case 0: 
                    case 1: 
                    case 5: 
                    case 8: {
                        int n = i;
                        this.t_ux[n] = this.t_ux[n] + t_delta;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        int n = i;
                        this.t_off[n] = this.t_off[n] + t_delta;
                        break;
                    }
                    case 3: 
                    case 7: {
                        int n = i;
                        this.t_on[n] = this.t_on[n] + t_delta;
                    }
                }
            }
            this.t_lastUpdate[i] = time;
            int n = i++;
            this.t_total[n] = this.t_total[n] + t_delta;
        }
    }

    void initPortValues() {
        int i = 0;
        while (i < this.portValues.length) {
            this.portValues[i] = 0;
            ++i;
        }
    }

    void initLedValues() {
        int i = 0;
        while (i < this.ledValues.length) {
            this.ledValues[i] = 0;
            ++i;
        }
    }

    void initStatistics() {
        int i = 0;
        while (i < 8) {
            this.t_ux[i] = 0.0;
            this.t_on[i] = 0.0;
            this.t_off[i] = 0.0;
            this.t_total[i] = 0.0;
            this.t_lastUpdate[i] = 0.0;
            ++i;
        }
    }

    void resetStatistics() {
        int i = 0;
        while (i < 8) {
            this.t_ux[i] = 0.0;
            this.t_on[i] = 0.0;
            this.t_off[i] = 0.0;
            this.t_total[i] = 0.0;
            ++i;
        }
    }

    void evalStatistics() {
        double time = this.simulator.getSimTime();
        int i = 0;
        while (i < 8) {
            if (this.t_total[i] < this.t_sample) {
                this.updateSegmentStatistics(time, i);
            }
            ++i;
        }
        boolean hasChanges = false;
        int i2 = 0;
        while (i2 < this.ledValues.length) {
            if (this.t_ux[i2] > this.t_threshold) {
                hasChanges |= this.ledValues[i2] != 0;
                this.ledValues[i2] = 0;
            } else if (this.t_on[i2] > this.t_threshold) {
                hasChanges |= this.ledValues[i2] != 3;
                this.ledValues[i2] = 3;
            } else {
                hasChanges |= this.ledValues[i2] != 2;
                this.ledValues[i2] = 2;
            }
            ++i2;
        }
        if (hasChanges) {
            this.repaint();
        }
        this.resetStatistics();
        this.hasNewEvents = false;
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.t_sample = Double.valueOf(st.nextToken());
            this.t_threshold = Double.valueOf(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_sample + " " + this.t_threshold);
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "sample period [sec]:", "t_sample", "on threshold [sec]:", "t_threshold"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("The multiplexed seven-segment\ndisplays shows all segments on\nduring at least t_threshold\nper t_sample period.\nTimes are in seconds, e.g.\nt_sample = 0.1 seconds\nt_threshold = 0.001 seconds");
        this.propertySheet.setVisible(true);
    }

    public double getT_sample() {
        return this.t_sample;
    }

    public double getT_threshold() {
        return this.t_threshold;
    }

    public void setT_sample(String s) {
        this.t_sample = this.parse(s, 0.1);
    }

    public void setT_threshold(String s) {
        this.t_threshold = this.parse(s, 0.05 * this.t_sample);
    }

    private double parse(String s, double def_value) {
        try {
            return Double.valueOf(s);
        }
        catch (Exception e) {
            return def_value;
        }
    }

    public String getToolTip(Point position, long millis) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName() + "\n");
        sb.append(this.getClass().getName() + "\n");
        sb.append("n_cycles: " + this.n_cycles + "\n");
        sb.append("t_delta: " + this.t_delta + "\n");
        int i = 0;
        while (i < 8) {
            sb.append(names[i] + " active " + this.t_on[i] + " " + this.t_off[i] + "\n");
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return "SevenSegmentMultiplexed: " + this.getFullName();
    }

    class DynSymbol
    extends Symbol {
        DynSymbol() {
        }

        public void paint(Graphics g) {
            int i = 0;
            while (i < SevenSegmentMultiplexed.this.segments.length) {
                FigAttribs attr = SevenSegmentMultiplexed.this.segments[i].getAttributes();
                if (SevenSegmentMultiplexed.this.ledValues[i] == 2) {
                    attr.lineColor = SevenSegmentMultiplexed.this.COLOR_OFF;
                    attr.fillColor = SevenSegmentMultiplexed.this.COLOR_OFF;
                    attr.fig_line_color = 0;
                    attr.fig_fill_color = 0;
                    attr.fig_area_fill = 10;
                } else if (SevenSegmentMultiplexed.this.ledValues[i] == 0) {
                    attr.lineColor = SevenSegmentMultiplexed.this.COLOR_UX;
                    attr.fillColor = SevenSegmentMultiplexed.this.COLOR_UX;
                    attr.fig_line_color = 3;
                    attr.fig_fill_color = 3;
                    attr.fig_area_fill = 20;
                } else {
                    attr.lineColor = SevenSegmentMultiplexed.this.COLOR_ON;
                    attr.fillColor = SevenSegmentMultiplexed.this.COLOR_ON;
                    attr.fig_line_color = 4;
                    attr.fig_fill_color = 4;
                    attr.fig_area_fill = 20;
                }
                SevenSegmentMultiplexed.this.segments[i].setAttributes(attr);
                ++i;
            }
            super.paint(g);
        }
    }
}

