/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.Const1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.ColoredPolyline;
import hades.symbols.Rectangle;
import hades.symbols.Symbol;
import java.awt.Color;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;

public class SevenSegment
extends SimObject
implements Simulatable {
    protected ColoredPolyline[] segments;
    protected FigCompound display;
    protected Color dark_gray;
    protected Color medium_gray;
    protected StdLogic1164 value_U;

    public SevenSegment() {
        this.ports = new Port[9];
        this.ports[0] = new Port(this, "A", 0, null);
        this.ports[1] = new Port(this, "B", 0, null);
        this.ports[2] = new Port(this, "C", 0, null);
        this.ports[3] = new Port(this, "D", 0, null);
        this.ports[4] = new Port(this, "E", 0, null);
        this.ports[5] = new Port(this, "F", 0, null);
        this.ports[6] = new Port(this, "G", 0, null);
        this.ports[7] = new Port(this, "P", 0, null);
        this.ports[8] = new Port(this, "K", 0, null);
        this.value_U = Const1164.__U;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    private void initDisplay() {
        FigAttribs attr;
        this.display = new FigCompound();
        this.display.setTrafo(this.symbol.getTrafo());
        this.dark_gray = new Color(100, 100, 100);
        this.medium_gray = new Color(120, 120, 120);
        this.segments = new ColoredPolyline[8];
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i] = new ColoredPolyline();
            ++i;
        }
        this.segments[0].initialize("2 900 750 2100 750");
        this.segments[1].initialize("2 2100 900 1950 1800");
        this.segments[2].initialize("2 1950 2100 1800 3000");
        this.segments[3].initialize("2 600 3150 1800 3150");
        this.segments[4].initialize("2 750 2100 600 3000");
        this.segments[5].initialize("2 900 900 750 1800");
        this.segments[6].initialize("2 750 1950 1950 1950");
        this.segments[7].initialize("2 2100 3150 2200 3250");
        int i2 = 0;
        while (i2 < this.segments.length) {
            attr = this.segments[i2].getAttributes();
            attr.fillColor = Color.red;
            attr.lineColor = Color.red;
            attr.fig_cap_style = 1;
            attr.fig_line_color = 2;
            attr.fig_fill_color = 2;
            attr.fillStyle = 1;
            attr.currentLayer = 5;
            attr.lineWidth = 150.0;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.segments.length) {
            this.display.fastAddMember(this.segments[i3]);
            ++i3;
        }
        Rectangle r = new Rectangle();
        r.initialize("150 450 2550 3600");
        attr = r.getAttributes();
        attr.fillStyle = 2;
        attr.lineColor = Color.black;
        attr.fig_line_color = 0;
        attr.fillColor = this.dark_gray;
        attr.fig_fill_color = 0;
        attr.fig_area_fill = 20;
        attr.currentLayer = 50;
        r.setAttributes(attr);
        this.display.fastAddMember(r);
        this.display.update_bbox();
        Symbol symbol = this.getSymbol();
        this.display.setObjectPainter(symbol.painter);
        symbol.addMember(this.display);
    }

    private void show() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        Signal signal = this.ports[8].getSignal();
        StdLogic1164 value_kathode = signal != null ? (StdLogic1164)signal.getValue() : this.value_U;
        int i = 0;
        while (i < this.segments.length) {
            signal = this.ports[i].getSignal();
            StdLogic1164 tmp = signal == null ? this.value_U : (StdLogic1164)signal.getValue();
            Color color = value_kathode.is_1() ? (tmp.is_01() ? this.medium_gray : this.value_U.getColor()) : (value_kathode.is_0() ? (tmp.is_0() ? this.medium_gray : tmp.getColor()) : this.value_U.getColor());
            FigAttribs attr = this.segments[i].getAttributes();
            attr.lineColor = color;
            attr.fillColor = color;
            if (color == this.medium_gray) {
                attr.fig_line_color = 0;
                attr.fig_fill_color = 0;
                attr.fig_area_fill = 10;
            } else if (color == this.value_U.getColor()) {
                attr.fig_line_color = 3;
                attr.fig_fill_color = 3;
                attr.fig_area_fill = 20;
            } else {
                attr.fig_line_color = 4;
                attr.fig_fill_color = 4;
                attr.fig_area_fill = 20;
            }
            this.segments[i].setAttributes(attr);
            ++i;
        }
        if (this.getSymbol().painter != null) {
            this.getSymbol().painter.paint(this.display, 60);
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.show();
    }

    public void evaluate(Object arg) {
        if (this.visible) {
            this.show();
        }
    }

    public String toString() {
        return "SevenSegment: " + this.getFullName();
    }
}

