/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.utils.NameMangler;
import java.awt.Point;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RemoteOpin
extends SimObject
implements Wakeable {
    String urlBase = "http://tech-www.informatik.uni-hamburg.de/cgi-bin/dummy";
    String userID = "0815";
    protected PortStdLogic1164[] dports = null;
    protected PortStdLogic1164 port_trigger;
    protected PortStdLogic1164 port_error;
    protected double DELTA = 1.1E-10;
    protected Hashtable _wakeupTable = new Hashtable();
    private static String[] inputNames = new String[]{"A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "B0", "B1", "B2", "B3", "B4", "B5", "B6", "B7", "C0", "C1", "C2", "C3", "C4", "C5", "C6", "C7"};

    public int getNumberOfInputs() {
        return 24;
    }

    public RemoteOpin() {
        this.createPorts();
    }

    public void createPorts() {
        int N_INPUTS = this.getNumberOfInputs();
        this.dports = new PortStdLogic1164[N_INPUTS];
        this.ports = new Port[N_INPUTS + 2];
        int i = 0;
        while (i < N_INPUTS) {
            this.dports[i] = new PortStdLogic1164(this, inputNames[i], 0, null);
            this.ports[i] = this.dports[i];
            ++i;
        }
        this.port_trigger = new PortStdLogic1164(this, "trigger", 1, null);
        this.port_error = new PortStdLogic1164(this, "error", 1, null);
        this.ports[N_INPUTS] = this.port_trigger;
        this.ports[N_INPUTS + 1] = this.port_error;
    }

    public String encodeURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.urlBase);
        sb.append("?");
        sb.append(this.userID);
        sb.append(":");
        sb.append(this.encodeTime(this.getSimTimeOr0()));
        sb.append(":");
        int i = this.getNumberOfInputs() - 1;
        while (i >= 0) {
            StdLogic1164 DI = this.dports[i].getValueOrU();
            sb.append(DI.getChar());
            --i;
        }
        return sb.toString();
    }

    public String encodeTime(double time) {
        return Long.toHexString(Double.doubleToLongBits(time));
    }

    public double getSimTimeOr0() {
        if (this.simulator != null) {
            return this.simulator.getSimTime();
        }
        return 0.0;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String s) {
        this.urlBase = s;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String s) {
        this.userID = s;
    }

    public void elaborate(Object arg) {
        this.simulator = this.parent.getSimulator();
        this.schedule(this.port_trigger, Const1164.__0, 0.0);
        this.schedule(this.port_error, Const1164.__0, 0.0);
    }

    public void evaluate(Object arg) {
        double time = this.getSimTimeOr0() + this.DELTA;
        String hash = this.encodeTime(time);
        Object data = this._wakeupTable.get(hash);
        if (data != null) {
            return;
        }
        this._wakeupTable.put(hash, hash);
        this.simulator.scheduleWakeup(this, time, hash);
        this.schedule(this.port_trigger, Const1164.__1, time);
        this.schedule(this.port_trigger, Const1164.__0, time + 1.0E-9);
    }

    public void wakeup(Object arg) {
        double now = this.getSimTimeOr0();
        this._wakeupTable.remove(this.encodeTime(now));
        String encoded = this.encodeURL();
        try {
            URL url = new URL(encoded);
            url.openConnection().getContent();
            this.schedule(this.port_error, Const1164.__0, now);
        }
        catch (Exception e) {
            System.out.println("RemoteOpin.WAKEUP: " + e);
            e.printStackTrace();
            this.schedule(this.port_error, Const1164.__1, now);
        }
    }

    private void schedule(Port port, StdLogic1164 value, double time) {
        Signal signal = port.getSignal();
        if (signal != null) {
            this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
        }
    }

    public SimObject copy() {
        RemoteOpin clone = (RemoteOpin)super.copy();
        clone.setUrlBase(this.getUrlBase());
        clone.setUserID(this.getUserID());
        return clone;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "URL='" + this.encodeURL() + "'";
    }

    public String toString() {
        return "RemoteOpin: " + this.getFullName();
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.urlBase) + " " + NameMangler.encodeWithUnicodeEscapes(this.userID));
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.urlBase = NameMangler.decodeUnicodeEscapes(st.nextToken());
            this.userID = NameMangler.decodeUnicodeEscapes(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- RemoteOpin.initialize: " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this RemoteOpin...");
        }
        String[] fields = new String[]{"instance name:", "name", "base URL:", "urlBase", "user ID:", "userID"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("no help yet");
        this.propertySheet.setVisible(true);
    }
}

