/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.Random;
import java.util.StringTokenizer;

public class RandomBitGenerator
extends GenericGate
implements Simulatable {
    protected PortStdLogic1164 port_C;
    protected PortStdLogic1164 port_Y;
    protected StdLogic1164 next_Y;
    private long seed = 1235678942131L;
    private float probability = 0.5f;
    private Random random = new Random();

    public RandomBitGenerator() {
        this.random.setSeed(this.seed);
        this.port_C = new PortStdLogic1164(this, "C", 0, null);
        this.port_Y = new PortStdLogic1164(this, "Y", 1, null);
        this.ports = new Port[2];
        this.ports[0] = this.port_C;
        this.ports[1] = this.port_Y;
        this.next_Y = new StdLogic1164();
        this.t_delay = 5.0E-9;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long _seed) {
        this.seed = _seed;
        this.random.setSeed(this.seed);
    }

    public void setSeed(String s) {
        try {
            this.setSeed(Long.parseLong(s.trim()));
        }
        catch (Exception e) {
            this.message("-E- RandomBitGenerator.setSeed: illegal number format: " + s);
            this.message("-W- keeping current value instead...");
        }
    }

    public float getProbability() {
        return this.probability;
    }

    public void setProbability(float p) {
        this.probability = p;
    }

    public void setProbability(String s) {
        try {
            this.setProbability(Float.valueOf(s.trim()).floatValue());
        }
        catch (Exception e) {
            this.message("-E- RandomBitGenerator.setProbability: illegal number format: " + s);
            this.message("-W- using default of 0.5 instead...");
            this.setProbability(0.5f);
        }
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.t_delay = Double.valueOf(st.nextToken());
            this.seed = Long.parseLong(st.nextToken());
            this.probability = Float.valueOf(st.nextToken()).floatValue();
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_delay + " " + this.seed + " " + this.probability);
    }

    public void evaluate(Object arg) {
        SignalStdLogic1164 signal_C = (SignalStdLogic1164)this.port_C.getSignal();
        if (signal_C == null) {
            this.next_Y.setIntValue(1);
        } else if (signal_C.hasRisingEdge()) {
            float r = this.random.nextFloat();
            if (r <= this.probability) {
                this.next_Y.setIntValue(3);
            } else {
                this.next_Y.setIntValue(2);
            }
        } else {
            return;
        }
        if (this.port_Y.getSignal() == null) {
            return;
        }
        this.scheduleOutputValueAfter(this.port_Y, this.next_Y, this.t_delay);
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "gate delay [sec]:", "delay", "generator seed:", "seed", "P(1) [0.0 .. 1.0]:", "probability"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and gate delay:");
        this.propertySheet.setVisible(true);
    }

    public SimObject copy() {
        RandomBitGenerator clone = (RandomBitGenerator)super.copy();
        clone.setDelay(this.getDelay());
        clone.setSeed(this.getSeed());
        clone.setProbability(this.getProbability());
        return clone;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "delay=" + this.t_delay + "\n" + "seed=" + this.seed + "\n" + "P(1)=" + this.probability;
    }
}

