/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.io.Ipin;
import hades.signals.Signal;
import hades.simulator.Assignable;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.utils.StringTokenizer;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;

public class PulseSwitch
extends Ipin
implements Simulatable,
Wakeable,
Assignable {
    protected double t_pulseDefault = 0.1;
    protected double t_pulse = 0.1;

    public PulseSwitch() {
        this.setPulseDuration(this.t_pulseDefault);
    }

    public double getPulseDuration() {
        return this.t_pulse;
    }

    public void setPulseDuration(double t) {
        this.t_pulse = t < 0.0 ? this.t_pulseDefault : t;
    }

    public void setPulseDuration(String s) {
        try {
            this.setPulseDuration(Double.valueOf(s));
        }
        catch (Exception e) {
            this.setPulseDuration(this.t_pulseDefault);
        }
    }

    public void mousePressed(MouseEvent me) {
        this.mouseOrKeyPressed(me.isShiftDown());
    }

    public void keyPressed(KeyEvent ke) {
        this.mouseOrKeyPressed(ke.isShiftDown());
    }

    public void mouseOrKeyPressed(boolean isShiftDown) {
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime();
        this.simulator.scheduleInteractiveEvent(WakeupEvent.getNewWakeupEvent(this, time, this.output_1));
        this.simulator.scheduleInteractiveEvent(WakeupEvent.getNewWakeupEvent(this, time + this.t_pulse, this.output_0));
        Signal signal = this.port_Y.getSignal();
        if (signal == null) {
            return;
        }
        this.simulator.scheduleInteractiveEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, this.output_1, (Object)this.port_Y));
        this.simulator.scheduleInteractiveEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time + this.t_pulse, this.output_0, (Object)this.port_Y));
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.state = 2;
        this.schedule(this.state, 0.0, false);
        this.showState();
    }

    public void evaluate(Object arg) {
        super.evaluate(arg);
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "pulse duration [sec]:", "pulseDuration", "bindkey [a-z0-9]:", "bindkey"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, start value,\nand pulse duration:");
        this.propertySheet.setVisible(true);
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_pulse + " " + this.getBindkey());
    }

    public boolean initialize(String s) {
        block6: {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            try {
                if (n_tokens == 0) {
                    this.versionId = 1001L;
                    break block6;
                }
                if (n_tokens == 1) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    break block6;
                }
                if (n_tokens == 2) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.setPulseDuration(Double.valueOf(st.nextToken()));
                    this.setBindkey(null);
                    break block6;
                }
                if (n_tokens == 3) {
                    this.versionId = Integer.parseInt(st.nextToken());
                    this.setPulseDuration(Double.valueOf(st.nextToken()));
                    this.setBindkey(st.nextToken());
                    break block6;
                }
                throw new Exception("invalid number of arguments");
            }
            catch (Exception e) {
                this.message("-E- PulseSwitch.initialize(): " + e + " " + s);
            }
        }
        return true;
    }

    public String toString() {
        return "PulseSwitch: " + this.getFullName();
    }
}

