/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.Design;
import hades.models.StdLogic1164;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Assignable;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.simulator.WakeupEvent;
import hades.symbols.Circle;
import hades.symbols.ColoredCircle;
import hades.symbols.Symbol;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.Serializable;
import jfig.objects.FigAttribs;

public class PowerOnReset
extends SimObject
implements Assignable,
Wakeable,
Simulatable,
Serializable {
    private Port port_Y;
    private StdLogic1164 output_0;
    private StdLogic1164 output_1;
    private StdLogic1164 output_X;
    private String bindkey;
    private double t_offset = 0.005;
    private double t_active = 0.005;
    private boolean isActive = true;
    private Circle showOnOff;
    private boolean debug = false;

    public PowerOnReset() {
        this.ports = new Port[1];
        this.ports[0] = new Port(this, "nreset", 1, null);
        this.port_Y = this.ports[0];
        this.output_X = Const1164.__X;
        this.output_0 = Const1164.__0;
        this.output_1 = Const1164.__1;
    }

    public PowerOnReset(Design parent, String name) {
        this.parent = parent;
        this.name = name;
        this.ports = new Port[1];
        this.ports[0] = new Port(this, "clk", 1, null);
        this.port_Y = this.ports[0];
        this.output_X = Const1164.__X;
        this.output_0 = Const1164.__0;
        this.output_1 = Const1164.__1;
    }

    public PowerOnReset(Design parent, String name, double t_offset, double t_active) {
        this(parent, name);
        this.t_offset = t_offset;
        this.t_active = t_active;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    public double getT_offset() {
        return this.t_offset;
    }

    public double getT_active() {
        return this.t_active;
    }

    public void setT_offset(double d) {
        this.t_offset = d;
    }

    public void setT_active(double d) {
        this.t_active = d;
    }

    public void setT_offset(String s) {
        this.t_offset = this.parse(s);
    }

    public void setT_active(String s) {
        this.t_active = this.parse(s);
    }

    public double parse(String s) {
        double d = 0.0;
        try {
            d = Double.valueOf(s);
        }
        catch (Exception e) {
            d = 0.0;
        }
        return d;
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.t_offset = Double.valueOf(st.nextToken());
            this.t_active = Double.valueOf(st.nextToken());
            if (st.hasMoreTokens()) {
                this.setBindkey(st.nextToken());
            }
            if (this.debug) {
                this.message("PowerOnReset.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            this.message("-E- PowerOnReset.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.t_offset + " " + this.t_active + " " + this.getBindkey());
    }

    public void configure() {
        if (this.debug) {
            this.message("-I- starting to configure this PowerOnReset...");
        }
        String[] fields = new String[]{"instance name:", "name", "initial offset [sec]:", "t_offset", "reset pulse duration [sec]:", "t_active", "bindkey [a-z0-9]:", "bindkey"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("PowerOnReseterator timing parameters:\nxxxxxxx___________-----------------...\n|      |          |                   \nt=0    t=offset   t=offset+pulse duration,\nplease specify times in seconds.");
        this.propertySheet.setVisible(true);
    }

    public String getBindkey() {
        return this.bindkey;
    }

    public void setBindkey(String s) {
        this.bindkey = NameMangler.getBindkey(this, s);
    }

    public void keyPressed(KeyEvent evt) {
        String tmp;
        if (this.debug) {
            System.out.println("-#- PowerOnReset.keyPressed: " + evt);
        }
        if ((tmp = "" + evt.getKeyChar()).toLowerCase().equals(this.bindkey)) {
            this.mouseOrKeyEvent(evt.isShiftDown());
        } else {
            System.out.println("-#- " + this.toString() + ".keyPressed: mismatch: " + tmp + " vs. " + this.getBindkey());
        }
    }

    public void mousePressed(MouseEvent me) {
        this.mouseOrKeyEvent(me.isShiftDown());
    }

    public void mouseOrKeyEvent(boolean shiftDown) {
        if (this.debug) {
            this.message(this.toString() + ".mousePressed()");
        }
        SimKernel simulator = this.parent.getSimulator();
        double now = simulator.getSimTime();
        if (this.isActive) {
            this.isActive = false;
            this.schedule(now, this.output_0, true);
        } else {
            this.isActive = true;
            this.schedule(now, this.output_1, true);
        }
        this.showState();
    }

    private void initDisplay() {
        this.showOnOff = new ColoredCircle();
        this.showOnOff.initialize("-1950 0 300 300");
        this.getSymbol().addMember(this.showOnOff);
        this.showState();
    }

    private void showState() {
        if (this.getSymbol() == null) {
            return;
        }
        FigAttribs attr = this.showOnOff.getAttributes();
        attr.fillStyle = 2;
        if (this.isActive) {
            attr.fillColor = this.output_1.getColor();
            attr.fig_fill_color = 4;
            attr.fig_area_fill = 20;
        } else {
            attr.fillColor = this.output_0.getColor();
            attr.fig_fill_color = 0;
            attr.fig_area_fill = 5;
        }
        this.showOnOff.setAttributes(attr);
        if (this.showOnOff.painter != null) {
            this.showOnOff.painter.paint(this.showOnOff);
        }
    }

    public void elaborate(Object arg) {
        if (this.debug) {
            System.err.println(this.toString() + ".elaborate()");
        }
        this.schedule(0.0, this.output_X, false);
        this.schedule(this.t_offset, this.output_0, false);
        this.schedule(this.t_offset + this.t_active, this.output_1, false);
    }

    public void evaluate(Object arg) {
        System.err.println(this.toString() + ".evaluate()");
        System.err.println("\n-E- Don't call evaluate() on a PowerOnReset");
    }

    public void wakeup(Object arg) {
        try {
            WakeupEvent we = (WakeupEvent)arg;
            StdLogic1164 sl = (StdLogic1164)we.getArg();
            this.isActive = sl.equals(this.output_1);
            this.showState();
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + e);
        }
    }

    public void schedule(double time, StdLogic1164 value, boolean interactive) {
        SimKernel simulator;
        if (this.debug) {
            this.message("-I- " + this.toString() + ".schedule: " + value);
        }
        if ((simulator = this.parent.getSimulator()) == null) {
            if (this.debug) {
                this.message(this.toString() + "schedule(): SIMULATOR IS NULL!");
            }
            return;
        }
        SignalStdLogic1164 signal = (SignalStdLogic1164)this.port_Y.getSignal();
        if (signal == null) {
            if (this.debug) {
                this.message("-W- PowerOnReset: Port nreset not connected yet");
            }
            return;
        }
        SimEvent1164 se = SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)this.port_Y);
        if (interactive) {
            simulator.scheduleInteractiveEvent(se);
        } else {
            simulator.scheduleEvent(se);
        }
    }

    public void assign(String value, double time) {
        try {
            StdLogic1164 tmp = new StdLogic1164(value.charAt(0));
            this.schedule(time, tmp, false);
            if (this.visible) {
                this.simulator.scheduleWakeup(this, time, tmp);
            }
        }
        catch (Exception e) {
            System.err.println("-E- internal in Ipin.assign: " + e);
        }
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getBindkey();
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "t_offset= " + this.t_offset + "\n" + "t_active= " + this.t_active + "\n" + "bindkey= " + (s == null ? "None" : s);
    }

    public String toString() {
        return "PowerOnReset: " + this.getFullName() + " [timing: " + this.t_offset + "," + this.t_active + "]";
    }
}

