/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.models.OutputConnector;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.ColoredCircle;
import hades.symbols.Symbol;
import java.awt.Color;
import java.awt.Point;
import java.util.Enumeration;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;

public class Opin
extends GenericGate
implements OutputConnector {
    protected StdLogic1164 value = null;
    protected PortStdLogic1164 port_A;
    protected PortStdLogic1164 port_toplevel = new PortStdLogic1164(this, this.name, 1, null);
    protected ColoredCircle showOnOff;

    public Opin() {
        this.port_A = new PortStdLogic1164(this, "A", 0, null);
        this.ports = new Port[2];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_toplevel;
        if (SimObject.debug) {
            this.message("Opin constructor: " + this.ports[0] + "|" + this.ports[1]);
        }
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    public void setName(String name) {
        super.setName(name);
        this.ports[1].setName(name);
    }

    protected void initDisplay() {
        FigObject tmp = null;
        if (this.symbol == null) {
            return;
        }
        Enumeration e = this.symbol.elements();
        while (e.hasMoreElements()) {
            tmp = (FigObject)e.nextElement();
            if (!(tmp instanceof ColoredCircle)) continue;
            this.showOnOff = (ColoredCircle)tmp;
            this.showState(new StdLogic1164());
            break;
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
    }

    public void evaluate(Object arg) {
        Signal signal_toplevel;
        SignalStdLogic1164 signal = (SignalStdLogic1164)this.port_A.getSignal();
        if (signal == null) {
            if (SimObject.debug) {
                this.message("Opin.evaluate(): signal at Port A is null!");
            }
            return;
        }
        this.value = this.port_A.getValueOrU();
        if (this.visible && this.value != null) {
            this.showState(this.value);
        }
        if ((signal_toplevel = this.port_toplevel.getSignal()) == null) {
            return;
        }
        super.scheduleEventAfter(signal_toplevel, 0.0, this.value, this.port_toplevel);
    }

    protected void showState(StdLogic1164 value) {
        if (!this.visible) {
            return;
        }
        if (this.showOnOff == null) {
            this.message(this.toString() + ".showState: showOnOff is null...");
            return;
        }
        FigAttribs attr = this.showOnOff.getAttributes();
        Color color = value.getColor();
        attr.fillStyle = 2;
        attr.fig_area_fill = 20;
        attr.setFillColor(color);
        this.showOnOff.setAttributes(attr);
        if (this.showOnOff.painter != null) {
            this.showOnOff.painter.paint(this.showOnOff);
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "value=" + this.value + "\n" + "delay=" + this.t_delay;
    }

    public String toString() {
        return "Opin: " + this.getFullName();
    }
}

