/*
 * Decompiled with CFR 0.152.
 */
package hades.models.io;

import hades.gui.PropertySheet;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.ColorSource;
import hades.symbols.ColoredCircle;
import hades.symbols.ColoredRectangle;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.io.PrintWriter;
import java.util.Enumeration;
import jfig.objects.FigObject;
import jfig.utils.ExceptionTracer;
import jfig.utils.SetupManager;

public class LED
extends SimObject
implements Simulatable,
ColorSource {
    private PortStdLogic1164 port_A = new PortStdLogic1164(this, "A", 0, null);
    private FigObject showOnOff;
    private static Color[] colors = new Color[4];
    private int colorIndex;

    public LED() {
        this.ports = new Port[1];
        this.ports[0] = this.port_A;
        this.colorIndex = 0;
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    private void initDisplay() {
        FigObject tmp = null;
        if (this.symbol == null) {
            return;
        }
        Enumeration e = this.symbol.elements();
        while (e.hasMoreElements()) {
            tmp = (FigObject)e.nextElement();
            if (tmp instanceof ColoredCircle) {
                this.showOnOff = (ColoredCircle)tmp;
                this.showOnOff.getAttributes().fillStyle = 2;
                ((ColoredCircle)this.showOnOff).setColorSource(this);
                this.showState(new StdLogic1164());
                return;
            }
            if (!(tmp instanceof ColoredRectangle)) continue;
            this.showOnOff = (ColoredRectangle)tmp;
            ((ColoredRectangle)this.showOnOff).setColorSource(this);
            this.showState(new StdLogic1164());
            return;
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.colorIndex);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        int n_tokens = st.countTokens();
        try {
            if (n_tokens < 2) {
                return true;
            }
            this.versionId = Integer.parseInt(st.nextToken());
            this.colorIndex = Integer.parseInt(st.nextToken());
            if (SimObject.debug) {
                this.message("LED.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
            ExceptionTracer.message("-E- in LED.initialize(): " + s);
        }
        return true;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorIndex(String s) {
        try {
            this.colorIndex = Integer.parseInt(s);
        }
        finally {
            if (this.colorIndex < 0 || this.colorIndex > 3) {
                this.message("-E- illegal color index " + this.colorIndex);
                this.message("-I- using 0 (red) instead!");
                this.colorIndex = 0;
            }
        }
        this.evaluate(null);
    }

    public void configure() {
        String[] fields = new String[]{"instance name:", "name", "color index:", "colorIndex"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and color index: \n 0 = red, 1 = green, 2 = yellow, 3 = blue \n");
        this.propertySheet.setVisible(true);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        if (this.visible) {
            this.showState(this.port_A.getValueOrU());
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if (this.visible) {
            this.showState(this.port_A.getValueOrU());
        }
    }

    private void showState(StdLogic1164 value) {
        if (!this.visible) {
            return;
        }
        if (this.symbol == null) {
            return;
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol);
        }
    }

    public Color getColor() {
        StdLogic1164 value = this.port_A.getValueOrU();
        if (value.is_1()) {
            return colors[this.colorIndex];
        }
        if (value.is_0()) {
            return value.getColor();
        }
        return value.getColor();
    }

    public SimObject copy() {
        LED tmp = null;
        try {
            tmp = (LED)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setColorIndex("" + this.getColorIndex());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "LED: " + this.getFullName();
    }

    static {
        LED.colors[0] = SetupManager.getColor("Hades.LED.Color.red", Color.red);
        LED.colors[1] = SetupManager.getColor("Hades.LED.Color.green", Color.green);
        LED.colors[2] = SetupManager.getColor("Hades.LED.Color.yellow", Color.yellow);
        LED.colors[3] = SetupManager.getColor("Hades.LED.Color.blue", Color.blue);
    }
}

